/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.spring.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import jakarta.json.bind.Jsonb;
import java.util.Collections;
import java.util.Optional;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.filters.RetryFilter;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.RecurringJobPostProcessor;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.server.configuration.BackgroundJobServerThreadType;
import org.jobrunr.server.configuration.BackgroundJobServerWorkerPolicy;
import org.jobrunr.server.configuration.DefaultBackgroundJobServerWorkerPolicy;
import org.jobrunr.spring.autoconfigure.JobRunrProperties;
import org.jobrunr.spring.autoconfigure.health.JobRunrHealthIndicator;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.gson.GsonJsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.jobrunr.utils.mapper.jsonb.JsonbJsonMapper;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JobRunrProperties.class})
@ComponentScan(basePackages={"org.jobrunr.scheduling"})
public class JobRunrAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.job-scheduler", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JobScheduler jobScheduler(StorageProvider storageProvider, JobRunrProperties properties) {
        JobDetailsGenerator jobDetailsGenerator = (JobDetailsGenerator)ReflectionUtils.newInstance((String)properties.getJobScheduler().getJobDetailsGenerator(), (Object[])new Object[0]);
        return new JobScheduler(storageProvider, jobDetailsGenerator, Collections.emptyList());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.job-scheduler", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JobRequestScheduler jobRequestScheduler(StorageProvider storageProvider) {
        return new JobRequestScheduler(storageProvider, Collections.emptyList());
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.background-job-server", name={"enabled"}, havingValue="true")
    public BackgroundJobServer backgroundJobServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobActivator jobActivator, BackgroundJobServerConfiguration backgroundJobServerConfiguration, JobRunrProperties properties) {
        BackgroundJobServer backgroundJobServer = new BackgroundJobServer(storageProvider, jobRunrJsonMapper, jobActivator, backgroundJobServerConfiguration);
        backgroundJobServer.setJobFilters(Collections.singletonList(new RetryFilter(properties.getJobs().getDefaultNumberOfRetries(), properties.getJobs().getRetryBackOffTimeSeed())));
        return backgroundJobServer;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.background-job-server", name={"enabled"}, havingValue="true")
    public BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy(JobRunrProperties properties) {
        JobRunrProperties.BackgroundJobServer backgroundJobServerProperties = properties.getBackgroundJobServer();
        BackgroundJobServerThreadType threadType = Optional.ofNullable(backgroundJobServerProperties.getThreadType()).orElse(BackgroundJobServerThreadType.getDefaultThreadType());
        int workerCount = Optional.ofNullable(backgroundJobServerProperties.getWorkerCount()).orElse(threadType.getDefaultWorkerCount());
        return new DefaultBackgroundJobServerWorkerPolicy(workerCount, threadType);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.background-job-server", name={"enabled"}, havingValue="true")
    public BackgroundJobServerConfiguration backgroundJobServerConfiguration(JobRunrProperties properties, BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy) {
        PropertyMapper map = PropertyMapper.get();
        BackgroundJobServerConfiguration backgroundJobServerConfiguration = BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration();
        JobRunrProperties.BackgroundJobServer backgroundJobServerProperties = properties.getBackgroundJobServer();
        backgroundJobServerConfiguration.andBackgroundJobServerWorkerPolicy(backgroundJobServerWorkerPolicy);
        map.from(backgroundJobServerProperties::getName).whenNonNull().to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andName(arg_0));
        map.from(backgroundJobServerProperties::getPollIntervalInSeconds).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPollIntervalInSeconds(arg_0));
        map.from(backgroundJobServerProperties::getDeleteSucceededJobsAfter).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andDeleteSucceededJobsAfter(arg_0));
        map.from(backgroundJobServerProperties::getPermanentlyDeleteDeletedJobsAfter).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPermanentlyDeleteDeletedJobsAfter(arg_0));
        map.from(backgroundJobServerProperties::getScheduledJobsRequestSize).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andScheduledJobsRequestSize(arg_0));
        map.from(backgroundJobServerProperties::getOrphanedJobsRequestSize).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andOrphanedJobsRequestSize(arg_0));
        map.from(backgroundJobServerProperties::getSucceededJobsRequestSize).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andSucceededJobsRequestSize(arg_0));
        map.from(backgroundJobServerProperties::getInterruptJobsAwaitDurationOnStop).to(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andInterruptJobsAwaitDurationOnStopBackgroundJobServer(arg_0));
        return backgroundJobServerConfiguration;
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.dashboard", name={"enabled"}, havingValue="true")
    public JobRunrDashboardWebServer dashboardWebServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration) {
        return new JobRunrDashboardWebServer(storageProvider, jobRunrJsonMapper, dashboardWebServerConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="org.jobrunr.dashboard", name={"enabled"}, havingValue="true")
    public JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration(JobRunrProperties properties) {
        return JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(properties.getDashboard().getPort()).andBasicAuthentication(properties.getDashboard().getUsername(), properties.getDashboard().getPassword()).andAllowAnonymousDataUsage(properties.getMiscellaneous().isAllowAnonymousDataUsage());
    }

    @Bean
    @ConditionalOnMissingBean
    public JobActivator jobActivator(ApplicationContext applicationContext) {
        return arg_0 -> ((ApplicationContext)applicationContext).getBean(arg_0);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMapper jobMapper(JsonMapper jobRunrJsonMapper) {
        return new JobMapper(jobRunrJsonMapper);
    }

    @Bean
    @ConditionalOnBean(value={JobScheduler.class})
    public static RecurringJobPostProcessor recurringJobPostProcessor() {
        return new RecurringJobPostProcessor();
    }

    @Configuration
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnEnabledHealthIndicator(value="jobrunr")
    public static class JobRunrHealthIndicatorAutoConfiguration {
        @Bean(name={"JobRunr"})
        public HealthIndicator healthIndicator(JobRunrProperties properties, ObjectProvider<BackgroundJobServer> backgroundJobServerProvider) {
            return new JobRunrHealthIndicator(properties, backgroundJobServerProvider);
        }
    }

    @ConditionalOnClass(value={Jsonb.class})
    @ConditionalOnResource(resources={"classpath:META-INF/services/jakarta.json.bind.spi.JsonbProvider", "classpath:META-INF/services/jakarta.json.spi.JsonProvider"})
    public static class JobRunrJsonbAutoConfiguration {
        @Bean(name={"jobRunrJsonMapper"})
        @ConditionalOnMissingBean
        public JsonMapper jsonbJsonMapper() {
            return new JsonbJsonMapper();
        }
    }

    @Configuration
    @ConditionalOnClass(value={ObjectMapper.class})
    public static class JobRunrJacksonAutoConfiguration {
        @Bean(name={"jobRunrJsonMapper"})
        @ConditionalOnMissingBean
        public JsonMapper jacksonJsonMapper() {
            return new JacksonJsonMapper();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Gson.class})
    public static class JobRunrGsonAutoConfiguration {
        @Bean(name={"jobRunrJsonMapper"})
        @ConditionalOnMissingBean
        public JsonMapper gsonJsonMapper() {
            return new GsonJsonMapper();
        }
    }
}

