/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.spring.autoconfigure.health;

import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.spring.autoconfigure.JobRunrProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class JobRunrHealthIndicator
implements HealthIndicator {
    private final ObjectProvider<BackgroundJobServer> backgroundJobServerProvider;
    private final JobRunrProperties jobRunrProperties;

    public JobRunrHealthIndicator(JobRunrProperties jobRunrProperties, ObjectProvider<BackgroundJobServer> backgroundJobServerProvider) {
        this.jobRunrProperties = jobRunrProperties;
        this.backgroundJobServerProvider = backgroundJobServerProvider;
    }

    public Health health() {
        Health.Builder health = Health.unknown();
        if (!this.jobRunrProperties.getBackgroundJobServer().isEnabled()) {
            health.up().withDetail("backgroundJobServer", (Object)"disabled");
        } else {
            BackgroundJobServer backgroundJobServer = (BackgroundJobServer)this.backgroundJobServerProvider.getObject();
            if (backgroundJobServer.isRunning()) {
                health.up().withDetail("backgroundJobServer", (Object)"enabled").withDetail("backgroundJobServerStatus", (Object)"running");
            } else {
                health.down().withDetail("backgroundJobServer", (Object)"enabled").withDetail("backgroundJobServerStatus", (Object)"stopped");
            }
        }
        return health.build();
    }
}

