/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.autoconfigure.storage;

import javax.sql.DataSource;
import org.jobrunr.autoconfigure.JobRunrProperties;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.sql.common.DefaultSqlStorageProvider;
import org.jobrunr.storage.sql.common.SqlStorageProviderFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JobRunrSqlStorageAutoConfiguration {
    @Bean(name={"storageProvider"}, destroyMethod="close")
    @ConditionalOnMissingBean
    public StorageProvider sqlStorageProvider(DataSource dataSource, JobMapper jobMapper, JobRunrProperties properties) {
        String tablePrefix = properties.getDatabase().getTablePrefix();
        DefaultSqlStorageProvider.DatabaseOptions databaseOptions = properties.getDatabase().isSkipCreate() ? DefaultSqlStorageProvider.DatabaseOptions.SKIP_CREATE : DefaultSqlStorageProvider.DatabaseOptions.CREATE;
        StorageProvider storageProvider = SqlStorageProviderFactory.using((DataSource)dataSource, (String)tablePrefix, (DefaultSqlStorageProvider.DatabaseOptions)databaseOptions);
        storageProvider.setJobMapper(jobMapper);
        return storageProvider;
    }
}

