/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.autoconfigure.storage;

import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.sql.DataSource;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.quarkus.autoconfigure.JobRunrRuntimeConfiguration;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.StorageProviderUtils;
import org.jobrunr.storage.sql.common.SqlStorageProviderFactory;

public class JobRunrSqlStorageProviderProducer {
    @Produces
    @DefaultBean
    @Singleton
    public StorageProvider storageProvider(@Any Instance<DataSource> dataSources, JobMapper jobMapper, JobRunrRuntimeConfiguration configuration) {
        if (configuration.database().type().isPresent() && !configuration.database().type().get().equalsIgnoreCase("sql")) {
            return null;
        }
        String tablePrefix = configuration.database().tablePrefix().orElse(null);
        StorageProviderUtils.DatabaseOptions databaseOptions = configuration.database().skipCreate() ? StorageProviderUtils.DatabaseOptions.SKIP_CREATE : StorageProviderUtils.DatabaseOptions.CREATE;
        StorageProvider storageProvider = SqlStorageProviderFactory.using((DataSource)this.getDataSource(dataSources, configuration), (String)tablePrefix, (StorageProviderUtils.DatabaseOptions)databaseOptions);
        storageProvider.setJobMapper(jobMapper);
        return storageProvider;
    }

    private DataSource getDataSource(Instance<DataSource> dataSources, JobRunrRuntimeConfiguration configuration) {
        return (DataSource)dataSources.select(DataSource.class, new Annotation[]{JobRunrSqlStorageProviderProducer.toAnnotationQualifier(configuration.database().datasource())}).get();
    }

    private static Annotation toAnnotationQualifier(Optional<String> dataSourceName) {
        return dataSourceName.map(datasource -> JobRunrSqlStorageProviderProducer.namedInstance(datasource)).orElse(JobRunrSqlStorageProviderProducer.defaultInstance());
    }

    private static Annotation defaultInstance() {
        return new Default(){

            public Class<? extends Annotation> annotationType() {
                return Default.class;
            }
        };
    }

    private static Annotation namedInstance(final String name) {
        return new Named(){

            public Class<? extends Annotation> annotationType() {
                return Named.class;
            }

            public String value() {
                return name;
            }

            public String toString() {
                return "@javax.inject.Named(\"" + name + "\")";
            }
        };
    }
}

