/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.autoconfigure;

import io.quarkus.arc.DefaultBean;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.jobs.details.CachingJobDetailsGenerator;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.filters.RetryFilter;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.quarkus.autoconfigure.JobRunrBuildTimeConfiguration;
import org.jobrunr.quarkus.autoconfigure.JobRunrRuntimeConfiguration;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.server.configuration.BackgroundJobServerThreadType;
import org.jobrunr.server.configuration.BackgroundJobServerWorkerPolicy;
import org.jobrunr.server.configuration.DefaultBackgroundJobServerWorkerPolicy;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.jobrunr.utils.mapper.jsonb.JsonbJsonMapper;
import org.jobrunr.utils.reflection.ReflectionUtils;

@Singleton
public class JobRunrProducer {
    @Inject
    JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration;
    @Inject
    JobRunrRuntimeConfiguration jobRunrRuntimeConfiguration;

    @Produces
    @DefaultBean
    @Singleton
    public JobScheduler jobScheduler(StorageProvider storageProvider) {
        if (this.jobRunrBuildTimeConfiguration.jobScheduler().enabled()) {
            JobDetailsGenerator jobDetailsGenerator = (JobDetailsGenerator)ReflectionUtils.newInstance((String)this.jobRunrRuntimeConfiguration.jobScheduler().jobDetailsGenerator().orElse(CachingJobDetailsGenerator.class.getName()), (Object[])new Object[0]);
            return new JobScheduler(storageProvider, jobDetailsGenerator, Collections.emptyList());
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    public JobRequestScheduler jobRequestScheduler(StorageProvider storageProvider) {
        if (this.jobRunrBuildTimeConfiguration.jobScheduler().enabled()) {
            return new JobRequestScheduler(storageProvider, Collections.emptyList());
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy() {
        if (this.jobRunrBuildTimeConfiguration.backgroundJobServer().enabled()) {
            BackgroundJobServerThreadType threadType = this.jobRunrRuntimeConfiguration.backgroundJobServer().threadType().orElse(BackgroundJobServerThreadType.getDefaultThreadType());
            int workerCount = this.jobRunrRuntimeConfiguration.backgroundJobServer().workerCount().orElse(threadType.getDefaultWorkerCount());
            return new DefaultBackgroundJobServerWorkerPolicy(workerCount, threadType);
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    BackgroundJobServerConfiguration backgroundJobServerConfiguration(BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy) {
        if (this.jobRunrBuildTimeConfiguration.backgroundJobServer().enabled()) {
            BackgroundJobServerConfiguration backgroundJobServerConfiguration = BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration();
            backgroundJobServerConfiguration.andBackgroundJobServerWorkerPolicy(backgroundJobServerWorkerPolicy);
            this.jobRunrRuntimeConfiguration.backgroundJobServer().name().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andName(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().pollIntervalInSeconds().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPollIntervalInSeconds(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().deleteSucceededJobsAfter().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andDeleteSucceededJobsAfter(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().permanentlyDeleteDeletedJobsAfter().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPermanentlyDeleteDeletedJobsAfter(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().scheduledJobsRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andScheduledJobsRequestSize(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().orphanedJobsRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andOrphanedJobsRequestSize(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().succeededJobRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andSucceededJobsRequestSize(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().interruptJobsAwaitDurationOnStop().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andInterruptJobsAwaitDurationOnStopBackgroundJobServer(arg_0));
            return backgroundJobServerConfiguration;
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    BackgroundJobServer backgroundJobServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobActivator jobActivator, BackgroundJobServerConfiguration backgroundJobServerConfiguration) {
        if (this.jobRunrBuildTimeConfiguration.backgroundJobServer().enabled()) {
            int defaultNbrOfRetries = this.jobRunrRuntimeConfiguration.jobs().defaultNumberOfRetries().orElse(10);
            int retryBackOffTimeSeed = this.jobRunrRuntimeConfiguration.jobs().retryBackOffTimeSeed().orElse(3);
            BackgroundJobServer backgroundJobServer = new BackgroundJobServer(storageProvider, jobRunrJsonMapper, jobActivator, backgroundJobServerConfiguration);
            backgroundJobServer.setJobFilters(Collections.singletonList(new RetryFilter(defaultNbrOfRetries, retryBackOffTimeSeed)));
            return backgroundJobServer;
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration() {
        if (this.jobRunrBuildTimeConfiguration.dashboard().enabled()) {
            JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration = JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration();
            this.jobRunrRuntimeConfiguration.dashboard().port().ifPresent(arg_0 -> ((JobRunrDashboardWebServerConfiguration)dashboardWebServerConfiguration).andPort(arg_0));
            if (this.jobRunrRuntimeConfiguration.dashboard().username().isPresent() && this.jobRunrRuntimeConfiguration.dashboard().password().isPresent()) {
                dashboardWebServerConfiguration.andBasicAuthentication(this.jobRunrRuntimeConfiguration.dashboard().username().get(), this.jobRunrRuntimeConfiguration.dashboard().password().get());
            }
            dashboardWebServerConfiguration.andAllowAnonymousDataUsage(this.jobRunrRuntimeConfiguration.miscellaneous().allowAnonymousDataUsage());
            return dashboardWebServerConfiguration;
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    JobRunrDashboardWebServer dashboardWebServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration) {
        if (this.jobRunrBuildTimeConfiguration.dashboard().enabled()) {
            return new JobRunrDashboardWebServer(storageProvider, jobRunrJsonMapper, dashboardWebServerConfiguration);
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    public JobActivator jobActivator() {
        return new JobActivator(){

            public <T> T activateJob(Class<T> aClass) {
                return (T)CDI.current().select(aClass, new Annotation[0]).get();
            }
        };
    }

    @Produces
    @DefaultBean
    @Singleton
    public JobMapper jobMapper(JsonMapper jobRunrJsonMapper) {
        return new JobMapper(jobRunrJsonMapper);
    }

    public static class JobRunrJacksonJsonMapperProducer {
        @Produces
        @DefaultBean
        @Singleton
        public JsonMapper jobRunrJsonMapper() {
            return new JacksonJsonMapper();
        }
    }

    public static class JobRunrJsonBJsonMapperProducer {
        @Produces
        @DefaultBean
        @Singleton
        public JsonMapper jobRunrJsonMapper() {
            return new JsonbJsonMapper();
        }
    }
}

