/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.autoconfigure;

import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.Optional;
import org.jobrunr.server.configuration.BackgroundJobServerThreadType;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
@ConfigMapping(prefix="quarkus.jobrunr")
public interface JobRunrRuntimeConfiguration {
    public DatabaseConfiguration database();

    public JobsConfiguration jobs();

    public JobSchedulerConfiguration jobScheduler();

    public BackgroundJobServerConfiguration backgroundJobServer();

    public DashboardConfiguration dashboard();

    public MiscellaneousConfiguration miscellaneous();

    public static interface MiscellaneousConfiguration {
        @WithDefault(value="true")
        public boolean allowAnonymousDataUsage();
    }

    public static interface DashboardConfiguration {
        public Optional<Integer> port();

        public Optional<String> username();

        public Optional<String> password();
    }

    public static interface BackgroundJobServerConfiguration {
        public Optional<String> name();

        public Optional<Integer> workerCount();

        public Optional<BackgroundJobServerThreadType> threadType();

        public Optional<Integer> scheduledJobsRequestSize();

        public Optional<Integer> orphanedJobsRequestSize();

        public Optional<Integer> succeededJobRequestSize();

        public Optional<Integer> pollIntervalInSeconds();

        public Optional<Duration> deleteSucceededJobsAfter();

        public Optional<Duration> permanentlyDeleteDeletedJobsAfter();

        public Optional<Duration> interruptJobsAwaitDurationOnStop();
    }

    public static interface JobSchedulerConfiguration {
        public Optional<String> jobDetailsGenerator();
    }

    public static interface JobsConfiguration {
        public Optional<Integer> defaultNumberOfRetries();

        public Optional<Integer> retryBackOffTimeSeed();
    }

    public static interface DatabaseConfiguration {
        @WithDefault(value="false")
        public boolean skipCreate();

        public Optional<String> databaseName();

        public Optional<String> tablePrefix();

        public Optional<String> datasource();

        public Optional<String> type();
    }
}

