/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.autoconfigure;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.quarkus.autoconfigure.JobRunrBuildTimeConfiguration;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.storage.StorageProvider;

@Dependent
public class JobRunrStarter {
    JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration;
    Instance<BackgroundJobServer> backgroundJobServerInstance;
    Instance<JobRunrDashboardWebServer> dashboardWebServerInstance;
    Instance<StorageProvider> storageProviderInstance;

    public JobRunrStarter(JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration, Instance<BackgroundJobServer> backgroundJobServerInstance, Instance<JobRunrDashboardWebServer> dashboardWebServerInstance, Instance<StorageProvider> storageProviderInstance) {
        this.jobRunrBuildTimeConfiguration = jobRunrBuildTimeConfiguration;
        this.backgroundJobServerInstance = backgroundJobServerInstance;
        this.dashboardWebServerInstance = dashboardWebServerInstance;
        this.storageProviderInstance = storageProviderInstance;
    }

    void startup(@Observes StartupEvent event) {
        if (this.jobRunrBuildTimeConfiguration.backgroundJobServer().enabled()) {
            ((BackgroundJobServer)this.backgroundJobServerInstance.get()).start();
        }
        if (this.jobRunrBuildTimeConfiguration.dashboard().enabled()) {
            ((JobRunrDashboardWebServer)this.dashboardWebServerInstance.get()).start();
        }
    }

    void shutdown(@Observes ShutdownEvent event) {
        if (this.jobRunrBuildTimeConfiguration.backgroundJobServer().enabled()) {
            ((BackgroundJobServer)this.backgroundJobServerInstance.get()).stop();
        }
        if (this.jobRunrBuildTimeConfiguration.dashboard().enabled()) {
            ((JobRunrDashboardWebServer)this.dashboardWebServerInstance.get()).stop();
        }
        ((StorageProvider)this.storageProviderInstance.get()).close();
    }
}

