/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.autoconfigure;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.quarkus.autoconfigure.JobRunrBuildTimeConfiguration;
import org.jobrunr.quarkus.autoconfigure.JobRunrRuntimeConfiguration;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.storage.StorageProvider;

@Dependent
public class JobRunrStarter {
    JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration;
    JobRunrRuntimeConfiguration jobRunrRuntimeConfiguration;
    Instance<BackgroundJobServer> backgroundJobServerInstance;
    Instance<JobRunrDashboardWebServer> dashboardWebServerInstance;
    Instance<StorageProvider> storageProviderInstance;

    public JobRunrStarter(JobRunrBuildTimeConfiguration jobRunrBuildTimeConfiguration, JobRunrRuntimeConfiguration jobRunrRuntimeConfiguration, Instance<BackgroundJobServer> backgroundJobServerInstance, Instance<JobRunrDashboardWebServer> dashboardWebServerInstance, Instance<StorageProvider> storageProviderInstance) {
        this.jobRunrBuildTimeConfiguration = jobRunrBuildTimeConfiguration;
        this.jobRunrRuntimeConfiguration = jobRunrRuntimeConfiguration;
        this.backgroundJobServerInstance = backgroundJobServerInstance;
        this.dashboardWebServerInstance = dashboardWebServerInstance;
        this.storageProviderInstance = storageProviderInstance;
    }

    void startup(@Observes StartupEvent event) {
        if (!this.jobRunrBuildTimeConfiguration.backgroundJobServer().included() && this.jobRunrRuntimeConfiguration.backgroundJobServer().enabled()) {
            throw new IllegalStateException("The BackgroundJobServer cannot be enabled, its resources were not included at build time. Please rebuild your project to include the required resources or disable the BackgroundJobServer.");
        }
        if (this.jobRunrRuntimeConfiguration.backgroundJobServer().enabled()) {
            ((BackgroundJobServer)this.backgroundJobServerInstance.get()).start();
        }
        if (!this.jobRunrBuildTimeConfiguration.dashboard().included() && this.jobRunrRuntimeConfiguration.dashboard().enabled()) {
            throw new IllegalStateException("The JobRunrDashboardWebServer cannot be enabled, its resources were not included at build time. Please rebuild your project to include the required resources or disable the JobRunrDashboardWebServer.");
        }
        if (this.jobRunrRuntimeConfiguration.dashboard().enabled()) {
            ((JobRunrDashboardWebServer)this.dashboardWebServerInstance.get()).start();
        }
    }

    void shutdown(@Observes ShutdownEvent event) {
        if (this.backgroundJobServerInstance.isResolvable() && this.jobRunrRuntimeConfiguration.backgroundJobServer().enabled()) {
            ((BackgroundJobServer)this.backgroundJobServerInstance.get()).stop();
        }
        if (this.dashboardWebServerInstance.isResolvable() && this.jobRunrRuntimeConfiguration.dashboard().enabled()) {
            ((JobRunrDashboardWebServer)this.dashboardWebServerInstance.get()).stop();
        }
        ((StorageProvider)this.storageProviderInstance.get()).close();
    }
}

