/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.autoconfigure.dashboard;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.lookup.LookupIfProperty;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.quarkus.autoconfigure.JobRunrRuntimeConfiguration;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;

@Singleton
public class JobRunrDashboardProducer {
    @Inject
    JobRunrRuntimeConfiguration jobRunrRuntimeConfiguration;

    @Produces
    @DefaultBean
    @Singleton
    JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration() {
        if (this.jobRunrRuntimeConfiguration.dashboard().enabled()) {
            JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration = JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration();
            this.jobRunrRuntimeConfiguration.dashboard().port().ifPresent(arg_0 -> ((JobRunrDashboardWebServerConfiguration)dashboardWebServerConfiguration).andPort(arg_0));
            if (this.jobRunrRuntimeConfiguration.dashboard().username().isPresent() && this.jobRunrRuntimeConfiguration.dashboard().password().isPresent()) {
                dashboardWebServerConfiguration.andBasicAuthentication(this.jobRunrRuntimeConfiguration.dashboard().username().get(), this.jobRunrRuntimeConfiguration.dashboard().password().get());
            }
            dashboardWebServerConfiguration.andAllowAnonymousDataUsage(this.jobRunrRuntimeConfiguration.miscellaneous().allowAnonymousDataUsage());
            return dashboardWebServerConfiguration;
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    @LookupIfProperty(name="quarkus.jobrunr.dashboard.enabled", stringValue="true")
    JobRunrDashboardWebServer dashboardWebServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobRunrDashboardWebServerConfiguration dashboardWebServerConfiguration) {
        if (this.jobRunrRuntimeConfiguration.dashboard().enabled()) {
            return new JobRunrDashboardWebServer(storageProvider, jobRunrJsonMapper, dashboardWebServerConfiguration);
        }
        return null;
    }
}

