/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.autoconfigure.server;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.lookup.LookupIfProperty;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import org.jobrunr.jobs.filters.RetryFilter;
import org.jobrunr.quarkus.autoconfigure.JobRunrRuntimeConfiguration;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.server.configuration.BackgroundJobServerThreadType;
import org.jobrunr.server.configuration.BackgroundJobServerWorkerPolicy;
import org.jobrunr.server.configuration.DefaultBackgroundJobServerWorkerPolicy;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;

@Singleton
public class JobRunrBackgroundJobServerProducer {
    @Inject
    JobRunrRuntimeConfiguration jobRunrRuntimeConfiguration;

    @Produces
    @DefaultBean
    @Singleton
    BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy() {
        if (this.jobRunrRuntimeConfiguration.backgroundJobServer().enabled()) {
            BackgroundJobServerThreadType threadType = this.jobRunrRuntimeConfiguration.backgroundJobServer().threadType().orElse(BackgroundJobServerThreadType.getDefaultThreadType());
            int workerCount = this.jobRunrRuntimeConfiguration.backgroundJobServer().workerCount().orElse(threadType.getDefaultWorkerCount());
            return new DefaultBackgroundJobServerWorkerPolicy(workerCount, threadType);
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    BackgroundJobServerConfiguration backgroundJobServerConfiguration(BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy) {
        if (this.jobRunrRuntimeConfiguration.backgroundJobServer().enabled()) {
            BackgroundJobServerConfiguration backgroundJobServerConfiguration = BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration();
            backgroundJobServerConfiguration.andBackgroundJobServerWorkerPolicy(backgroundJobServerWorkerPolicy);
            this.jobRunrRuntimeConfiguration.backgroundJobServer().name().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andName(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().pollIntervalInSeconds().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPollIntervalInSeconds(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().serverTimeoutPollIntervalMultiplicand().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andServerTimeoutPollIntervalMultiplicand(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().deleteSucceededJobsAfter().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andDeleteSucceededJobsAfter(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().permanentlyDeleteDeletedJobsAfter().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andPermanentlyDeleteDeletedJobsAfter(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().scheduledJobsRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andScheduledJobsRequestSize(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().orphanedJobsRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andOrphanedJobsRequestSize(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().succeededJobRequestSize().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andSucceededJobsRequestSize(arg_0));
            this.jobRunrRuntimeConfiguration.backgroundJobServer().interruptJobsAwaitDurationOnStop().ifPresent(arg_0 -> ((BackgroundJobServerConfiguration)backgroundJobServerConfiguration).andInterruptJobsAwaitDurationOnStopBackgroundJobServer(arg_0));
            return backgroundJobServerConfiguration;
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    @LookupIfProperty(name="quarkus.jobrunr.background-job-server.enabled", stringValue="true")
    BackgroundJobServer backgroundJobServer(StorageProvider storageProvider, JsonMapper jobRunrJsonMapper, JobActivator jobActivator, BackgroundJobServerConfiguration backgroundJobServerConfiguration) {
        if (this.jobRunrRuntimeConfiguration.backgroundJobServer().enabled()) {
            int defaultNbrOfRetries = this.jobRunrRuntimeConfiguration.jobs().defaultNumberOfRetries().orElse(10);
            int retryBackOffTimeSeed = this.jobRunrRuntimeConfiguration.jobs().retryBackOffTimeSeed().orElse(3);
            BackgroundJobServer backgroundJobServer = new BackgroundJobServer(storageProvider, jobRunrJsonMapper, jobActivator, backgroundJobServerConfiguration);
            backgroundJobServer.setJobFilters(Collections.singletonList(new RetryFilter(defaultNbrOfRetries, retryBackOffTimeSeed)));
            return backgroundJobServer;
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    public JobActivator jobActivator() {
        return new JobActivator(){

            public <T> T activateJob(Class<T> aClass) {
                return (T)CDI.current().select(aClass, new Annotation[0]).get();
            }
        };
    }
}

