/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.quarkus.autoconfigure;

import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.lookup.LookupIfProperty;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import org.jobrunr.jobs.details.CachingJobDetailsGenerator;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.kotlin.utils.mapper.KotlinxSerializationJsonMapper;
import org.jobrunr.quarkus.autoconfigure.JobRunrRuntimeConfiguration;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.jobrunr.utils.mapper.jsonb.JsonbJsonMapper;
import org.jobrunr.utils.reflection.ReflectionUtils;

@Singleton
public class JobRunrProducer {
    @Inject
    JobRunrRuntimeConfiguration jobRunrRuntimeConfiguration;

    @Produces
    @DefaultBean
    @Singleton
    @LookupIfProperty(name="quarkus.jobrunr.job-scheduler.enabled", stringValue="true")
    public JobScheduler jobScheduler(StorageProvider storageProvider) {
        if (this.jobRunrRuntimeConfiguration.jobScheduler().enabled()) {
            JobDetailsGenerator jobDetailsGenerator = (JobDetailsGenerator)ReflectionUtils.newInstance((String)this.jobRunrRuntimeConfiguration.jobScheduler().jobDetailsGenerator().orElse(CachingJobDetailsGenerator.class.getName()), (Object[])new Object[0]);
            return new JobScheduler(storageProvider, jobDetailsGenerator, Collections.emptyList());
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    @LookupIfProperty(name="quarkus.jobrunr.job-scheduler.enabled", stringValue="true")
    public JobRequestScheduler jobRequestScheduler(StorageProvider storageProvider) {
        if (this.jobRunrRuntimeConfiguration.jobScheduler().enabled()) {
            return new JobRequestScheduler(storageProvider, Collections.emptyList());
        }
        return null;
    }

    @Produces
    @DefaultBean
    @Singleton
    public JobMapper jobMapper(JsonMapper jobRunrJsonMapper) {
        return new JobMapper(jobRunrJsonMapper);
    }

    public static class JobRunrKotlinxSerializataionJsonMapperProducer {
        @Produces
        @DefaultBean
        @Singleton
        public JsonMapper jobRunrJsonMapper() {
            return new KotlinxSerializationJsonMapper();
        }
    }

    public static class JobRunrJacksonJsonMapperProducer {
        @Produces
        @DefaultBean
        @Singleton
        public JsonMapper jobRunrJsonMapper() {
            return new JacksonJsonMapper();
        }
    }

    public static class JobRunrJsonBJsonMapperProducer {
        @Produces
        @DefaultBean
        @Singleton
        public JsonMapper jobRunrJsonMapper() {
            return new JsonbJsonMapper();
        }
    }
}

