/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.common.expression.Expression;
import java.lang.annotation.Annotation;
import java.time.ZoneId;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.RecurringJob;
import org.jobrunr.quarkus.autoconfigure.JobRunrRuntimeConfiguration;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.Schedule;
import org.jobrunr.scheduling.ScheduleExpressionType;
import org.jobrunr.utils.StringUtils;

@Recorder
public class JobRunrRecurringJobRecorder {
    private static final Logger LOGGER = Logger.getLogger(JobRunrRecurringJobRecorder.class);
    JobRunrRuntimeConfiguration jobRunrRuntimeConfiguration;

    public JobRunrRecurringJobRecorder(JobRunrRuntimeConfiguration jobRunrRuntimeConfiguration) {
        this.jobRunrRuntimeConfiguration = jobRunrRuntimeConfiguration;
    }

    public void schedule(BeanContainer container, String id, String cron, String interval, String zoneId, String className, String methodName, List<JobParameter> parameterList) {
        String optionalInterval;
        if (!this.jobRunrRuntimeConfiguration.jobScheduler().enabled()) {
            return;
        }
        JobScheduler scheduler = (JobScheduler)container.beanInstance(JobScheduler.class, new Annotation[0]);
        String jobId = JobRunrRecurringJobRecorder.getId(id);
        String optionalCronExpression = JobRunrRecurringJobRecorder.getCronExpression(cron);
        String scheduleExpression = ScheduleExpressionType.selectConfiguredScheduleExpression((String)optionalCronExpression, (String)(optionalInterval = JobRunrRecurringJobRecorder.getInterval(interval)));
        if ("-".equals(scheduleExpression)) {
            if (StringUtils.isNullOrEmpty((String)jobId)) {
                LOGGER.warn((Object)"You are trying to disable a recurring job using placeholders but did not define an id.");
            } else {
                scheduler.deleteRecurringJob(jobId);
            }
        } else {
            JobDetails jobDetails = new JobDetails(className, null, methodName, parameterList);
            jobDetails.setCacheable(true);
            Schedule schedule = ScheduleExpressionType.createScheduleFromString((String)scheduleExpression);
            RecurringJob recurringJob = new RecurringJob(id, jobDetails, schedule, JobRunrRecurringJobRecorder.getZoneId(zoneId), RecurringJob.CreatedBy.ANNOTATION);
            scheduler.scheduleRecurrently(recurringJob);
        }
    }

    private static String getId(String id) {
        return JobRunrRecurringJobRecorder.resolveStringValue(id);
    }

    private static String getCronExpression(String cron) {
        return JobRunrRecurringJobRecorder.resolveStringValue(cron);
    }

    private static String getInterval(String interval) {
        return JobRunrRecurringJobRecorder.resolveStringValue(interval);
    }

    private static ZoneId getZoneId(String zoneId) {
        return StringUtils.isNullOrEmpty((String)zoneId) ? ZoneId.systemDefault() : ZoneId.of(JobRunrRecurringJobRecorder.resolveStringValue(zoneId));
    }

    private static String resolveStringValue(String expr) {
        if (StringUtils.isNotNullOrEmpty((String)expr)) {
            Config config = ConfigProvider.getConfig();
            Expression expression = Expression.compile((String)expr, (Expression.Flag[])new Expression.Flag[0]);
            return expression.evaluate((resolveContext, stringBuilder) -> {
                Optional resolve = config.getOptionalValue(resolveContext.getKey(), String.class);
                if (resolve.isPresent()) {
                    stringBuilder.append((String)resolve.get());
                } else if (resolveContext.hasDefault()) {
                    resolveContext.expandDefault();
                } else {
                    throw new NoSuchElementException(String.format("Could not expand value %s in property %s", resolveContext.getKey(), expr));
                }
            });
        }
        return expr;
    }
}

