/*
 * Decompiled with CFR 0.152.
 */
package lt.velykis.maven.skins.reflow;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;
import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

@DefaultKey(value="htmlTool")
public class HtmlTool
extends SafeConfig {
    private static List<String> HEADINGS = Collections.unmodifiableList(Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6"));
    private String outputEncoding = "UTF-8";
    private static final Pattern NONLATIN = Pattern.compile("[^\\w-]");
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]");

    protected void configure(ValueParser values) {
        Object velocityContext = values.get("velocityContext");
        if (!(velocityContext instanceof ToolContext)) {
            return;
        }
        ToolContext ctxt = (ToolContext)velocityContext;
        Object outputEncodingObj = ctxt.get("outputEncoding");
        if (outputEncodingObj instanceof String) {
            this.outputEncoding = (String)outputEncodingObj;
        }
    }

    public List<String> split(String content, String separatorCssSelector) {
        return this.split(content, separatorCssSelector, JoinSeparator.NO);
    }

    public List<String> splitOnStarts(String content, String separatorCssSelector) {
        List<String> result = this.split(content, separatorCssSelector, JoinSeparator.AFTER);
        if (result == null || result.size() <= 1) {
            return result;
        }
        return result.subList(1, result.size());
    }

    public List<String> split(String content, String separatorCssSelector, String separatorStrategy) {
        JoinSeparator sepStrategy = "before".equals(separatorStrategy) ? JoinSeparator.BEFORE : ("after".equals(separatorStrategy) ? JoinSeparator.AFTER : JoinSeparator.NO);
        return this.split(content, separatorCssSelector, sepStrategy);
    }

    public List<String> split(String content, String separatorCssSelector, JoinSeparator separatorStrategy) {
        Element body = this.parseContent(content);
        Elements separators = body.select(separatorCssSelector);
        if (separators.size() > 0) {
            List<List<Element>> partitions = HtmlTool.split((Collection<Element>)separators, separatorStrategy, body);
            ArrayList<String> sectionHtml = new ArrayList<String>();
            for (List<Element> partition : partitions) {
                sectionHtml.add(HtmlTool.outerHtml(partition));
            }
            return sectionHtml;
        }
        return Collections.singletonList(content);
    }

    private static List<List<Element>> split(Collection<Element> separators, JoinSeparator separatorStrategy, Element parent) {
        LinkedList<List<Element>> partitions = new LinkedList<List<Element>>();
        for (Element child : parent.children()) {
            if (separators.contains(child)) {
                HtmlTool.getLastPartition(partitions);
                if (separatorStrategy == JoinSeparator.BEFORE) {
                    HtmlTool.getLastPartition(partitions).add(child);
                }
                LinkedList<Element> newPartition = new LinkedList<Element>();
                partitions.add(newPartition);
                if (separatorStrategy != JoinSeparator.AFTER) continue;
                newPartition.add(child);
                continue;
            }
            List<List<Element>> childPartitions = HtmlTool.split(separators, separatorStrategy, child);
            HtmlTool.getLastPartition(partitions).add(child);
            if (childPartitions.size() <= 1) continue;
            Elements allChildren = child.children();
            List<Element> firstPartition = childPartitions.get(0);
            allChildren.removeAll(firstPartition);
            for (Element element : allChildren) {
                element.remove();
            }
            for (List list : childPartitions.subList(1, childPartitions.size())) {
                partitions.add(list);
            }
        }
        return partitions;
    }

    private static List<Element> getLastPartition(List<List<Element>> partitions) {
        if (partitions.isEmpty()) {
            LinkedList<Element> newPartition = new LinkedList<Element>();
            partitions.add(newPartition);
            return newPartition;
        }
        return partitions.get(partitions.size() - 1);
    }

    private static String outerHtml(List<Element> elements) {
        switch (elements.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return elements.get(0).outerHtml();
            }
        }
        Element root = new Element(Tag.valueOf((String)"div"), "");
        for (Element elem : elements) {
            root.appendChild((Node)elem);
        }
        return root.html();
    }

    public String reorderToTop(String content, String selector, int amount) {
        return this.reorderToTop(content, selector, amount, null);
    }

    public String reorderToTop(String content, String selector, int amount, String wrapRemaining) {
        List<Element> extracted = this.extractElements(content, selector, amount);
        if (extracted.size() > 1) {
            Element body = extracted.get(0);
            if (wrapRemaining != null) {
                HtmlTool.wrapInner(body, wrapRemaining);
            }
            List<Element> elements = extracted.subList(1, extracted.size());
            for (int index = elements.size() - 1; index >= 0; --index) {
                body.prependChild((Node)elements.get(index));
            }
            return body.html();
        }
        return content;
    }

    private static Element wrapInner(Element element, String html) {
        Element topDiv = new Element(Tag.valueOf((String)"div"), "");
        for (Element topElem : element.children()) {
            topElem.remove();
            topDiv.appendChild((Node)topElem);
        }
        element.appendChild((Node)topDiv);
        topDiv.wrap(html);
        topDiv.unwrap();
        return element;
    }

    private List<Element> extractElements(String content, String selector, int amount) {
        Element body = this.parseContent(content);
        Object elements = body.select(selector);
        if (elements.size() > 0) {
            elements = HtmlTool.filterParents((List<Element>)elements);
            if (amount >= 0) {
                elements = elements.subList(0, Math.min(amount, elements.size()));
            }
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                element.remove();
            }
        }
        ArrayList<Element> results = new ArrayList<Element>();
        results.add(body);
        results.addAll((Collection<Element>)elements);
        return results;
    }

    private static List<Element> filterParents(List<Element> elements) {
        ArrayList<Element> filtered = new ArrayList<Element>();
        for (Element element : elements) {
            Elements parentsInter = element.parents();
            parentsInter.retainAll(elements);
            if (!parentsInter.isEmpty()) continue;
            filtered.add(element);
        }
        return filtered;
    }

    public ExtractResult extract(String content, String selector, int amount) {
        List<Element> extracted = this.extractElements(content, selector, amount);
        if (extracted.size() > 1) {
            Element body = extracted.get(0);
            List<Element> elements = extracted.subList(1, extracted.size());
            ArrayList<String> elementStr = new ArrayList<String>();
            for (Element el : elements) {
                elementStr.add(el.outerHtml());
            }
            return new DefaultExtractResult(elementStr, body.html());
        }
        return new DefaultExtractResult(Collections.<String>emptyList(), content);
    }

    public String setAttr(String content, String selector, String attributeKey, String value) {
        Element body = this.parseContent(content);
        Elements elements = body.select(selector);
        if (elements.size() > 0) {
            for (Element element : elements) {
                element.attr(attributeKey, value);
            }
            return body.html();
        }
        return content;
    }

    private Element parseContent(String content) {
        Document doc = Jsoup.parseBodyFragment((String)content);
        doc.outputSettings().charset(this.outputEncoding);
        return doc.body();
    }

    public List<String> getAttr(String content, String selector, String attributeKey) {
        Element body = this.parseContent(content);
        Elements elements = body.select(selector);
        ArrayList<String> attrs = new ArrayList<String>();
        for (Element element : elements) {
            String attrValue = element.attr(attributeKey);
            attrs.add(attrValue);
        }
        return attrs;
    }

    public String addClass(String content, String selector, List<String> classNames, int amount) {
        Element body = this.parseContent(content);
        Object elements = body.select(selector);
        if (amount >= 0) {
            elements = elements.subList(0, Math.min(amount, elements.size()));
        }
        if (elements.size() > 0) {
            for (Element element : elements) {
                for (String className : classNames) {
                    element.addClass(className);
                }
            }
            return body.html();
        }
        return content;
    }

    public String addClass(String content, String selector, List<String> classNames) {
        return this.addClass(content, selector, classNames, -1);
    }

    public String addClass(String content, String selector, String className) {
        return this.addClass(content, selector, Collections.singletonList(className));
    }

    public String wrap(String content, String selector, String wrapHtml, int amount) {
        Element body = this.parseContent(content);
        Object elements = body.select(selector);
        if (amount >= 0) {
            elements = elements.subList(0, Math.min(amount, elements.size()));
        }
        if (elements.size() > 0) {
            for (Element element : elements) {
                element.wrap(wrapHtml);
            }
            return body.html();
        }
        return content;
    }

    public String remove(String content, String selector) {
        Element body = this.parseContent(content);
        Elements elements = body.select(selector);
        if (elements.size() > 0) {
            for (Element element : elements) {
                element.remove();
            }
            return body.html();
        }
        return content;
    }

    public String replace(String content, String selector, String replacement) {
        return this.replaceAll(content, Collections.singletonMap(selector, replacement));
    }

    public String replaceAll(String content, Map<String, String> replacements) {
        Element body = this.parseContent(content);
        boolean modified = false;
        for (Map.Entry<String, String> replacementEntry : replacements.entrySet()) {
            Element replacementElem;
            String selector = replacementEntry.getKey();
            String replacement = replacementEntry.getValue();
            Elements elements = body.select(selector);
            if (elements.size() <= 0 || (replacementElem = this.parseContent(replacement).child(0)) == null) continue;
            for (Element element : elements) {
                element.replaceWith((Node)replacementElem.clone());
            }
            modified = true;
        }
        if (modified) {
            return body.html();
        }
        return content;
    }

    public List<String> text(String content, String selector) {
        Element body = this.parseContent(content);
        Elements elements = body.select(selector);
        ArrayList<String> texts = new ArrayList<String>();
        for (Element element : elements) {
            texts.add(element.text());
        }
        return texts;
    }

    public String headingAnchorToId(String content) {
        Element body = this.parseContent(content);
        List<String> headNoIds = HtmlTool.concat(HEADINGS, ":not([id])", true);
        String nameA = "a[name]:not([href])";
        Elements headingsInnerA = body.select(StringUtil.join(HtmlTool.concat(headNoIds, ":has(" + nameA + ")", true), (String)", "));
        boolean modified = false;
        for (Object heading : headingsInnerA) {
            Elements anchors = heading.select(nameA);
            if (anchors.isEmpty()) continue;
            HtmlTool.anchorToId((Element)heading, (Element)anchors.get(0));
            modified = true;
        }
        Elements headingsPreA = body.select(StringUtil.join(HtmlTool.concat(headNoIds, nameA + " + ", false), (String)", "));
        for (Element heading : headingsPreA) {
            Element anchor = heading.previousElementSibling();
            if (anchor == null) continue;
            HtmlTool.anchorToId(heading, anchor);
            modified = true;
        }
        Elements anchorsPreH = body.select(StringUtil.join(HtmlTool.concat(headNoIds, " + " + nameA, true), (String)", "));
        for (Element anchor : anchorsPreH) {
            Element heading = anchor.previousElementSibling();
            if (heading == null) continue;
            HtmlTool.anchorToId(heading, anchor);
            modified = true;
        }
        if (modified) {
            return body.html();
        }
        return content;
    }

    private static void anchorToId(Element heading, Element anchor) {
        String aName;
        if ("a".equals(anchor.tagName()) && heading.id().isEmpty() && !(aName = anchor.attr("name")).isEmpty()) {
            heading.attr("id", aName);
            anchor.remove();
        }
    }

    public static List<String> concat(List<String> elements, String text, boolean append) {
        ArrayList<String> concats = new ArrayList<String>();
        for (String element : elements) {
            concats.add(append ? element + text : text + element);
        }
        return concats;
    }

    public String ensureHeadingIds(String content, String idSeparator) {
        Element body = this.parseContent(content);
        Elements idElems = body.select("*[id]");
        HashSet<String> ids = new HashSet<String>();
        boolean modified = false;
        for (Element idElem : idElems) {
            String id = idElem.id();
            idElem.attr("id", HtmlTool.adaptSlug(id, idSeparator));
            modified = true;
            ids.add(idElem.id());
        }
        List<String> headNoIds = HtmlTool.concat(HEADINGS, ":not([id])", true);
        Elements headingsNoId = body.select(StringUtil.join(headNoIds, (String)", "));
        if (!headingsNoId.isEmpty() || modified) {
            for (Element heading : headingsNoId) {
                String headingText = heading.text();
                String headingSlug = HtmlTool.slug(headingText, idSeparator);
                if (headingSlug.length() > 50) {
                    headingSlug = headingSlug.substring(0, 50);
                }
                String headingId = HtmlTool.generateUniqueId(ids, headingSlug);
                heading.attr("id", headingId);
            }
            return body.html();
        }
        return content;
    }

    private static String generateUniqueId(Set<String> ids, String idBase) {
        String id = idBase;
        int counter = 1;
        while (ids.contains(id)) {
            id = idBase + String.valueOf(counter++);
        }
        ids.add(id);
        return id;
    }

    public String fixTableHeads(String content) {
        Element body = this.parseContent(content);
        Elements tableHeadRows = body.select("table > tbody > tr:has(th)");
        if (tableHeadRows.size() > 0) {
            for (Element row : tableHeadRows) {
                Element table = row.parent().parent();
                row.remove();
                Element thead = new Element(Tag.valueOf((String)"thead"), "");
                thead.appendChild((Node)row);
                table.prependChild((Node)thead);
            }
            return body.html();
        }
        return content;
    }

    public static String slug(String input, String separator) {
        String slug = HtmlTool.adaptSlug(input, separator);
        return slug.toLowerCase(Locale.ENGLISH);
    }

    public static String slug(String input) {
        return HtmlTool.slug(input, "-");
    }

    private static String adaptSlug(String input, String separator) {
        String nowhitespace = WHITESPACE.matcher(input).replaceAll(separator);
        String normalized = Normalizer.normalize(nowhitespace, Normalizer.Form.NFD);
        return NONLATIN.matcher(normalized).replaceAll("");
    }

    public List<? extends IdElement> headingTree(String content) {
        Element body = this.parseContent(content);
        List<String> headIds = HtmlTool.concat(HEADINGS, "[id]", true);
        Elements headings = body.select(StringUtil.join(headIds, (String)", "));
        ArrayList<HeadingItem> headingItems = new ArrayList<HeadingItem>();
        for (Element heading : headings) {
            headingItems.add(new HeadingItem(heading.id(), heading.text(), HtmlTool.headingIndex(heading)));
        }
        ArrayList<HeadingItem> topHeadings = new ArrayList<HeadingItem>();
        Stack<HeadingItem> parentHeadings = new Stack<HeadingItem>();
        for (HeadingItem heading : headingItems) {
            while (!parentHeadings.isEmpty() && ((HeadingItem)parentHeadings.peek()).headingIndex >= heading.headingIndex) {
                parentHeadings.pop();
            }
            if (parentHeadings.isEmpty()) {
                topHeadings.add(heading);
            } else {
                ((HeadingItem)parentHeadings.peek()).children.add(heading);
            }
            parentHeadings.push(heading);
        }
        return topHeadings;
    }

    private static int headingIndex(Element element) {
        String tagName = element.tagName();
        if (tagName.startsWith("h")) {
            try {
                return Integer.parseInt(tagName.substring(1));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Must be a header tag: " + tagName, ex);
            }
        }
        throw new IllegalArgumentException("Must be a header tag: " + tagName);
    }

    public static Element parseBodyFragment(String content) {
        Document doc = Jsoup.parseBodyFragment((String)content);
        return doc.body();
    }

    public static interface IdElement {
        public String getId();

        public String getText();

        public List<? extends IdElement> getItems();
    }

    private static class HeadingItem
    implements IdElement {
        private final String id;
        private final String text;
        private final int headingIndex;
        private final List<HeadingItem> children = new ArrayList<HeadingItem>();

        public HeadingItem(String id, String text, int headingIndex) {
            this.id = id;
            this.text = text;
            this.headingIndex = headingIndex;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public List<HeadingItem> getItems() {
            return Collections.unmodifiableList(this.children);
        }
    }

    private static class DefaultExtractResult
    implements ExtractResult {
        private final List<String> extracted;
        private final String remainder;

        public DefaultExtractResult(List<String> extracted, String remainder) {
            this.extracted = extracted;
            this.remainder = remainder;
        }

        @Override
        public List<String> getExtracted() {
            return Collections.unmodifiableList(this.extracted);
        }

        @Override
        public String getRemainder() {
            return this.remainder;
        }
    }

    public static interface ExtractResult {
        public List<String> getExtracted();

        public String getRemainder();
    }

    public static enum JoinSeparator {
        AFTER,
        BEFORE,
        NO;

    }
}

