/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class AbstractJodaBeansMojo
extends AbstractMojo {
    private boolean _skip;
    private String sourceDir;
    private String indent;
    private String prefix;
    private Integer verbose;
    private MavenProject _project;

    protected String getSourceDir() {
        return this.sourceDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this._skip) {
            return;
        }
        if (this.sourceDir == null) {
            throw new MojoExecutionException("Source directory must not be null");
        }
        URLClassLoader classLoader = this.obtainClassLoader();
        Class<?> toolClass = null;
        try {
            toolClass = classLoader.loadClass("org.joda.beans.gen.BeanCodeGen");
        }
        catch (Exception ex) {
            this.getLog().info((CharSequence)"Skipping as joda-beans is not in the project compile classpath");
            return;
        }
        List<String> argsList = this.buildArgs();
        this.runTool(toolClass, argsList);
    }

    protected List<String> buildArgs() {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-R");
        if (this.indent != null) {
            argsList.add("-indent=" + this.indent);
        }
        if (this.prefix != null) {
            argsList.add("-prefix=" + this.prefix);
        }
        if (this.verbose != null) {
            argsList.add("-verbose=" + this.verbose);
        }
        return argsList;
    }

    protected int runTool(Class<?> toolClass, List<String> argsList) throws MojoExecutionException, MojoFailureException {
        Object beanCodeGen;
        argsList.add(this.sourceDir);
        Method createFromArgsMethod = null;
        try {
            createFromArgsMethod = toolClass.getMethod("createFromArgs", String[].class);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to find method BeanCodeGen.createFromArgs()");
        }
        Method processMethod = null;
        try {
            processMethod = toolClass.getMethod("process", new Class[0]);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to find method BeanCodeGen.process()");
        }
        String[] args = argsList.toArray(new String[argsList.size()]);
        try {
            beanCodeGen = createFromArgsMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.createFromArgs()");
        }
        catch (IllegalAccessException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.createFromArgs()");
        }
        catch (InvocationTargetException ex) {
            throw new MojoFailureException("Invalid Joda-Beans Mojo configuration: " + ex.getCause().getMessage(), ex.getCause());
        }
        int changes = 0;
        try {
            changes = (Integer)processMethod.invoke(beanCodeGen, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.process()");
        }
        catch (IllegalAccessException ex) {
            throw new MojoExecutionException("Error invoking BeanCodeGen.process()");
        }
        catch (InvocationTargetException ex) {
            throw new MojoFailureException("Error while running Joda-Beans tool: " + ex.getCause().getMessage(), ex.getCause());
        }
        return changes;
    }

    protected URLClassLoader obtainClassLoader() throws MojoExecutionException {
        List<String> compileClasspath = this.obtainClasspath();
        HashSet<URL> classpathUrlSet = new HashSet<URL>();
        for (String classpathEntry : compileClasspath) {
            File f = new File(classpathEntry);
            if (!f.exists()) continue;
            try {
                classpathUrlSet.add(f.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Error interpreting classpath entry as URL: " + classpathEntry, ex);
            }
        }
        URL[] classpathUrls = classpathUrlSet.toArray(new URL[classpathUrlSet.size()]);
        return new URLClassLoader(classpathUrls, AbstractJodaBeansMojo.class.getClassLoader());
    }

    protected List<String> obtainClasspath() throws MojoExecutionException {
        try {
            return this._project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Error obtaining dependencies", (Exception)((Object)ex));
        }
    }
}

