/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.Scanner;
import org.joda.beans.maven.AbstractJodaBeansMojo;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractJodaBeansGenerateMojo
extends AbstractJodaBeansMojo {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    protected void runTool(Class<?> toolClass, List<String> argsList, BuildContext buildContext) throws MojoExecutionException, MojoFailureException {
        File file;
        String[] changedSourceFiles = this.findFiles(buildContext, this.getSourceDir());
        String[] changedTestFiles = this.findFiles(buildContext, this.getTestSourceDir());
        int sourceFilesChanged = changedSourceFiles.length;
        int testFilesChanged = changedTestFiles.length;
        if (sourceFilesChanged == 0 && testFilesChanged == 0) {
            this.logInfo("No files changed");
            return;
        }
        this.logDebug("Files changed: main=" + sourceFilesChanged + ", test=" + testFilesChanged);
        this.logInfo("Joda-Bean generator started, directory: " + this.getSourceDir() + (this.getTestSourceDir().length() == 0 ? "" : ", test directory: " + this.getTestSourceDir()));
        int changedFileCount = 0;
        if (sourceFilesChanged > 0) {
            if (sourceFilesChanged == 1) {
                file = new File(this.getSourceDir(), changedSourceFiles[0]);
                argsList.add(file.toString());
                this.logDebug("Single file: " + argsList.get(argsList.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, argsList, file.getParentFile(), new File(this.getClassesDir()));
            } else {
                argsList.add(this.getSourceDir());
                this.logDebug("All files: " + argsList.get(argsList.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, argsList, new File(this.getSourceDir()), new File(this.getClassesDir()));
            }
        }
        if (testFilesChanged > 0) {
            if (testFilesChanged == 1) {
                file = new File(this.getSourceDir(), changedTestFiles[0]);
                argsList.set(argsList.size() - 1, file.toString());
                this.logDebug("Single test file: " + argsList.get(argsList.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, argsList, file.getParentFile(), new File(this.getTestClassesDir()));
            } else {
                argsList.set(argsList.size() - 1, this.getTestSourceDir());
                this.logDebug("All test files: " + argsList.get(argsList.size() - 1));
                changedFileCount += this.runToolHandleChanges(toolClass, argsList, new File(this.getTestSourceDir()), new File(this.getTestClassesDir()));
            }
        }
        this.logInfo("Joda-Bean generator completed, " + changedFileCount + " changed files");
    }

    private String[] findFiles(BuildContext buildContext, String dirStr) {
        File dir = new File(dirStr);
        if (dirStr.isEmpty() || !dir.exists()) {
            return EMPTY_STRING_ARRAY;
        }
        Scanner scanner = buildContext.newScanner(dir);
        scanner.setIncludes(new String[]{"**/*.java"});
        scanner.scan();
        String[] changedSourceFiles = scanner.getIncludedFiles();
        return changedSourceFiles;
    }
}

