/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.DynamicMetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyMap;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.map.MapBean;
import org.joda.beans.impl.map.MapBeanBuilder;
import org.joda.beans.impl.map.MapBeanMetaProperty;
import org.joda.beans.impl.map.MapBeanPropertyMap;

class MapMetaBean
extends BasicMetaBean
implements DynamicMetaBean {
    private final MapBean bean;

    MapMetaBean(MapBean bean) {
        this.bean = bean;
    }

    public BeanBuilder<MapBean> builder() {
        return new MapBeanBuilder(this.bean);
    }

    @Override
    public PropertyMap createPropertyMap(Bean bean) {
        return MapBeanPropertyMap.of(this.beanType().cast(bean));
    }

    public Class<MapBean> beanType() {
        return MapBean.class;
    }

    @Override
    public String beanName() {
        return MapBean.class.getName();
    }

    @Override
    public int metaPropertyCount() {
        return this.bean.size();
    }

    @Override
    public boolean metaPropertyExists(String name) {
        return this.bean.containsKey(name);
    }

    public MetaProperty<Object> metaProperty(String name) {
        return MapBeanMetaProperty.of(this, name);
    }

    @Override
    public Iterable<MetaProperty<?>> metaPropertyIterable() {
        return new Iterable<MetaProperty<?>>(){
            private final Iterator<String> it;
            {
                this.it = MapMetaBean.this.bean.keySet().iterator();
            }

            @Override
            public Iterator<MetaProperty<?>> iterator() {
                return new Iterator<MetaProperty<?>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public MetaProperty<?> next() {
                        return MapBeanMetaProperty.of(MapMetaBean.this, (String)it.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Unmodifiable");
                    }
                };
            }
        };
    }

    @Override
    public Map<String, MetaProperty<?>> metaPropertyMap() {
        HashMap<String, MapBeanMetaProperty> map = new HashMap<String, MapBeanMetaProperty>();
        for (String name : this.bean.keySet()) {
            map.put(name, MapBeanMetaProperty.of(this, name));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void metaPropertyDefine(String propertyName, Class<?> propertyType) {
        this.bean.propertyDefine(propertyName, propertyType);
    }

    @Override
    public void metaPropertyRemove(String propertyName) {
        this.bean.propertyRemove(propertyName);
    }
}

