/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.CollectSerIteratorFactory;
import org.joda.beans.ser.GuavaSerIteratorFactory;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerIterator;
import org.joda.beans.ser.SerTypeMapper;

public class SerIteratorFactory {
    public static final SerIteratorFactory INSTANCE = SerIteratorFactory.getInstance();
    public static final List<Class<?>> EMPTY_VALUE_TYPES = Collections.emptyList();
    private static final Map<String, Class<?>> META_TYPE_MAP = new HashMap();

    private static SerIteratorFactory getInstance() {
        try {
            Class.forName("org.joda.collect.grid.Grid");
            return new CollectSerIteratorFactory();
        }
        catch (Throwable ex) {
            try {
                Class.forName("com.google.common.collect.Multimap");
                return new GuavaSerIteratorFactory();
            }
            catch (Throwable ex2) {
                return new SerIteratorFactory();
            }
        }
    }

    public SerIterator create(Object value, MetaProperty<?> prop, Class<?> beanClass) {
        Class<?> declaredType = prop.propertyType();
        if (value instanceof Collection) {
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.collectionType(prop, beanClass));
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return SerIteratorFactory.collection((Collection)value, declaredType, valueType, valueTypeTypes);
        }
        if (value instanceof Map) {
            Class<?> keyType = this.defaultToObjectClass(JodaBeanUtils.mapKeyType(prop, beanClass));
            Class<?> valueType = this.defaultToObjectClass(JodaBeanUtils.mapValueType(prop, beanClass));
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return SerIteratorFactory.map((Map)value, declaredType, keyType, valueType, valueTypeTypes);
        }
        if (value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive()) {
            Object[] array = (Object[])value;
            return SerIteratorFactory.array(array, declaredType, array.getClass().getComponentType());
        }
        return null;
    }

    public SerIterator createChild(Object value, SerIterator parent) {
        Class<?> declaredType = parent.valueType();
        List<Class<?>> childGenericTypes = parent.valueTypeTypes();
        if (value instanceof Collection) {
            if (childGenericTypes.size() == 1) {
                return SerIteratorFactory.collection((Collection)value, declaredType, childGenericTypes.get(0), EMPTY_VALUE_TYPES);
            }
            return SerIteratorFactory.collection((Collection)value, Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (value instanceof Map) {
            if (childGenericTypes.size() == 2) {
                return SerIteratorFactory.map((Map)value, declaredType, childGenericTypes.get(0), childGenericTypes.get(1), EMPTY_VALUE_TYPES);
            }
            return SerIteratorFactory.map((Map)value, Object.class, Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (value.getClass().isArray() && !value.getClass().getComponentType().isPrimitive()) {
            Object[] array = (Object[])value;
            return SerIteratorFactory.array(array, Object.class, value.getClass().getComponentType());
        }
        return null;
    }

    protected Class<?> defaultToObjectClass(Class<?> type) {
        return type != null ? type : Object.class;
    }

    public SerIterable createIterable(String metaTypeDescription, JodaBeanSer settings, Map<String, Class<?>> knownTypes) {
        if (metaTypeDescription.equals("Set")) {
            return SerIteratorFactory.set(Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("List")) {
            return SerIteratorFactory.list(Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("Collection")) {
            return SerIteratorFactory.list(Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.equals("Map")) {
            return SerIteratorFactory.map(Object.class, Object.class, EMPTY_VALUE_TYPES);
        }
        if (metaTypeDescription.endsWith("[][][]")) {
            throw new IllegalArgumentException("Three-dimensional arrays cannot be parsed");
        }
        if (metaTypeDescription.endsWith("[][]")) {
            Class<?> type = META_TYPE_MAP.get(metaTypeDescription);
            if (type != null) {
                return SerIteratorFactory.array(type);
            }
            String clsStr = metaTypeDescription.substring(0, metaTypeDescription.length() - 4);
            try {
                Class<?> cls = SerTypeMapper.decodeType(clsStr, settings, null, knownTypes);
                String compound = "[L" + cls.getName() + ";";
                return SerIteratorFactory.array(Class.forName(compound));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (metaTypeDescription.endsWith("[]")) {
            Class<?> type = META_TYPE_MAP.get(metaTypeDescription);
            if (type != null) {
                return SerIteratorFactory.array(type);
            }
            String clsStr = metaTypeDescription.substring(0, metaTypeDescription.length() - 2);
            try {
                Class<?> cls = SerTypeMapper.decodeType(clsStr, settings, null, knownTypes);
                return SerIteratorFactory.array(cls);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public SerIterable createIterable(SerIterable iterable) {
        List<Class<?>> valueTypeTypes = iterable.valueTypeTypes();
        if (valueTypeTypes.size() > 0) {
            Class<?> valueType = iterable.valueType();
            if (NavigableSet.class.isAssignableFrom(valueType)) {
                return SerIteratorFactory.navigableSet(valueTypeTypes.get(0), EMPTY_VALUE_TYPES);
            }
            if (SortedSet.class.isAssignableFrom(valueType)) {
                return SerIteratorFactory.sortedSet(valueTypeTypes.get(0), EMPTY_VALUE_TYPES);
            }
            if (Set.class.isAssignableFrom(valueType)) {
                return SerIteratorFactory.set(valueTypeTypes.get(0), EMPTY_VALUE_TYPES);
            }
            if (Collection.class.isAssignableFrom(valueType)) {
                return SerIteratorFactory.list(valueTypeTypes.get(0), EMPTY_VALUE_TYPES);
            }
            if (NavigableMap.class.isAssignableFrom(valueType)) {
                if (valueTypeTypes.size() == 2) {
                    return SerIteratorFactory.navigableMap(valueTypeTypes.get(0), valueTypeTypes.get(1), EMPTY_VALUE_TYPES);
                }
                return SerIteratorFactory.navigableMap(Object.class, Object.class, EMPTY_VALUE_TYPES);
            }
            if (SortedMap.class.isAssignableFrom(valueType)) {
                if (valueTypeTypes.size() == 2) {
                    return SerIteratorFactory.sortedMap(valueTypeTypes.get(0), valueTypeTypes.get(1), EMPTY_VALUE_TYPES);
                }
                return SerIteratorFactory.sortedMap(Object.class, Object.class, EMPTY_VALUE_TYPES);
            }
            if (Map.class.isAssignableFrom(valueType)) {
                if (valueTypeTypes.size() == 2) {
                    return SerIteratorFactory.map(valueTypeTypes.get(0), valueTypeTypes.get(1), EMPTY_VALUE_TYPES);
                }
                return SerIteratorFactory.map(Object.class, Object.class, EMPTY_VALUE_TYPES);
            }
            if (valueType.isArray() && !valueType.getComponentType().isPrimitive()) {
                return SerIteratorFactory.array(valueType.getComponentType());
            }
        }
        return null;
    }

    public SerIterable createIterable(MetaProperty<?> prop, Class<?> beanClass) {
        if (NavigableSet.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return SerIteratorFactory.navigableSet(valueType, valueTypeTypes);
        }
        if (SortedSet.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return SerIteratorFactory.sortedSet(valueType, valueTypeTypes);
        }
        if (Set.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return SerIteratorFactory.set(valueType, valueTypeTypes);
        }
        if (Collection.class.isAssignableFrom(prop.propertyType())) {
            Class<?> valueType = JodaBeanUtils.collectionType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.collectionTypeTypes(prop, beanClass);
            return SerIteratorFactory.list(valueType, valueTypeTypes);
        }
        if (NavigableMap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return SerIteratorFactory.navigableMap(keyType, valueType, valueTypeTypes);
        }
        if (SortedMap.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return SerIteratorFactory.sortedMap(keyType, valueType, valueTypeTypes);
        }
        if (Map.class.isAssignableFrom(prop.propertyType())) {
            Class<?> keyType = JodaBeanUtils.mapKeyType(prop, beanClass);
            Class<?> valueType = JodaBeanUtils.mapValueType(prop, beanClass);
            List<Class<?>> valueTypeTypes = JodaBeanUtils.mapValueTypeTypes(prop, beanClass);
            return SerIteratorFactory.map(keyType, valueType, valueTypeTypes);
        }
        if (prop.propertyType().isArray() && !prop.propertyType().getComponentType().isPrimitive()) {
            return SerIteratorFactory.array(prop.propertyType().getComponentType());
        }
        return null;
    }

    public static final SerIterable list(final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        final ArrayList coll = new ArrayList();
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return SerIteratorFactory.collection(coll, Object.class, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key != null) {
                    throw new IllegalArgumentException("Unexpected key");
                }
                for (int i = 0; i < count; ++i) {
                    coll.add(value);
                }
            }

            @Override
            public Object build() {
                return coll;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    public static final SerIterable set(Class<?> valueType, List<Class<?>> valueTypeTypes) {
        HashSet<Object> coll = new HashSet<Object>();
        return SerIteratorFactory.set(valueType, valueTypeTypes, coll);
    }

    public static final SerIterable sortedSet(Class<?> valueType, List<Class<?>> valueTypeTypes) {
        TreeSet<Object> coll = new TreeSet<Object>();
        return SerIteratorFactory.set(valueType, valueTypeTypes, coll);
    }

    public static final SerIterable navigableSet(Class<?> valueType, List<Class<?>> valueTypeTypes) {
        TreeSet<Object> coll = new TreeSet<Object>();
        return SerIteratorFactory.set(valueType, valueTypeTypes, coll);
    }

    private static SerIterable set(final Class<?> valueType, final List<Class<?>> valueTypeTypes, final Set<Object> coll) {
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return SerIteratorFactory.collection(coll, Object.class, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key != null) {
                    throw new IllegalArgumentException("Unexpected key");
                }
                for (int i = 0; i < count; ++i) {
                    coll.add(value);
                }
            }

            @Override
            public Object build() {
                return coll;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    public static final SerIterator collection(final Collection<?> coll, final Class<?> declaredType, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Object current;
            {
                this.it = coll.iterator();
            }

            @Override
            public String metaTypeName() {
                if (coll instanceof Set) {
                    return "Set";
                }
                if (coll instanceof List) {
                    return "List";
                }
                return "Collection";
            }

            @Override
            public boolean metaTypeRequired() {
                if (coll instanceof Set) {
                    return !Set.class.isAssignableFrom(declaredType);
                }
                if (coll instanceof List) {
                    return !List.class.isAssignableFrom(declaredType);
                }
                return !Collection.class.isAssignableFrom(declaredType);
            }

            @Override
            public int size() {
                return coll.size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = this.it.next();
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }

            @Override
            public Object value() {
                return this.current;
            }
        };
    }

    public static final SerIterable map(Class<?> keyType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        return SerIteratorFactory.map(keyType, valueType, valueTypeTypes, map);
    }

    public static final SerIterable sortedMap(Class<?> keyType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        return SerIteratorFactory.map(keyType, valueType, valueTypeTypes, map);
    }

    public static final SerIterable navigableMap(Class<?> keyType, Class<?> valueType, List<Class<?>> valueTypeTypes) {
        TreeMap<Object, Object> map = new TreeMap<Object, Object>();
        return SerIteratorFactory.map(keyType, valueType, valueTypeTypes, map);
    }

    static SerIterable map(final Class<?> keyType, final Class<?> valueType, final List<Class<?>> valueTypeTypes, final Map<Object, Object> map) {
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return SerIteratorFactory.map(map, Object.class, keyType, valueType, valueTypeTypes);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key == null) {
                    throw new IllegalArgumentException("Missing key");
                }
                if (count != 1) {
                    throw new IllegalArgumentException("Unexpected count");
                }
                map.put(key, value);
            }

            @Override
            public Object build() {
                return map;
            }

            @Override
            public SerCategory category() {
                return SerCategory.MAP;
            }

            @Override
            public Class<?> keyType() {
                return keyType;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }
        };
    }

    public static final SerIterator map(final Map<?, ?> map, final Class<?> declaredType, final Class<?> keyType, final Class<?> valueType, final List<Class<?>> valueTypeTypes) {
        return new SerIterator(){
            private final Iterator it;
            private Map.Entry current;
            {
                this.it = map.entrySet().iterator();
            }

            @Override
            public String metaTypeName() {
                return "Map";
            }

            @Override
            public boolean metaTypeRequired() {
                return !Map.class.isAssignableFrom(declaredType);
            }

            @Override
            public SerCategory category() {
                return SerCategory.MAP;
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void next() {
                this.current = (Map.Entry)this.it.next();
            }

            @Override
            public Class<?> keyType() {
                return keyType;
            }

            @Override
            public Object key() {
                return this.current.getKey();
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return valueTypeTypes;
            }

            @Override
            public Object value() {
                return this.current.getValue();
            }
        };
    }

    public static final SerIterable array(final Class<?> valueType) {
        final ArrayList list = new ArrayList();
        return new SerIterable(){

            @Override
            public SerIterator iterator() {
                return SerIteratorFactory.array(this.build(), Object.class, valueType);
            }

            @Override
            public void add(Object key, Object column, Object value, int count) {
                if (key != null) {
                    throw new IllegalArgumentException("Unexpected key");
                }
                if (count != 1) {
                    throw new IllegalArgumentException("Unexpected count");
                }
                for (int i = 0; i < count; ++i) {
                    list.add(value);
                }
            }

            public Object[] build() {
                Object[] array = (Object[])Array.newInstance(valueType, list.size());
                return list.toArray(array);
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return EMPTY_VALUE_TYPES;
            }
        };
    }

    public static final SerIterator array(final Object[] array, final Class<?> declaredType, final Class<?> valueType) {
        return new SerIterator(){
            private int index = -1;

            @Override
            public String metaTypeName() {
                return this.metaTypeNameBase(valueType);
            }

            private String metaTypeNameBase(Class<?> arrayType) {
                if (arrayType.isArray()) {
                    return this.metaTypeNameBase(arrayType.getComponentType()) + "[]";
                }
                if (arrayType == Object.class) {
                    return "Object[]";
                }
                if (arrayType == String.class) {
                    return "String[]";
                }
                return arrayType.getName() + "[]";
            }

            @Override
            public boolean metaTypeRequired() {
                if (valueType == Object.class) {
                    return !Object[].class.isAssignableFrom(declaredType);
                }
                if (valueType == String.class) {
                    return !String[].class.isAssignableFrom(declaredType);
                }
                return true;
            }

            @Override
            public int size() {
                return array.length;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < array.length;
            }

            @Override
            public void next() {
                ++this.index;
            }

            @Override
            public Class<?> valueType() {
                return valueType;
            }

            @Override
            public List<Class<?>> valueTypeTypes() {
                return Collections.emptyList();
            }

            @Override
            public Object value() {
                return array[this.index];
            }
        };
    }

    static {
        META_TYPE_MAP.put("Object[]", Object.class);
        META_TYPE_MAP.put("String[]", String.class);
        META_TYPE_MAP.put("boolean[]", Boolean.TYPE);
        META_TYPE_MAP.put("char[]", Character.TYPE);
        META_TYPE_MAP.put("byte[]", Byte.TYPE);
        META_TYPE_MAP.put("short[]", Short.TYPE);
        META_TYPE_MAP.put("int[]", Integer.TYPE);
        META_TYPE_MAP.put("long[]", Long.TYPE);
        META_TYPE_MAP.put("float[]", Float.TYPE);
        META_TYPE_MAP.put("double[]", Double.TYPE);
        META_TYPE_MAP.put("Object[][]", Object[].class);
        META_TYPE_MAP.put("String[][]", String[].class);
        META_TYPE_MAP.put("boolean[][]", boolean[].class);
        META_TYPE_MAP.put("char[][]", char[].class);
        META_TYPE_MAP.put("byte[][]", byte[].class);
        META_TYPE_MAP.put("short[][]", short[].class);
        META_TYPE_MAP.put("int[][]", int[].class);
        META_TYPE_MAP.put("long[][]", long[].class);
        META_TYPE_MAP.put("float[][]", float[].class);
        META_TYPE_MAP.put("double[][]", double[].class);
    }
}

