/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.json;

import java.util.HashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.SerCategory;
import org.joda.beans.ser.SerDeserializer;
import org.joda.beans.ser.SerIterable;
import org.joda.beans.ser.SerIteratorFactory;
import org.joda.beans.ser.SerOptional;
import org.joda.beans.ser.SerTypeMapper;
import org.joda.beans.ser.json.JsonEvent;
import org.joda.beans.ser.json.JsonInput;

abstract class AbstractJsonReader {
    private final JodaBeanSer settings;
    private JsonInput input;
    private String basePackage;
    private Map<String, Class<?>> knownTypes = new HashMap();

    AbstractJsonReader(JodaBeanSer settings) {
        JodaBeanUtils.notNull(settings, "settings");
        this.settings = settings;
    }

    <T> T parseRoot(JsonInput input, Class<T> declaredType) throws Exception {
        this.input = input;
        Object parsed = this.parseObject(input.acceptEvent(JsonEvent.OBJECT), declaredType, null, null, null, true);
        return declaredType.cast(parsed);
    }

    private Object parseBean(JsonEvent event, Class<?> beanType) throws Exception {
        String propName = "";
        try {
            SerDeserializer deser = this.settings.getDeserializers().findDeserializer(beanType);
            MetaBean metaBean = deser.findMetaBean(beanType);
            BeanBuilder<?> builder = deser.createBuilder(beanType, metaBean);
            while (event != JsonEvent.OBJECT_END) {
                propName = this.input.acceptObjectKey(event);
                MetaProperty<?> metaProp = deser.findMetaProperty(beanType, metaBean, propName);
                if (metaProp == null) {
                    this.input.skipData();
                } else {
                    Object value = this.parseObject(this.input.readEvent(), SerOptional.extractType(metaProp, beanType), metaProp, beanType, null, false);
                    deser.setValue(builder, metaProp, SerOptional.wrapValue(metaProp, beanType, value));
                }
                propName = "";
                event = this.input.acceptObjectSeparator();
            }
            return deser.build(beanType, builder);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Error parsing bean: " + beanType.getName() + "::" + propName + ", " + ex.getMessage(), ex);
        }
    }

    private Object parseObject(JsonEvent event, Class<?> declaredType, MetaProperty<?> metaProp, Class<?> beanType, SerIterable parentIterable, boolean rootType) throws Exception {
        if (event == JsonEvent.OBJECT) {
            event = this.input.readEvent();
            if (event == JsonEvent.STRING) {
                String key = this.input.parseObjectKey();
                if (key.equals("@bean")) {
                    return this.parseTypedBean(declaredType, rootType);
                }
                if (key.equals("@type")) {
                    return this.parseTypedSimple(declaredType);
                }
                if (key.equals("@meta")) {
                    return this.parseTypedMeta();
                }
                this.input.pushBack('\"');
                this.input.pushBackObjectKey(key);
                event = JsonEvent.OBJECT;
            } else if (event == JsonEvent.OBJECT_END) {
                this.input.pushBack('}');
                event = JsonEvent.OBJECT;
            } else {
                throw new IllegalArgumentException("Invalid JSON data: Expected JSON object end but found " + (Object)((Object)event));
            }
        }
        if (Bean.class.isAssignableFrom(declaredType)) {
            if (event == JsonEvent.OBJECT) {
                return this.parseBean(this.input.readEvent(), declaredType);
            }
            return this.parseSimple(event, declaredType);
        }
        if (event == JsonEvent.OBJECT || event == JsonEvent.ARRAY) {
            SerIterable childIterable = null;
            if (metaProp != null) {
                childIterable = SerIteratorFactory.INSTANCE.createIterable(metaProp, beanType);
            } else if (parentIterable != null) {
                childIterable = SerIteratorFactory.INSTANCE.createIterable(parentIterable);
            }
            if (childIterable == null) {
                childIterable = event == JsonEvent.ARRAY ? this.parseUnknownArray(declaredType) : this.parseUnknownObject(declaredType);
            }
            return this.parseIterable(event, childIterable);
        }
        return this.parseSimple(event, declaredType);
    }

    SerIterable parseUnknownArray(Class<?> declaredType) {
        throw new IllegalArgumentException("JSON contained an array without information about the Java type");
    }

    SerIterable parseUnknownObject(Class<?> declaredType) {
        throw new IllegalArgumentException("JSON contained an object without information about the Java type");
    }

    private Object parseTypedBean(Class<?> declaredType, boolean rootType) throws Exception {
        String typeStr = this.input.acceptString();
        Class<?> effectiveType = SerTypeMapper.decodeType(typeStr, this.settings, this.basePackage, this.knownTypes);
        if (rootType) {
            if (!Bean.class.isAssignableFrom(effectiveType)) {
                throw new IllegalArgumentException("Root type is not a Joda-Bean: " + effectiveType.getName());
            }
            this.basePackage = effectiveType.getPackage().getName() + ".";
        }
        if (!declaredType.isAssignableFrom(effectiveType)) {
            throw new IllegalArgumentException("Specified type is incompatible with declared type: " + declaredType.getName() + " and " + effectiveType.getName());
        }
        JsonEvent event = this.input.readEvent();
        if (event == JsonEvent.COMMA) {
            event = this.input.readEvent();
        }
        return this.parseBean(event, effectiveType);
    }

    private Object parseTypedSimple(Class<?> declaredType) throws Exception {
        String typeStr = this.input.acceptString();
        Class<?> effectiveType = SerTypeMapper.decodeType(typeStr, this.settings, this.basePackage, this.knownTypes);
        if (!declaredType.isAssignableFrom(effectiveType)) {
            throw new IllegalArgumentException("Specified type is incompatible with declared type: " + declaredType.getName() + " and " + effectiveType.getName());
        }
        this.input.acceptEvent(JsonEvent.COMMA);
        String valueKey = this.input.acceptObjectKey(this.input.readEvent());
        if (!valueKey.equals("value")) {
            throw new IllegalArgumentException("Invalid JSON data: Expected 'value' key but found " + valueKey);
        }
        Object result = this.parseSimple(this.input.readEvent(), effectiveType);
        this.input.acceptEvent(JsonEvent.OBJECT_END);
        return result;
    }

    private Object parseTypedMeta() throws Exception {
        String metaType = this.input.acceptString();
        SerIterable childIterable = SerIteratorFactory.INSTANCE.createIterable(metaType, this.settings, this.knownTypes);
        this.input.acceptEvent(JsonEvent.COMMA);
        String valueKey = this.input.acceptObjectKey(this.input.readEvent());
        if (!valueKey.equals("value")) {
            throw new IllegalArgumentException("Invalid JSON data: Expected 'value' key but found " + valueKey);
        }
        Object result = this.parseIterable(this.input.readEvent(), childIterable);
        this.input.acceptEvent(JsonEvent.OBJECT_END);
        return result;
    }

    private Object parseIterable(JsonEvent event, SerIterable iterable) throws Exception {
        if (iterable.category() == SerCategory.MAP) {
            return this.parseIterableMap(event, iterable);
        }
        if (iterable.category() == SerCategory.COUNTED) {
            return this.parseIterableCounted(event, iterable);
        }
        if (iterable.category() == SerCategory.TABLE) {
            return this.parseIterableTable(event, iterable);
        }
        if (iterable.category() == SerCategory.GRID) {
            return this.parseIterableGrid(event, iterable);
        }
        return this.parseIterableArray(event, iterable);
    }

    private Object parseIterableMap(JsonEvent event, SerIterable iterable) throws Exception {
        if (event == JsonEvent.OBJECT) {
            event = this.input.readEvent();
            while (event != JsonEvent.OBJECT_END) {
                String keyStr = this.input.acceptObjectKey(event);
                Object key = this.settings.getConverter().convertFromString(iterable.keyType(), keyStr);
                Object value = this.parseObject(this.input.readEvent(), iterable.valueType(), null, null, iterable, false);
                iterable.add(key, null, value, 1);
                event = this.input.acceptObjectSeparator();
            }
        } else {
            if (event == JsonEvent.ARRAY) {
                event = this.input.readEvent();
                while (event != JsonEvent.ARRAY_END) {
                    this.input.ensureEvent(event, JsonEvent.ARRAY);
                    Object key = this.parseObject(this.input.readEvent(), iterable.keyType(), null, null, null, false);
                    this.input.acceptEvent(JsonEvent.COMMA);
                    Object value = this.parseObject(this.input.readEvent(), iterable.valueType(), null, null, iterable, false);
                    this.input.acceptEvent(JsonEvent.ARRAY_END);
                    iterable.add(key, null, value, 1);
                    event = this.input.acceptArraySeparator();
                }
                return iterable.build();
            }
            throw new IllegalArgumentException("Invalid JSON data: Expected array or object but found " + (Object)((Object)event));
        }
        return iterable.build();
    }

    private Object parseIterableTable(JsonEvent event, SerIterable iterable) throws Exception {
        this.input.ensureEvent(event, JsonEvent.ARRAY);
        event = this.input.readEvent();
        while (event != JsonEvent.ARRAY_END) {
            this.input.ensureEvent(event, JsonEvent.ARRAY);
            Object key = this.parseObject(this.input.readEvent(), iterable.keyType(), null, null, null, false);
            this.input.acceptEvent(JsonEvent.COMMA);
            Object column = this.parseObject(this.input.readEvent(), iterable.columnType(), null, null, null, false);
            this.input.acceptEvent(JsonEvent.COMMA);
            Object value = this.parseObject(this.input.readEvent(), iterable.valueType(), null, null, iterable, false);
            iterable.add(key, column, value, 1);
            this.input.acceptEvent(JsonEvent.ARRAY_END);
            event = this.input.acceptArraySeparator();
        }
        return iterable.build();
    }

    private Object parseIterableGrid(JsonEvent event, SerIterable iterable) throws Exception {
        this.input.ensureEvent(event, JsonEvent.ARRAY);
        this.input.acceptEvent(JsonEvent.NUMBER_INTEGRAL);
        int rows = (int)this.input.parseNumberIntegral();
        this.input.acceptEvent(JsonEvent.COMMA);
        this.input.acceptEvent(JsonEvent.NUMBER_INTEGRAL);
        int columns = (int)this.input.parseNumberIntegral();
        iterable.dimensions(new int[]{rows, columns});
        event = this.input.acceptArraySeparator();
        while (event != JsonEvent.ARRAY_END) {
            this.input.ensureEvent(event, JsonEvent.ARRAY);
            this.input.acceptEvent(JsonEvent.NUMBER_INTEGRAL);
            int row = (int)this.input.parseNumberIntegral();
            this.input.acceptEvent(JsonEvent.COMMA);
            this.input.acceptEvent(JsonEvent.NUMBER_INTEGRAL);
            int column = (int)this.input.parseNumberIntegral();
            this.input.acceptEvent(JsonEvent.COMMA);
            Object value = this.parseObject(this.input.readEvent(), iterable.valueType(), null, null, iterable, false);
            this.input.acceptEvent(JsonEvent.ARRAY_END);
            iterable.add(row, column, value, 1);
            event = this.input.acceptArraySeparator();
        }
        return iterable.build();
    }

    private Object parseIterableCounted(JsonEvent event, SerIterable iterable) throws Exception {
        this.input.ensureEvent(event, JsonEvent.ARRAY);
        event = this.input.readEvent();
        while (event != JsonEvent.ARRAY_END) {
            this.input.ensureEvent(event, JsonEvent.ARRAY);
            Object value = this.parseObject(this.input.readEvent(), iterable.valueType(), null, null, iterable, false);
            this.input.acceptEvent(JsonEvent.COMMA);
            this.input.acceptEvent(JsonEvent.NUMBER_INTEGRAL);
            iterable.add(null, null, value, (int)this.input.parseNumberIntegral());
            this.input.acceptEvent(JsonEvent.ARRAY_END);
            event = this.input.acceptArraySeparator();
        }
        return iterable.build();
    }

    private Object parseIterableArray(JsonEvent event, SerIterable iterable) throws Exception {
        this.input.ensureEvent(event, JsonEvent.ARRAY);
        event = this.input.readEvent();
        while (event != JsonEvent.ARRAY_END) {
            Object value = this.parseObject(event, iterable.valueType(), null, null, iterable, false);
            iterable.add(null, null, value, 1);
            event = this.input.acceptArraySeparator();
        }
        return iterable.build();
    }

    private Object parseSimple(JsonEvent event, Class<?> type) throws Exception {
        switch (event) {
            case STRING: {
                String text = this.input.parseString();
                if (type == String.class || type == Object.class) {
                    return text;
                }
                return this.settings.getConverter().convertFromString(type, text);
            }
            case NUMBER_INTEGRAL: {
                long value = this.input.parseNumberIntegral();
                if (type == Long.class || type == Long.TYPE) {
                    return value;
                }
                if (type == Short.class || type == Short.TYPE) {
                    if (value < -32768L || value > 32767L) {
                        throw new IllegalArgumentException("Invalid JSON data: Expected short, but was " + value);
                    }
                    return (short)value;
                }
                if (type == Byte.class || type == Byte.TYPE) {
                    if (value < -128L || value > 127L) {
                        throw new IllegalArgumentException("Invalid JSON data: Expected byte, but was " + value);
                    }
                    return (byte)value;
                }
                if (type == Double.class || type == Double.TYPE) {
                    double dblVal = value;
                    if (value != (long)dblVal) {
                        throw new IllegalArgumentException("Invalid JSON data: Value exceeds capacity of double: " + value);
                    }
                    return dblVal;
                }
                if (type == Float.class || type == Float.TYPE) {
                    float fltVal = value;
                    if (value != (long)fltVal) {
                        throw new IllegalArgumentException("Invalid JSON data: Value exceeds capacity of float: " + value);
                    }
                    return Float.valueOf(fltVal);
                }
                if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Invalid JSON data: Expected int, but was " + value);
                }
                return (int)value;
            }
            case NUMBER_FLOATING: {
                double value = this.input.parseNumberFloating();
                if (type == Float.class || type == Float.TYPE) {
                    return Float.valueOf((float)value);
                }
                return value;
            }
            case NULL: {
                if (type == Double.TYPE || type == Double.class) {
                    return Double.NaN;
                }
                if (type == Float.TYPE || type == Float.class) {
                    return Float.valueOf(Float.NaN);
                }
                return null;
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException("Invalid JSON data: Expected simple type but found " + (Object)((Object)event));
    }
}

