/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.beans.gen.PropertyData;

abstract class SetterGen {
    SetterGen() {
    }

    abstract boolean isSetterGenerated(PropertyData var1);

    abstract List<String> generateSetter(String var1, PropertyData var2);

    String generateSetInvoke(PropertyData prop, String newValue) {
        return "set" + prop.getUpperName() + "(" + newValue + ")";
    }

    static class ObservableSetterGen
    extends SetterGen {
        static final SetterGen PUBLIC = new ObservableSetterGen();

        ObservableSetterGen() {
        }

        @Override
        boolean isSetterGenerated(PropertyData prop) {
            return true;
        }

        @Override
        List<String> generateSetter(String indent, PropertyData prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("\t/**");
            list.add("\t * Sets " + prop.getFirstComment());
            for (String comment : prop.getComments()) {
                list.add("\t * " + comment);
            }
            list.add("\t * @param " + prop.getPropertyName() + "  the new value of the property" + prop.getNotNullJavadoc());
            list.add("\t */");
            if (prop.isOverrideSet()) {
                list.add("\t@Override");
            }
            if (prop.isDeprecated()) {
                list.add("\t@Deprecated");
            }
            list.add("\tpublic void set" + prop.getUpperName() + "(" + prop.getType() + " " + prop.getPropertyName() + ") {");
            if (prop.isValidated()) {
                list.add("\t\t" + prop.getValidationMethodName() + "(" + prop.getPropertyName() + ", \"" + prop.getPropertyName() + "\");");
            }
            String old = "old" + prop.getUpperName();
            list.add("\t\t" + prop.getFieldType() + " " + old + " = this." + prop.getFieldName() + ";");
            list.add("\t\tthis." + prop.getFieldName() + " = " + prop.getPropertyName() + ";");
            list.add("\t\tthis." + prop.getConfig().getPrefix() + "propertyChangeSupport.firePropertyChange(\"" + prop.getPropertyName() + "\", " + old + ", " + prop.getPropertyName() + ");");
            list.add("\t}");
            list.add("");
            return list;
        }
    }

    static class FieldSetterGen
    extends SetterGen {
        static final SetterGen INSTANCE = new FieldSetterGen();

        FieldSetterGen() {
        }

        @Override
        boolean isSetterGenerated(PropertyData prop) {
            return true;
        }

        @Override
        List<String> generateSetter(String indent, PropertyData prop) {
            return Collections.emptyList();
        }

        @Override
        String generateSetInvoke(PropertyData prop, String newValue) {
            return prop.getFieldName() + " = " + newValue;
        }
    }

    static class NoSetterGen
    extends SetterGen {
        static final SetterGen INSTANCE = new NoSetterGen();

        NoSetterGen() {
        }

        @Override
        boolean isSetterGenerated(PropertyData prop) {
            return false;
        }

        @Override
        List<String> generateSetter(String indent, PropertyData prop) {
            return Collections.emptyList();
        }
    }

    static class PatternSetterGen
    extends SetterGen {
        private final String setPattern;
        private final String access;

        PatternSetterGen(String setPattern) {
            this(setPattern, "public");
        }

        PatternSetterGen(String setPattern, String access) {
            this.setPattern = setPattern;
            this.access = access.equals("package") ? "" : access + ' ';
        }

        @Override
        boolean isSetterGenerated(PropertyData prop) {
            return true;
        }

        @Override
        List<String> generateSetter(String indent, PropertyData prop) {
            String[] split;
            ArrayList<String> list = new ArrayList<String>();
            list.add(indent + "/**");
            list.add(indent + " * Sets " + prop.getFirstComment());
            for (String comment : prop.getComments()) {
                list.add(indent + " * " + comment);
            }
            list.add(indent + " * @param " + prop.getPropertyName() + "  the new value of the property" + prop.getNotNullJavadoc());
            list.add(indent + " */");
            if (prop.isOverrideSet()) {
                list.add("\t@Override");
            }
            if (prop.isDeprecated()) {
                list.add(indent + "@Deprecated");
            }
            list.add(indent + this.access + "void set" + prop.getUpperName() + "(" + prop.getType() + " " + prop.getPropertyName() + ") {");
            if (prop.isValidated()) {
                list.add("\t\t" + prop.getValidationMethodName() + "(" + prop.getPropertyName() + ", \"" + prop.getPropertyName() + "\");");
            }
            for (String line : split = this.setPattern.split("\n")) {
                line = line.replace("$field", "this." + prop.getFieldName());
                line = line.replace("$value", prop.getPropertyName());
                line = line.replace("<>", prop.getTypeGenerics());
                if (split.length == 1 && !line.endsWith(";")) {
                    line = line + ";";
                }
                list.add(indent + "\t" + line);
            }
            list.add(indent + "}");
            list.add("");
            return list;
        }
    }

    static final class SetSetterGen
    extends SetterGen {
        static final SetSetterGen PUBLIC = new SetSetterGen("public ");
        static final SetSetterGen PROTECTED = new SetSetterGen("protected ");
        static final SetSetterGen PACKAGE = new SetSetterGen("");
        static final SetSetterGen PRIVATE = new SetSetterGen("private ");
        private final String access;

        static SetSetterGen of(String access) {
            return access.equals("private") ? PRIVATE : (access.equals("package") ? PACKAGE : (access.equals("protected") ? PROTECTED : PUBLIC));
        }

        private SetSetterGen(String access) {
            this.access = access;
        }

        @Override
        boolean isSetterGenerated(PropertyData prop) {
            return true;
        }

        @Override
        List<String> generateSetter(String indent, PropertyData prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("\t/**");
            list.add("\t * Sets " + prop.getFirstComment());
            for (String comment : prop.getComments()) {
                list.add("\t * " + comment);
            }
            list.add("\t * @param " + prop.getPropertyName() + "  the new value of the property" + prop.getNotNullJavadoc());
            list.add("\t */");
            if (prop.isOverrideSet()) {
                list.add("\t@Override");
            }
            if (prop.isDeprecated()) {
                list.add("\t@Deprecated");
            }
            list.add("\t" + this.access + "void set" + prop.getUpperName() + "(" + prop.getType() + " " + prop.getPropertyName() + ") {");
            if (prop.isValidated()) {
                list.add("\t\t" + prop.getValidationMethodName() + "(" + prop.getPropertyName() + ", \"" + prop.getPropertyName() + "\");");
            }
            list.add("\t\tthis." + prop.getFieldName() + " = " + prop.getPropertyName() + ";");
            list.add("\t}");
            list.add("");
            return list;
        }
    }
}

