/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.flexi;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.joda.beans.DynamicMetaBean;
import org.joda.beans.Property;
import org.joda.beans.PropertyMap;
import org.joda.beans.impl.BasicProperty;
import org.joda.beans.impl.flexi.FlexiBean;
import org.joda.beans.impl.flexi.FlexiMetaProperty;

final class FlexiPropertyMap
extends AbstractMap<String, Property<?>>
implements PropertyMap {
    private final FlexiBean bean;

    static FlexiPropertyMap of(FlexiBean bean) {
        return new FlexiPropertyMap(bean);
    }

    private FlexiPropertyMap(FlexiBean bean) {
        if (bean == null) {
            throw new NullPointerException("Bean must not be null");
        }
        this.bean = bean;
    }

    @Override
    public int size() {
        return this.bean.size();
    }

    @Override
    public boolean containsKey(Object obj) {
        return this.bean.data.containsKey(obj);
    }

    @Override
    public Property<?> get(Object obj) {
        return this.containsKey(obj) ? this.bean.property(obj.toString()) : null;
    }

    @Override
    public Set<String> keySet() {
        return this.bean.data.keySet();
    }

    @Override
    public Set<Map.Entry<String, Property<?>>> entrySet() {
        if (this.size() == 0) {
            return Collections.emptySet();
        }
        final DynamicMetaBean metaBean = this.bean.metaBean();
        return new AbstractSet<Map.Entry<String, Property<?>>>(){

            @Override
            public int size() {
                return FlexiPropertyMap.this.bean.size();
            }

            @Override
            public Iterator<Map.Entry<String, Property<?>>> iterator() {
                final Iterator<String> it = ((FlexiPropertyMap)FlexiPropertyMap.this).bean.data.keySet().iterator();
                return new Iterator<Map.Entry<String, Property<?>>>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Property<?>> next() {
                        String name = (String)it.next();
                        BasicProperty<Object> prop = BasicProperty.of(FlexiPropertyMap.this.bean, FlexiMetaProperty.of(metaBean, name));
                        return new AbstractMap.SimpleImmutableEntry(name, prop);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Unmodifiable");
                    }
                };
            }
        };
    }

    @Override
    public Map<String, Object> flatten() {
        return this.bean.toMap();
    }
}

