/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.beans.gen.PropertyData;
import org.joda.beans.gen.PropertyGen;

abstract class BuilderGen {
    BuilderGen() {
    }

    abstract List<String> generateField(String var1, PropertyData var2);

    String generateType(PropertyData prop) {
        return prop.getBuilderType();
    }

    static class NoBuilderGen
    extends BuilderGen {
        static final BuilderGen INSTANCE = new NoBuilderGen();

        NoBuilderGen() {
        }

        @Override
        List<String> generateField(String indent, PropertyData prop) {
            return Collections.emptyList();
        }
    }

    static class SimpleBuilderGen
    extends BuilderGen {
        SimpleBuilderGen() {
        }

        @Override
        List<String> generateField(String indent, PropertyData prop) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + ";");
            return list;
        }

        @Override
        String generateType(PropertyData prop) {
            return prop.getBuilderType().replace("<>", prop.getTypeGenerics());
        }
    }

    static class PatternBuilderGen
    extends BuilderGen {
        private final String type;
        private final String init;

        PatternBuilderGen(String type, String init) {
            this.type = type;
            this.init = init;
        }

        @Override
        List<String> generateField(String indent, PropertyData prop) {
            ArrayList<String> list = new ArrayList<String>();
            if (prop.isNotNull()) {
                String init = this.init;
                init = init.replace("<>", PropertyGen.resolveWildcard(prop.getTypeGenerics()));
                list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + " = " + init + ";");
            } else {
                list.add(indent + "private " + this.generateType(prop) + " " + prop.getFieldName() + ";");
            }
            return list;
        }

        @Override
        String generateType(PropertyData prop) {
            if (!"smart".equals(prop.getBuilderTypeStyle())) {
                return prop.getBuilderType().replace("<>", prop.getTypeGenerics());
            }
            return this.type.replace("<>", prop.getTypeGenerics());
        }
    }
}

