/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.beans.gen.BeanCodeGenException;
import org.joda.beans.gen.BeanData;
import org.joda.beans.gen.BeanGen;
import org.joda.beans.gen.BeanGenConfig;
import org.joda.beans.gen.PropertyGen;
import org.joda.beans.gen.PropertyParser;

class BeanParser {
    private static final String AUTOGENERATED_START_TEXT = "AUTOGENERATED START";
    private static final String AUTOGENERATED_START = "\t//------------------------- AUTOGENERATED START -------------------------";
    private static final String AUTOGENERATED_END = "\t//-------------------------- AUTOGENERATED END --------------------------";
    private static final Pattern BEAN_TYPE = Pattern.compile(".*class +(([A-Z][A-Za-z0-9_]+)(?:<([A-Z])( +extends +[A-Za-z0-9_]+(?:[<][A-Za-z0-9_, ?]+[>])?(?:[ ]+[&][ ]+[A-Za-z0-9]+)*)?(?:[,] +([A-Z])( +extends +[A-Za-z0-9_]+(?:[<][A-Za-z0-9_, ?]+[>])?(?:[ ]+[&][ ]+[A-Za-z0-9]+)*)?(?:[,] +([A-Z])( +extends +[A-Za-z0-9_]+(?:[<][A-Za-z0-9_, ?]+[>])?(?:[ ]+[&][ ]+[A-Za-z0-9]+)*)?)?)?>)?).*");
    private static final Pattern SUPER_TYPE = Pattern.compile(".*extends +(([A-Z][A-Za-z0-9_]+)(?:<([A-Z][A-Za-z0-9_<> ]*)(?:[,] +([A-Z][A-Za-z0-9_<> ]*)?(?:[,] +([A-Z][A-Za-z0-9_<> ]*)?)?)?>)?).*");
    private static final Pattern SUPER_IMPL_TYPE = Pattern.compile(".*implements.*[ ,]((Immutable)?Bean)([ ,{]|$).*");
    private static final Pattern SERIALIZABLE_TYPE = Pattern.compile(".*implements.*[ ,]Serializable([ ,{]|$).*");
    private static final Pattern STYLE_PATTERN = Pattern.compile(".*[ ,(]style[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern META_SCOPE_PATTERN = Pattern.compile(".*[ ,(]metaScope[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern META_IMPLEMENTS_PATTERN = Pattern.compile(".*[ ,(]metaImplements[ ]*[=][ ]*[\"]([a-zA-Z0-9_.<>]*)[\"].*");
    private static final Pattern BUILDER_SCOPE_PATTERN = Pattern.compile(".*[ ,(]builderScope[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern BUILDER_NAME_PATTERN = Pattern.compile(".*[ ,(]builderName[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern CONSTRUCTOR_SCOPE_PATTERN = Pattern.compile(".*[ ,(]constructorScope[ ]*[=][ ]*[\"]([a-zA-Z@]*)[\"].*");
    private static final Pattern FACTORY_NAME_PATTERN = Pattern.compile(".*[ ,(]factoryName[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern HIERARCHY_PATTERN = Pattern.compile(".*[ ,(]hierarchy[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern CACHE_HASH_CODE_PATTERN = Pattern.compile(".*[ ,(]cacheHashCode[ ]*[=][ ]*(true|false).*");
    private static final Pattern CLONE_STYLE_PATTERN = Pattern.compile(".*[ ,(]cloneStyle[ ]*[=][ ]*[\"]([a-zA-Z]*)[\"].*");
    private static final Pattern VALIDATOR_PATTERN = Pattern.compile(".*private[ ]+void[ ]+([a-zA-Z][a-zA-Z0-9]*)[(][ ]*[)].*");
    private static final Pattern DEFAULTS_PATTERN = Pattern.compile(".*private[ ]+static[ ]+void[ ]+([a-zA-Z][a-zA-Z0-9]*)[(][ ]*Builder[ ]+[a-zA-Z][a-zA-Z0-9]*[ ]*[)].*");
    private final File file;
    private final List<String> content;
    private final BeanGenConfig config;
    private int beanDefIndex;
    private int autoStartIndex;
    private int autoEndIndex;
    private List<PropertyGen> properties;

    BeanParser(File file, List<String> content, BeanGenConfig config) {
        this.file = file;
        this.content = content;
        this.config = config;
    }

    File getFile() {
        return this.file;
    }

    String getFieldPrefix() {
        return this.config.getPrefix();
    }

    BeanGenConfig getConfig() {
        return this.config;
    }

    BeanGen parse() {
        BeanData data = new BeanData();
        this.beanDefIndex = this.parseBeanDefinition();
        data.getCurrentImports().addAll(this.parseImports(this.beanDefIndex));
        data.setImportInsertLocation(this.parseImportLocation(this.beanDefIndex));
        if (this.beanDefIndex < 0) {
            return new BeanGen(this.file, this.content, this.config, data);
        }
        data.setBeanStyle(this.parseBeanStyle(this.beanDefIndex));
        data.resolveBeanStyle(this.config.getDefaultStyle());
        if (!data.isBeanStyleValid()) {
            throw new BeanCodeGenException("Invalid bean style: " + data.getBeanStyle(), this.file, this.beanDefIndex);
        }
        data.setConstructorScope(this.parseConstrucorScope(this.beanDefIndex));
        if (!data.isConstructorScopeValid()) {
            throw new BeanCodeGenException("Invalid constructor scope: " + data.getConstructorScope(), this.file, this.beanDefIndex);
        }
        data.setBeanMetaScope(this.parseBeanMetaScope(this.beanDefIndex));
        if (!data.isBeanMetaScopeValid()) {
            throw new BeanCodeGenException("Invalid meta-bean scope: " + data.getBeanMetaScope(), this.file, this.beanDefIndex);
        }
        data.setBeanMetaImplements(this.parseBeanMetaImplements(this.beanDefIndex));
        data.setBeanBuilderScope(this.parseBeanBuilderScope(this.beanDefIndex));
        if (!data.isBeanBuilderScopeValid()) {
            throw new BeanCodeGenException("Invalid bean builder scope: " + data.getBeanBuilderScope(), this.file, this.beanDefIndex);
        }
        data.setBeanBuilderName(this.parseBeanBuilderName(this.beanDefIndex));
        data.setFactoryName(this.parseFactoryName(this.beanDefIndex));
        data.setCacheHashCode(this.parseCacheHashCode(this.beanDefIndex));
        data.setCloneStyle(this.parseCloneStyle(this.beanDefIndex));
        if (!data.isCloneStyleValid()) {
            throw new BeanCodeGenException("Invalid clone style: " + data.getCloneStyle(), this.file, this.beanDefIndex);
        }
        data.setImmutableConstructor(this.parseImmutableConstructor(this.beanDefIndex));
        data.setConstructable(this.parseConstructable(this.beanDefIndex));
        data.setTypeParts(this.parseBeanType(this.beanDefIndex));
        String classHeaderAfterType = this.classHeaderAfterType(this.beanDefIndex, data.getType());
        data.setSuperTypeParts(this.parseBeanSuperType(classHeaderAfterType));
        data.setSerializable(this.parseSerializable(classHeaderAfterType));
        if (this.parseBeanHierarchy(this.beanDefIndex).equals("immutable")) {
            data.setImmutable(true);
            data.setConstructorStyle(1);
        } else if (data.getImmutableConstructor() == 0) {
            if (data.isImmutable()) {
                if (data.isTypeFinal()) {
                    data.setConstructorStyle(2);
                } else {
                    data.setConstructorStyle(1);
                }
            } else if (data.isBeanStyleLight()) {
                data.setConstructorStyle(2);
            } else {
                data.setConstructorStyle(1);
            }
        } else {
            data.setConstructorStyle(data.getImmutableConstructor());
        }
        if (data.isImmutable()) {
            data.setImmutableValidator(this.parseImmutableValidator(this.beanDefIndex));
            data.setImmutableDefaults(this.parseImmutableDefaults(this.beanDefIndex));
            data.setImmutablePreBuild(this.parseImmutablePreBuild(this.beanDefIndex));
            if (data.isBeanStyleLight() && !data.isTypeFinal()) {
                throw new BeanCodeGenException("Invalid bean style: Light beans must be declared final", this.file, this.beanDefIndex);
            }
            if (data.isBeanStyleMinimal() && !data.isTypeFinal()) {
                throw new BeanCodeGenException("Invalid bean style: Minimal beans must be declared final", this.file, this.beanDefIndex);
            }
            if (data.isFactoryRequired() && !data.isRootClass()) {
                throw new BeanCodeGenException("Invalid bean style: Factory method only allowed when bean has no bean superclass", this.file, this.beanDefIndex);
            }
            if (data.isFactoryRequired() && !data.isTypeFinal()) {
                throw new BeanCodeGenException("Invalid bean style: Factory method only allowed when bean is final", this.file, this.beanDefIndex);
            }
        } else {
            if (data.isBeanStyleLight() && !data.isTypeFinal()) {
                throw new BeanCodeGenException("Invalid bean style: Light beans must be declared final", this.file, this.beanDefIndex);
            }
            if (data.isBeanStyleMinimal() && !data.isTypeFinal()) {
                throw new BeanCodeGenException("Invalid bean style: Minimal beans must be declared final", this.file, this.beanDefIndex);
            }
            if (data.isFactoryRequired()) {
                throw new BeanCodeGenException("Invalid bean style: Factory method only allowed when bean is immutable", this.file, this.beanDefIndex);
            }
        }
        this.properties = this.parseProperties(data);
        this.autoStartIndex = this.parseStartAutogen();
        this.autoEndIndex = this.parseEndAutogen();
        data.setManualSerializationId(this.parseManualSerializationId(this.beanDefIndex));
        data.setManualClone(this.parseManualClone(this.beanDefIndex));
        data.setManualEqualsHashCode(this.parseManualEqualsHashCode(this.beanDefIndex));
        data.setManualToStringCode(this.parseManualToStringCode(this.beanDefIndex));
        if (data.isImmutable()) {
            for (PropertyGen prop : this.properties) {
                if (prop.getData().isDerived() || prop.getData().isFinal()) continue;
                throw new BeanCodeGenException("ImmutableBean must have final properties: " + data.getTypeRaw() + "." + prop.getData().getFieldName(), this.file, prop.getData().getLineIndex());
            }
        } else {
            if (data.getImmutableConstructor() > 0) {
                throw new BeanCodeGenException("Mutable beans must not specify @ImmutableConstructor: " + data.getTypeRaw(), this.file, this.beanDefIndex);
            }
            if (!"smart".equals(data.getConstructorScope()) && !data.isBeanStyleLight()) {
                throw new BeanCodeGenException("Mutable beans must not specify @BeanDefinition(constructorScope): " + data.getTypeRaw(), this.file, this.beanDefIndex);
            }
        }
        if (data.isCacheHashCode()) {
            data.setCacheHashCode(data.isImmutable() && !data.isManualEqualsHashCode());
        }
        return new BeanGen(this.file, this.content, this.config, data, this.properties, this.autoStartIndex, this.autoEndIndex);
    }

    private String classHeaderAfterType(int defLine, String fullType) {
        StringBuilder buf = new StringBuilder(128);
        boolean matchedType = false;
        for (int index = defLine; index < this.content.size(); ++index) {
            String line = this.content.get(index);
            if (!matchedType) {
                if (!line.contains(fullType)) continue;
                matchedType = true;
                line = line.substring(line.indexOf(fullType) + fullType.length());
            }
            buf.append(line).append(' ');
            if (line.trim().endsWith("{") && !line.trim().startsWith("@")) break;
        }
        return buf.toString().trim();
    }

    private int parseBeanDefinition() {
        for (int index = 0; index < this.content.size(); ++index) {
            String line = this.content.get(index).trim();
            if (!line.startsWith("@BeanDefinition")) continue;
            return index;
        }
        return -1;
    }

    private Set<String> parseImports(int defLine) {
        int end = defLine < 0 ? this.content.size() : defLine;
        HashSet<String> imports = new HashSet<String>();
        for (int index = 0; index < end; ++index) {
            if (!this.content.get(index).startsWith("import ")) continue;
            String imp = this.content.get(index).substring(7).trim();
            if ((imp = imp.substring(0, imp.indexOf(59))).endsWith(".*")) continue;
            imports.add(imp);
        }
        return imports;
    }

    private int parseImportLocation(int defLine) {
        int end = defLine < 0 ? this.content.size() : defLine;
        int location = 0;
        for (int index = 0; index < end; ++index) {
            if (!this.content.get(index).startsWith("import ") && !this.content.get(index).startsWith("package ")) continue;
            location = index;
        }
        return location;
    }

    private String parseBeanStyle(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = STYLE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseConstrucorScope(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = CONSTRUCTOR_SCOPE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseBeanMetaScope(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = META_SCOPE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseBeanMetaImplements(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = META_IMPLEMENTS_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private String parseBeanBuilderScope(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = BUILDER_SCOPE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private String parseBeanBuilderName(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = BUILDER_NAME_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private String parseFactoryName(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = FACTORY_NAME_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private String parseBeanHierarchy(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = HIERARCHY_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private boolean parseCacheHashCode(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = CACHE_HASH_CODE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return Boolean.valueOf(matcher.group(1));
        }
        return false;
    }

    private String parseCloneStyle(int defLine) {
        String line = this.content.get(defLine).trim();
        Matcher matcher = CLONE_STYLE_PATTERN.matcher(line);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "smart";
    }

    private boolean parseConstructable(int defLine) {
        for (int index = defLine; index < this.content.size(); ++index) {
            if (!this.content.get(index).contains(" abstract class ")) continue;
            return false;
        }
        return true;
    }

    private String[] parseBeanType(int defLine) {
        Matcher matcher = BEAN_TYPE.matcher("");
        for (int index = defLine; index < this.content.size(); ++index) {
            String line = this.content.get(index);
            matcher.reset(line);
            if (matcher.matches()) {
                String startStr = line.substring(0, matcher.start(1));
                String fnl = startStr.contains(" final ") || startStr.startsWith("final ") ? "final" : null;
                String scope = startStr.contains("public ") ? "public" : "package";
                scope = startStr.contains("protected ") ? "protected" : scope;
                scope = startStr.contains("private ") ? "private" : scope;
                return new String[]{fnl, scope, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8)};
            }
            if (line.contains(AUTOGENERATED_START_TEXT)) break;
        }
        throw new BeanCodeGenException("Unable to locate bean class name", this.file, this.beanDefIndex);
    }

    private String[] parseBeanSuperType(String classHeaderAfterType) {
        Matcher matcherImplements = SUPER_IMPL_TYPE.matcher(classHeaderAfterType);
        if (matcherImplements.matches()) {
            return new String[]{matcherImplements.group(1)};
        }
        Matcher matcherExtends = SUPER_TYPE.matcher(classHeaderAfterType);
        if (matcherExtends.matches()) {
            return new String[]{matcherExtends.group(1), matcherExtends.group(2), matcherExtends.group(3), matcherExtends.group(4), matcherExtends.group(5)};
        }
        throw new BeanCodeGenException("Unable to locate bean superclass", this.file, this.beanDefIndex);
    }

    private boolean parseSerializable(String classHeaderAfterType) {
        return SERIALIZABLE_TYPE.matcher(classHeaderAfterType).matches();
    }

    private boolean parseManualSerializationId(int defLine) {
        for (int index = defLine; index < this.autoStartIndex; ++index) {
            if (!this.content.get(index).trim().startsWith("private static final long serialVersionUID")) continue;
            return true;
        }
        return false;
    }

    private int parseImmutableConstructor(int defLine) {
        int found = 0;
        for (int index = defLine; index < this.content.size(); ++index) {
            String nextLine;
            if (!this.content.get(index).trim().equals("@ImmutableConstructor")) continue;
            if (found > 0) {
                throw new BeanCodeGenException("Only one @ImmutableConstructor may be specified", this.file, index);
            }
            found = 2;
            if (index + 1 >= this.content.size() || !(nextLine = this.content.get(index + 1)).contains("Builder ") && !nextLine.contains("Builder<")) continue;
            found = 1;
        }
        return found;
    }

    private String parseImmutableValidator(int defLine) {
        boolean found = false;
        for (int index = defLine; index < this.content.size(); ++index) {
            if (!this.content.get(index).trim().equals("@ImmutableValidator")) continue;
            if (found) {
                throw new BeanCodeGenException("Only one @ImmutableValidator may be specified", this.file, index);
            }
            found = true;
            if (index + 1 >= this.content.size()) continue;
            String nextLine = this.content.get(index + 1);
            Matcher matcher = VALIDATOR_PATTERN.matcher(nextLine);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            throw new BeanCodeGenException("@ImmutableValidator method must be private void and no-args", this.file, index + 1);
        }
        return null;
    }

    private String parseImmutableDefaults(int defLine) {
        boolean found = false;
        for (int index = defLine; index < this.content.size(); ++index) {
            if (!this.content.get(index).trim().equals("@ImmutableDefaults")) continue;
            if (found) {
                throw new BeanCodeGenException("Only one @ImmutableDefaults may be specified", this.file, index);
            }
            found = true;
            if (index + 1 >= this.content.size()) continue;
            String nextLine = this.content.get(index + 1);
            Matcher matcher = DEFAULTS_PATTERN.matcher(nextLine);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            throw new BeanCodeGenException("@ImmutableDefaults method must be private static void and have one argument of type 'Builder'", this.file, index + 1);
        }
        return null;
    }

    private String parseImmutablePreBuild(int defLine) {
        boolean found = false;
        for (int index = defLine; index < this.content.size(); ++index) {
            if (!this.content.get(index).trim().equals("@ImmutablePreBuild")) continue;
            if (found) {
                throw new BeanCodeGenException("Only one @ImmutablePreBuild may be specified", this.file, index);
            }
            found = true;
            if (index + 1 >= this.content.size()) continue;
            String nextLine = this.content.get(index + 1);
            Matcher matcher = DEFAULTS_PATTERN.matcher(nextLine);
            if (matcher.matches()) {
                return matcher.group(1);
            }
            throw new BeanCodeGenException("@ImmutablePreBuild method must be private static void and have one argument of type 'Builder'", this.file, index + 1);
        }
        return null;
    }

    private List<PropertyGen> parseProperties(BeanData data) {
        ArrayList<PropertyGen> props = new ArrayList<PropertyGen>();
        for (int index = 0; index < this.content.size(); ++index) {
            PropertyGen prop;
            String line = this.content.get(index).trim();
            PropertyParser parser = new PropertyParser(this);
            if (line.startsWith("@PropertyDefinition")) {
                prop = parser.parse(data, this.content, index);
                props.add(prop);
                data.getProperties().add(prop.getData());
                continue;
            }
            if (!line.startsWith("@DerivedProperty")) continue;
            prop = parser.parseDerived(data, this.content, index);
            props.add(prop);
            data.getProperties().add(prop.getData());
        }
        return props;
    }

    private int parseStartAutogen() {
        String line;
        int index;
        for (index = 0; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.contains(" AUTOGENERATED START ")) continue;
            this.content.set(index, AUTOGENERATED_START);
            return index;
        }
        for (index = this.content.size() - 1; index >= 0; --index) {
            line = this.content.get(index).trim();
            if (line.equals("}")) {
                this.content.add(index, AUTOGENERATED_START);
                return index;
            }
            if (line.length() > 0) break;
        }
        throw new BeanCodeGenException("Unable to locate start autogeneration point", this.file, this.beanDefIndex);
    }

    private int parseEndAutogen() {
        for (int index = this.autoStartIndex; index < this.content.size(); ++index) {
            String line = this.content.get(index).trim();
            if (!line.contains(" AUTOGENERATED END ")) continue;
            this.content.set(index, AUTOGENERATED_END);
            return index;
        }
        this.content.add(this.autoStartIndex + 1, AUTOGENERATED_END);
        return this.autoStartIndex + 1;
    }

    private boolean parseManualClone(int defLine) {
        String line;
        int index;
        for (index = defLine; index < this.autoStartIndex; ++index) {
            line = this.content.get(index).trim();
            if (!line.startsWith("public ") || !line.endsWith(" clone() {")) continue;
            return true;
        }
        for (index = this.autoEndIndex; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.startsWith("public ") || !line.endsWith(" clone() {")) continue;
            return true;
        }
        return false;
    }

    private boolean parseManualEqualsHashCode(int defLine) {
        String line;
        int index;
        for (index = defLine; index < this.autoStartIndex; ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public int hashCode() {") && (!line.startsWith("public boolean equals(") || !line.endsWith(") {"))) continue;
            return true;
        }
        for (index = this.autoEndIndex; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public int hashCode() {") && (!line.startsWith("public boolean equals(") || !line.endsWith(") {"))) continue;
            return true;
        }
        return false;
    }

    private boolean parseManualToStringCode(int defLine) {
        String line;
        int index;
        for (index = defLine; index < this.autoStartIndex; ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public String toString() {")) continue;
            return true;
        }
        for (index = this.autoEndIndex; index < this.content.size(); ++index) {
            line = this.content.get(index).trim();
            if (!line.equals("public String toString() {")) continue;
            return true;
        }
        return false;
    }
}

