/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.ser.DefaultDeserializer;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.LenientDeserializer;
import org.joda.beans.ser.SerDeserializer;
import org.joda.beans.ser.SerDeserializerProvider;
import org.joda.beans.ser.SerTypeMapper;
import org.joda.convert.RenameHandler;

public final class SerDeserializers {
    private static final Map<Class<?>, SerDeserializer> CLASSPATH_STRICT = SerDeserializers.loadFromClasspath();
    private static final Map<Class<?>, SerDeserializer> CLASSPATH_LENIENT = CLASSPATH_STRICT.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<Class, SerDeserializer>((Class)e.getKey(), SerDeserializers.toLenient((SerDeserializer)e.getValue()))).collect(Collectors.toMap(e -> (Class)e.getKey(), e -> (SerDeserializer)e.getValue()));
    public static final SerDeserializers INSTANCE = new SerDeserializers(false, new SerDeserializerProvider[0]);
    public static final SerDeserializers LENIENT = new SerDeserializers(true, new SerDeserializerProvider[0]);
    private final boolean lenient;
    private final SerDeserializer defaultDeserializer;
    private final ConcurrentMap<Class<?>, SerDeserializer> deserializers = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<SerDeserializerProvider> providers = new CopyOnWriteArrayList();

    public SerDeserializers() {
        this.lenient = false;
        this.defaultDeserializer = DefaultDeserializer.INSTANCE;
        this.deserializers.putAll(CLASSPATH_STRICT);
    }

    public SerDeserializers(SerDeserializerProvider ... providers) {
        this(false, providers);
    }

    public SerDeserializers(boolean lenient, SerDeserializerProvider ... providers) {
        this.lenient = lenient;
        this.defaultDeserializer = lenient ? LenientDeserializer.INSTANCE : DefaultDeserializer.INSTANCE;
        this.deserializers.putAll(lenient ? CLASSPATH_LENIENT : CLASSPATH_STRICT);
        this.providers.addAll(Arrays.asList(providers));
    }

    public SerDeserializers register(Class<?> type, SerDeserializer deserializer) {
        this.deserializers.put(type, deserializer);
        return this;
    }

    public ConcurrentMap<Class<?>, SerDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public SerDeserializers registerProvider(SerDeserializerProvider provider) {
        this.providers.add(provider);
        return this;
    }

    public SerDeserializer findDeserializer(Class<?> type) {
        SerDeserializer deser = (SerDeserializer)this.deserializers.get(type);
        if (deser != null) {
            return deser;
        }
        for (SerDeserializerProvider provider : this.providers) {
            deser = provider.findDeserializer(type);
            if (deser == null) continue;
            return deser;
        }
        return this.defaultDeserializer;
    }

    public Class<?> decodeType(String typeStr, JodaBeanSer settings, String basePackage, Map<String, Class<?>> knownTypes, Class<?> defaultType) throws ClassNotFoundException {
        if (this.lenient) {
            return SerTypeMapper.decodeType(typeStr, settings, basePackage, knownTypes, defaultType == Object.class ? String.class : defaultType);
        }
        return SerTypeMapper.decodeType(typeStr, settings, basePackage, knownTypes);
    }

    private static Map<Class<?>, SerDeserializer> loadFromClasspath() {
        HashMap result = new HashMap();
        URL url = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = RenameHandler.class.getClassLoader();
            }
            Enumeration<URL> en = loader.getResources("META-INF/org/joda/beans/JodaBeans.ini");
            while (en.hasMoreElements()) {
                url = en.nextElement();
                List<String> lines = SerDeserializers.loadRenameFile(url);
                SerDeserializers.parseRenameFile(lines, url, result);
            }
        }
        catch (Error | Exception ex) {
            System.err.println("ERROR: Unable to load JodaBeans.ini: " + url + ": " + ex.getMessage());
            ex.printStackTrace();
            result.clear();
        }
        return result;
    }

    private static List<String> loadRenameFile(URL url) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            List<String> list = reader.lines().filter(line -> !line.isEmpty() && !line.startsWith("#")).collect(Collectors.toList());
            return list;
        }
    }

    private static void parseRenameFile(List<String> lines, URL url, Map<Class<?>, SerDeserializer> map) {
        boolean deserializers = false;
        for (String line : lines) {
            try {
                if (line.equals("[deserializers]")) {
                    deserializers = true;
                    continue;
                }
                if (deserializers) {
                    int equalsPos = line.indexOf(61);
                    String beanName = equalsPos >= 0 ? line.substring(0, equalsPos).trim() : line;
                    String deserName = equalsPos >= 0 ? line.substring(equalsPos + 1).trim() : line;
                    SerDeserializers.registerFromClasspath(beanName, deserName, map);
                    continue;
                }
                throw new IllegalArgumentException("JodaBeans.ini must start with [deserializers]");
            }
            catch (Exception ex) {
                System.err.println("ERROR: Invalid JodaBeans.ini: " + url + ": " + ex.getMessage());
            }
        }
    }

    private static void registerFromClasspath(String beanName, String deserName, Map<Class<?>, SerDeserializer> map) throws Exception {
        SerDeserializer deser;
        Class<Bean> beanClass = Class.forName(beanName).asSubclass(Bean.class);
        Class<?> deserClass = Class.forName(deserName);
        Field field = null;
        try {
            field = deserClass.getDeclaredField("DESERIALIZER");
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalStateException("Field " + field + " must be static");
            }
            deser = (SerDeserializer)SerDeserializer.class.cast(field.get(null));
        }
        catch (NoSuchFieldException ex) {
            Constructor<?> cons = null;
            try {
                cons = deserClass.getConstructor(new Class[0]);
                deser = (SerDeserializer)SerDeserializer.class.cast(cons.newInstance(new Object[0]));
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalStateException("Class " + deserClass.getName() + " must have field DESERIALIZER or a no-arg constructor");
            }
            catch (IllegalAccessException ex2) {
                cons.setAccessible(true);
                deser = (SerDeserializer)SerDeserializer.class.cast(cons.newInstance(new Object[0]));
            }
        }
        catch (IllegalAccessException ex) {
            field.setAccessible(true);
            deser = (SerDeserializer)SerDeserializer.class.cast(field.get(null));
        }
        map.put(beanClass, deser);
    }

    private static SerDeserializer toLenient(final SerDeserializer underlying) {
        return new SerDeserializer(){

            @Override
            public MetaBean findMetaBean(Class<?> beanType) {
                return underlying.findMetaBean(beanType);
            }

            @Override
            public BeanBuilder<?> createBuilder(Class<?> beanType, MetaBean metaBean) {
                return underlying.createBuilder(beanType, metaBean);
            }

            @Override
            public MetaProperty<?> findMetaProperty(Class<?> beanType, MetaBean metaBean, String propertyName) {
                try {
                    return underlying.findMetaProperty(beanType, metaBean, propertyName);
                }
                catch (NoSuchElementException ex) {
                    return null;
                }
            }

            @Override
            public void setValue(BeanBuilder<?> builder, MetaProperty<?> metaProp, Object value) {
                underlying.setValue(builder, metaProp, value);
            }

            @Override
            public Object build(Class<?> beanType, BeanBuilder<?> builder) {
                return underlying.build(beanType, builder);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

