/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.joda.beans.Bean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaProperty;

public class SerOptional {
    private static final Map<Class<?>, Object[]> OPTIONALS;

    public static Object extractValue(MetaProperty<?> metaProp, Bean bean) {
        Object[] helpers;
        Object value = metaProp.get(bean);
        if (value != null && (helpers = OPTIONALS.get(metaProp.propertyType())) != null) {
            try {
                boolean present = (Boolean)((Method)helpers[2]).invoke(value, new Object[0]);
                value = present ? ((Method)helpers[3]).invoke(value, new Object[0]) : null;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return value;
    }

    public static Class<?> extractType(MetaProperty<?> metaProp, Class<?> beanType) {
        Class<?> type = metaProp.propertyType();
        Object[] helpers = OPTIONALS.get(type);
        if (helpers != null) {
            try {
                Class<?> genericType = JodaBeanUtils.extractTypeClass(metaProp, beanType, 1, 0);
                type = genericType != null ? genericType : type;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return type;
    }

    public static Object wrapValue(MetaProperty<?> metaProp, Class<?> beanType, Object value) {
        Object[] helpers = OPTIONALS.get(metaProp.propertyType());
        if (helpers != null) {
            try {
                value = value != null ? ((Method)helpers[0]).invoke(null, value) : helpers[1];
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return value;
    }

    static {
        Method get;
        Method isPresent;
        Object nullConstant;
        Method create;
        Class<?> cls2;
        HashMap map = new HashMap();
        try {
            cls2 = Class.forName("com.google.common.base.Optional");
            create = cls2.getMethod("of", Object.class);
            nullConstant = cls2.getMethod("absent", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls2.getMethod("isPresent", new Class[0]);
            get = cls2.getMethod("get", new Class[0]);
            map.put(cls2, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception cls2) {
            // empty catch block
        }
        try {
            cls2 = Class.forName("java.util.Optional");
            create = cls2.getMethod("of", Object.class);
            nullConstant = cls2.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls2.getMethod("isPresent", new Class[0]);
            get = cls2.getMethod("get", new Class[0]);
            map.put(cls2, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception cls3) {
            // empty catch block
        }
        try {
            cls2 = Class.forName("java.util.OptionalDouble");
            create = cls2.getMethod("of", Double.TYPE);
            nullConstant = cls2.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls2.getMethod("isPresent", new Class[0]);
            get = cls2.getMethod("getAsDouble", new Class[0]);
            map.put(cls2, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception cls4) {
            // empty catch block
        }
        try {
            cls2 = Class.forName("java.util.OptionalInt");
            create = cls2.getMethod("of", Integer.TYPE);
            nullConstant = cls2.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls2.getMethod("isPresent", new Class[0]);
            get = cls2.getMethod("getAsInt", new Class[0]);
            map.put(cls2, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception cls5) {
            // empty catch block
        }
        try {
            cls2 = Class.forName("java.util.OptionalLong");
            create = cls2.getMethod("of", Long.TYPE);
            nullConstant = cls2.getMethod("empty", new Class[0]).invoke(null, new Object[0]);
            isPresent = cls2.getMethod("isPresent", new Class[0]);
            get = cls2.getMethod("getAsLong", new Class[0]);
            map.put(cls2, new Object[]{create, nullConstant, isPresent, get});
        }
        catch (Exception exception) {
            // empty catch block
        }
        OPTIONALS = map.isEmpty() ? Collections.emptyMap() : map;
    }
}

