/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.direct;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.MetaBean;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicMetaProperty;
import org.joda.beans.impl.direct.DirectBean;
import org.joda.beans.impl.direct.DirectMetaBean;

public final class DirectMetaProperty<P>
extends BasicMetaProperty<P> {
    private final MetaBean metaBean;
    private final Class<P> propertyType;
    private final Class<?> declaringType;
    private final AccessibleObject fieldOrMethod;
    private final PropertyStyle style;

    public static <P> DirectMetaProperty<P> ofReadWrite(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        Field field = DirectMetaProperty.findField(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyStyle.READ_WRITE, field);
    }

    public static <P> DirectMetaProperty<P> ofReadOnly(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        Field field = DirectMetaProperty.findField(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyStyle.READ_ONLY, field);
    }

    public static <P> DirectMetaProperty<P> ofWriteOnly(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        Field field = DirectMetaProperty.findField(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyStyle.WRITE_ONLY, field);
    }

    public static <P> DirectMetaProperty<P> ofReadOnlyBuildable(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        Field field = DirectMetaProperty.findField(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyStyle.READ_ONLY_BUILDABLE, field);
    }

    public static <P> DirectMetaProperty<P> ofDerived(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        AccessibleObject method = DirectMetaProperty.findMethod(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyStyle.DERIVED, method);
    }

    public static <P> DirectMetaProperty<P> ofImmutable(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType) {
        Field field = DirectMetaProperty.findField(metaBean, propertyName);
        return new DirectMetaProperty<P>(metaBean, propertyName, declaringType, propertyType, PropertyStyle.IMMUTABLE, field);
    }

    private static Field findField(MetaBean metaBean, String propertyName) {
        for (Class<? extends Bean> cls = metaBean.beanType(); cls != DirectBean.class && cls != Object.class && cls != null; cls = cls.getSuperclass()) {
            try {
                return cls.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException ex) {
                try {
                    return cls.getDeclaredField("_" + propertyName);
                }
                catch (NoSuchFieldException ex2) {
                    continue;
                }
            }
        }
        return null;
    }

    private static AccessibleObject findMethod(MetaBean metaBean, String propertyName) {
        String methodName = "get" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        for (Class<? extends Bean> cls = metaBean.beanType(); cls != DirectBean.class && cls != Object.class && cls != null; cls = cls.getSuperclass()) {
            try {
                return cls.getDeclaredMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        return DirectMetaProperty.findField(metaBean, propertyName);
    }

    private DirectMetaProperty(MetaBean metaBean, String propertyName, Class<?> declaringType, Class<P> propertyType, PropertyStyle style, AccessibleObject fieldOrMethod) {
        super(propertyName);
        if (metaBean == null) {
            throw new NullPointerException("MetaBean must not be null");
        }
        if (declaringType == null) {
            throw new NullPointerException("Declaring type must not be null");
        }
        if (propertyType == null) {
            throw new NullPointerException("Property type must not be null");
        }
        if (style == null) {
            throw new NullPointerException("PropertyStyle must not be null");
        }
        this.metaBean = metaBean;
        this.propertyType = propertyType;
        this.declaringType = declaringType;
        this.style = style;
        this.fieldOrMethod = fieldOrMethod;
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    @Override
    public Class<?> declaringType() {
        return this.declaringType;
    }

    @Override
    public Class<P> propertyType() {
        return this.propertyType;
    }

    @Override
    public Type propertyGenericType() {
        if (this.fieldOrMethod == null) {
            return this.propertyType;
        }
        return this.fieldOrMethod instanceof Field ? ((Field)this.fieldOrMethod).getGenericType() : ((Method)this.fieldOrMethod).getGenericReturnType();
    }

    @Override
    public PropertyStyle style() {
        return this.style;
    }

    @Override
    public <A extends Annotation> A annotation(Class<A> annotationClass) {
        if (this.fieldOrMethod == null) {
            throw new UnsupportedOperationException("Field not found for property: " + this.name());
        }
        A annotation = this.fieldOrMethod.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new NoSuchElementException("Unknown annotation: " + annotationClass.getName());
        }
        return annotation;
    }

    @Override
    public <A extends Annotation> Optional<A> annotationOpt(Class<A> annotationClass) {
        return this.fieldOrMethod == null ? Optional.empty() : Optional.ofNullable(this.fieldOrMethod.getAnnotation(annotationClass));
    }

    @Override
    public List<Annotation> annotations() {
        if (this.fieldOrMethod == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.fieldOrMethod.getDeclaredAnnotations());
    }

    @Override
    public P get(Bean bean) {
        DirectMetaBean meta = (DirectMetaBean)bean.metaBean();
        return (P)meta.propertyGet(bean, this.name(), false);
    }

    @Override
    public void set(Bean bean, Object value) {
        DirectMetaBean meta = (DirectMetaBean)bean.metaBean();
        meta.propertySet(bean, this.name(), value, false);
    }
}

