/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.gen;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanData;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.BeanGenConfig;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyData;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.gen.PropertyGen;
import org.joda.beans.impl.BasicBeanBuilder;
import org.joda.beans.impl.direct.DirectBean;
import org.joda.beans.impl.direct.DirectBeanBuilder;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;
import org.joda.beans.impl.light.LightMetaBean;

class BeanGen {
    static final int CONSTRUCTOR_NONE = 0;
    static final int CONSTRUCTOR_BY_BUILDER = 1;
    static final int CONSTRUCTOR_BY_ARGS = 2;
    private static final Class<?> CLASS_CONSTRUCTOR_PROPERTIES;
    private static final Class<?> CLASS_PROPERTY_CHANGE_SUPPORT;
    private static final String LINE_SEPARATOR = "\t//-----------------------------------------------------------------------";
    private static final String LINE_SEPARATOR_INDENTED = "\t\t//-----------------------------------------------------------------------";
    private static final Set<String> PRIMITIVE_EQUALS;
    private final File file;
    private final List<String> content;
    private final BeanGenConfig config;
    private final BeanData data;
    private final List<PropertyGen> properties;
    private final List<String> insertRegion;
    private final SortedSet<String> removedImports = new TreeSet<String>();

    BeanGen(File file, List<String> content, BeanGenConfig config, BeanData data) {
        this.file = file;
        this.content = content;
        this.config = config;
        this.data = data;
        this.properties = null;
        this.insertRegion = null;
    }

    BeanGen(File file, List<String> content, BeanGenConfig config, BeanData data, List<PropertyGen> properties, int autoStartIndex, int autoEndIndex) {
        this.file = file;
        this.content = content;
        this.config = config;
        this.data = data;
        this.properties = properties;
        this.insertRegion = content.subList(autoStartIndex + 1, autoEndIndex);
    }

    void process() {
        this.fixImports();
        if (this.insertRegion != null) {
            this.data.ensureImport(BeanDefinition.class);
            if (this.properties.size() > 0) {
                this.data.ensureImport(PropertyDefinition.class);
            }
            this.removeOld();
            if (this.data.isRootClass() && this.data.isExtendsDirectBean()) {
                this.data.ensureImport(DirectBean.class);
            }
            this.generateMeta();
            this.generateSerializationVersionId();
            this.generatePropertyChangeSupportField();
            this.generateHashCodeField();
            this.generateFactory();
            this.generateImmutableBuilderMethod();
            this.generateArgBasedConstructor();
            this.generateBuilderBasedConstructor();
            this.generateMetaBean();
            this.generateGettersSetters();
            this.generateSeparator();
            this.generateImmutableToBuilder();
            this.generateClone();
            this.generateEquals();
            this.generateHashCode();
            this.generateToString();
            this.generateMetaClass();
            this.generateBuilderClass();
            this.resolveImports();
            this.resolveIndents();
        }
    }

    void processNonBean() {
        this.fixImports();
        this.resolveImports();
    }

    private void fixImports() {
        this.renameImport("org.joda.beans.BeanDefinition", BeanDefinition.class);
        this.renameImport("org.joda.beans.DerivedProperty", DerivedProperty.class);
        this.renameImport("org.joda.beans.ImmutableConstructor", ImmutableConstructor.class);
        this.renameImport("org.joda.beans.ImmutableDefaults", ImmutableDefaults.class);
        this.renameImport("org.joda.beans.ImmutablePreBuild", ImmutablePreBuild.class);
        this.renameImport("org.joda.beans.ImmutableValidator", ImmutableValidator.class);
        this.renameImport("org.joda.beans.PropertyDefinition", PropertyDefinition.class);
    }

    private void renameImport(String old, Class<?> cls) {
        if (this.data.getCurrentImports().contains(old)) {
            this.removedImports.add(old);
            this.data.ensureImport(cls);
        }
    }

    private void resolveImports() {
        if (this.data.getNewImports().size() > 0) {
            int pos = this.data.getImportInsertLocation() + 1;
            for (String imp : this.data.getNewImports()) {
                this.content.add(pos++, "import " + imp + ";");
            }
        }
        if (this.removedImports.size() > 0) {
            ListIterator<String> it = this.content.listIterator();
            while (it.hasNext()) {
                String imported;
                String line = it.next().trim();
                if (!line.startsWith("import ") || !this.removedImports.contains(imported = line.substring(7).trim().replace(" ", "").replace(";", ""))) continue;
                it.remove();
            }
        }
    }

    private void resolveIndents() {
        ListIterator<String> it = this.content.listIterator();
        while (it.hasNext()) {
            it.set(it.next().replace("\t", this.config.getIndent()));
        }
    }

    private void removeOld() {
        this.insertRegion.clear();
    }

    private void generateSeparator() {
        if (this.insertRegion.size() > 0 && this.insertRegion.get(this.insertRegion.size() - 1).equals(LINE_SEPARATOR)) {
            return;
        }
        this.addLine(0, LINE_SEPARATOR);
    }

    private void generateIndentedSeparator() {
        if (this.insertRegion.size() > 0 && this.insertRegion.get(this.insertRegion.size() - 1).equals(LINE_SEPARATOR_INDENTED)) {
            return;
        }
        this.addLine(0, LINE_SEPARATOR_INDENTED);
    }

    private void generateFactory() {
        if (this.data.isFactoryRequired()) {
            Object prop;
            int i;
            List<PropertyGen> nonDerived = this.nonDerivedProperties();
            this.addLine(1, "/**");
            this.addLine(1, " * Obtains an instance.");
            if (nonDerived.size() > 0) {
                if (this.data.isTypeGeneric()) {
                    for (int j = 0; j < this.data.getTypeGenericCount(); ++j) {
                        this.addLine(1, " * @param " + this.data.getTypeGenericName(j, true) + "  the type");
                    }
                }
                for (i = 0; i < nonDerived.size(); ++i) {
                    prop = nonDerived.get(i).getData();
                    this.addLine(1, " * @param " + ((PropertyData)prop).getPropertyName() + "  the value of the property" + ((PropertyData)prop).getNotNullJavadoc());
                }
            }
            this.addLine(1, " * @return the instance");
            this.addLine(1, " */");
            if (nonDerived.isEmpty()) {
                this.addLine(1, "public static " + this.data.getTypeNoExtends() + " " + this.data.getFactoryName() + "() {");
                this.addLine(2, "return new " + this.data.getTypeNoExtends() + "();");
            } else {
                if (this.data.isTypeGeneric()) {
                    this.addLine(1, "public static " + this.data.getTypeGeneric(true) + " " + this.data.getTypeNoExtends() + " " + this.data.getFactoryName() + "(");
                } else {
                    this.addLine(1, "public static " + this.data.getTypeNoExtends() + " " + this.data.getFactoryName() + "(");
                }
                for (i = 0; i < nonDerived.size(); ++i) {
                    prop = nonDerived.get(i);
                    this.addLine(3, ((PropertyGen)prop).getBuilderType() + " " + ((PropertyGen)prop).getData().getPropertyName() + BeanGen.joinComma(i, nonDerived, ") {"));
                }
                this.addLine(2, "return new " + this.data.getTypeWithDiamond() + "(");
                for (i = 0; i < nonDerived.size(); ++i) {
                    this.addLine(3, nonDerived.get(i).generateBuilderFieldName() + BeanGen.joinComma(i, nonDerived, ");"));
                }
            }
            this.addLine(1, "}");
            this.addBlankLine();
        }
    }

    private void generateImmutableBuilderMethod() {
        if (this.data.isConstructable() && this.data.isBuilderGenerated()) {
            this.addLine(1, "/**");
            this.addLine(1, " * Returns a builder used to create an instance of the bean.");
            if (this.data.isTypeGeneric()) {
                for (int j = 0; j < this.data.getTypeGenericCount(); ++j) {
                    this.addLine(1, " * @param " + this.data.getTypeGenericName(j, true) + "  the type");
                }
            }
            this.addLine(1, " * @return the builder, not null");
            this.addLine(1, " */");
            if (this.data.isTypeGeneric()) {
                this.addLine(1, this.data.getEffectiveBuilderScope() + "static " + this.data.getTypeGeneric(true) + " " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + " builder() {");
            } else {
                this.addLine(1, this.data.getEffectiveBuilderScope() + "static " + this.data.getTypeRaw() + ".Builder builder() {");
            }
            this.addLine(2, "return new " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericDiamond() + "();");
            this.addLine(1, "}");
            this.addBlankLine();
        }
    }

    private void generateBuilderBasedConstructor() {
        if (this.data.getConstructorStyle() == 1 && this.data.getImmutableConstructor() == 0 && (this.data.isMutable() && this.data.isBuilderScopeVisible() || this.data.isImmutable())) {
            List<PropertyGen> nonDerived = this.nonDerivedProperties();
            String scope = this.data.isTypeFinal() ? "private" : "protected";
            this.addLine(1, "/**");
            this.addLine(1, " * Restricted constructor.");
            this.addLine(1, " * @param builder  the builder to copy from, not null");
            this.addLine(1, " */");
            this.addLine(1, scope + " " + this.data.getTypeRaw() + "(" + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + " builder) {");
            if (this.data.isSubClass()) {
                this.addLine(2, "super(builder);");
            }
            for (PropertyGen prop : this.properties) {
                if (!prop.getData().isValidated()) continue;
                this.addLine(2, prop.getData().getValidationMethodName() + "(builder." + prop.generateBuilderFieldName() + ", \"" + prop.getData().getPropertyName() + "\");");
            }
            if (this.data.isImmutable()) {
                for (int i = 0; i < nonDerived.size(); ++i) {
                    this.addLines(nonDerived.get(i).generateConstructorAssign("builder."));
                }
            } else {
                for (int i = 0; i < nonDerived.size(); ++i) {
                    PropertyGen propGen = nonDerived.get(i);
                    PropertyData prop = propGen.getData();
                    if (prop.isCollectionType()) {
                        if (prop.isNotNull()) {
                            this.addLine(2, "this." + prop.getPropertyName() + ".addAll(builder." + propGen.generateBuilderFieldName() + ");");
                            continue;
                        }
                        this.addLine(2, "this." + prop.getPropertyName() + " = builder." + propGen.generateBuilderFieldName() + ";");
                        continue;
                    }
                    if (prop.isMapType()) {
                        if (prop.isNotNull()) {
                            this.addLine(2, "this." + prop.getPropertyName() + ".putAll(builder." + propGen.generateBuilderFieldName() + ");");
                            continue;
                        }
                        this.addLine(2, "this." + prop.getPropertyName() + " = builder." + propGen.generateBuilderFieldName() + ";");
                        continue;
                    }
                    this.addLine(2, "this." + prop.getPropertyName() + " = builder." + propGen.generateBuilderFieldName() + ";");
                }
            }
            if (this.data.getImmutableValidator() != null) {
                this.addLine(2, this.data.getImmutableValidator() + "();");
            }
            this.addLine(1, "}");
            this.addBlankLine();
        }
    }

    private void generateArgBasedConstructor() {
        if (this.data.getConstructorStyle() == 2 && this.data.getImmutableConstructor() == 0 && (this.data.isMutable() && (this.data.isBuilderScopeVisible() || this.data.isBeanStyleLight()) || this.data.isImmutable())) {
            String scope = this.data.getEffectiveConstructorScope();
            boolean generateAnnotation = this.data.isConstructorPropertiesAnnotation();
            boolean generateJavadoc = !"private ".equals(scope);
            List<PropertyGen> nonDerived = this.nonDerivedProperties();
            if (nonDerived.size() == 0) {
                if (generateJavadoc) {
                    this.addLine(1, "/**");
                    this.addLine(1, " * Creates an instance.");
                    this.addLine(1, " */");
                }
                if (generateAnnotation) {
                    this.data.ensureImport(CLASS_CONSTRUCTOR_PROPERTIES);
                    this.addLine(1, "@ConstructorProperties({})");
                }
                this.addLine(1, scope + this.data.getTypeRaw() + "() {");
            } else {
                int i;
                if (generateJavadoc) {
                    this.addLine(1, "/**");
                    this.addLine(1, " * Creates an instance.");
                    for (i = 0; i < nonDerived.size(); ++i) {
                        PropertyData prop = nonDerived.get(i).getData();
                        this.addLine(1, " * @param " + prop.getPropertyName() + "  the value of the property" + prop.getNotNullJavadoc());
                    }
                    this.addLine(1, " */");
                }
                if (generateAnnotation) {
                    this.data.ensureImport(CLASS_CONSTRUCTOR_PROPERTIES);
                    StringBuilder buf = new StringBuilder();
                    for (int i2 = 0; i2 < nonDerived.size(); ++i2) {
                        buf.append('\"').append(nonDerived.get(i2).getData().getPropertyName()).append('\"');
                        buf.append(BeanGen.join(i2, nonDerived, ", ", ""));
                    }
                    this.addLine(1, "@ConstructorProperties({" + buf.toString() + "})");
                }
                this.addLine(1, scope + this.data.getTypeRaw() + "(");
                for (i = 0; i < nonDerived.size(); ++i) {
                    PropertyGen prop = nonDerived.get(i);
                    this.addLine(3, prop.getBuilderType() + " " + prop.getData().getPropertyName() + BeanGen.joinComma(i, nonDerived, ") {"));
                }
                if (!this.data.isMutable() || !this.data.isBeanStyleLight()) {
                    for (PropertyGen prop : this.properties) {
                        if (!prop.getData().isValidated()) continue;
                        this.addLine(2, prop.getData().getValidationMethodName() + "(" + prop.getData().getPropertyName() + ", \"" + prop.getData().getPropertyName() + "\");");
                    }
                }
                for (int i3 = 0; i3 < nonDerived.size(); ++i3) {
                    PropertyGen prop = nonDerived.get(i3);
                    if (this.data.isMutable() && this.data.isBeanStyleLight()) {
                        String generateSetInvoke = prop.getData().getSetterGen().generateSetInvoke(prop.getData(), prop.getData().getPropertyName());
                        this.addLine(2, generateSetInvoke + ";");
                        continue;
                    }
                    this.addLines(prop.generateConstructorAssign(""));
                }
            }
            if (this.data.getImmutableValidator() != null) {
                this.addLine(2, this.data.getImmutableValidator() + "();");
            }
            this.addLine(1, "}");
            this.addBlankLine();
        }
    }

    private void generateMeta() {
        if (this.data.isBeanStyleLightOrMinimal()) {
            boolean rawtypes;
            this.addLine(1, "/**");
            this.addLine(1, " * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
            this.addLine(1, " */");
            boolean genericProps = this.data.getProperties().stream().filter(p -> p.isGeneric()).findAny().isPresent();
            boolean unchecked = this.data.isBeanStyleMinimal() && this.data.isMutable() && genericProps;
            boolean bl = rawtypes = this.data.isBeanStyleMinimal() && this.data.isTypeGeneric();
            if ((unchecked |= this.data.isBeanStyleMinimal() && this.data.isTypeGeneric() && !this.data.isSkipBuilderGeneration()) && rawtypes) {
                this.addLine(1, "@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
            } else if (rawtypes) {
                this.addLine(1, "@SuppressWarnings(\"rawtypes\")");
            } else if (unchecked) {
                this.addLine(1, "@SuppressWarnings(\"unchecked\")");
            }
            if (this.data.isTypeGeneric()) {
                this.data.ensureImport(MetaBean.class);
                this.addLine(1, "private static final MetaBean META_BEAN =");
            } else {
                this.data.ensureImport(TypedMetaBean.class);
                this.addLine(1, "private static final TypedMetaBean<" + this.data.getTypeNoExtends() + "> META_BEAN =");
            }
            List<PropertyGen> nonDerived = this.nonDerivedProperties();
            List aliases = nonDerived.stream().filter(p -> p.getData().getAlias() != null).collect(Collectors.toList());
            boolean hasAliases = aliases.isEmpty();
            if (this.data.isBeanStyleLight()) {
                this.data.ensureImport(LightMetaBean.class);
                this.data.ensureImport(MethodHandles.class);
                boolean specialInit = nonDerived.stream().filter(p -> p.isSpecialInit()).findAny().isPresent();
                if (nonDerived.isEmpty()) {
                    this.addLine(3, "LightMetaBean.of(" + this.data.getTypeRaw() + ".class, MethodHandles.lookup());");
                } else {
                    int i;
                    this.addLine(3, "LightMetaBean.of(");
                    this.addLine(5, this.data.getTypeRaw() + ".class,");
                    this.addLine(5, "MethodHandles.lookup(),");
                    this.generateFieldNames(nonDerived);
                    if (specialInit) {
                        for (i = 0; i < nonDerived.size(); ++i) {
                            this.addLine(5, nonDerived.get(i).generateInit() + BeanGen.joinComma(i, nonDerived, ")" + (hasAliases ? ";" : "")));
                        }
                    } else {
                        this.addLine(5, "new Object[0])" + (hasAliases ? ";" : ""));
                    }
                    for (i = 0; i < aliases.size(); ++i) {
                        PropertyGen prop = (PropertyGen)aliases.get(i);
                        this.addLine(5, ".withAlias(\"" + prop.getData().getAlias() + "\", \"" + prop.getData().getPropertyName() + "\")" + BeanGen.join(i, aliases, "", ";"));
                    }
                }
            } else {
                this.data.ensureImport(MinimalMetaBean.class);
                this.addLine(3, "MinimalMetaBean.of(");
                this.addLine(5, this.data.getTypeRaw() + ".class,");
                this.generateFieldNames(nonDerived);
                String builderLambda = "() -> new " + this.data.getTypeRaw() + ".Builder()";
                if (this.data.isSkipBuilderGeneration()) {
                    this.data.ensureImport(BasicBeanBuilder.class);
                    builderLambda = "() -> new BasicBeanBuilder<>(new " + this.data.getTypeWithDiamond() + "())";
                }
                if (nonDerived.isEmpty()) {
                    if (this.data.isImmutable()) {
                        this.addLine(5, builderLambda + ");");
                    } else {
                        this.data.ensureImport(Collections.class);
                        this.data.ensureImport(Function.class);
                        this.data.ensureImport(BiConsumer.class);
                        this.addLine(5, builderLambda + ",");
                        this.addLine(5, "Collections.<Function<" + this.data.getTypeRaw() + ", Object>>emptyList(),");
                        this.addLine(5, "Collections.<BiConsumer<" + this.data.getTypeRaw() + ", Object>>emptyList());");
                    }
                } else {
                    int i;
                    this.addLine(5, builderLambda + ",");
                    if (this.data.isImmutable()) {
                        for (i = 0; i < nonDerived.size(); ++i) {
                            this.addLine(5, nonDerived.get(i).generateLambdaGetter() + BeanGen.joinComma(i, nonDerived, ")" + (hasAliases ? ";" : "")));
                        }
                    } else {
                        this.data.ensureImport(Arrays.class);
                        this.data.ensureImport(Function.class);
                        this.data.ensureImport(BiConsumer.class);
                        this.addLine(5, "Arrays.<Function<" + this.data.getTypeRaw() + ", Object>>asList(");
                        for (i = 0; i < nonDerived.size(); ++i) {
                            this.addLine(7, nonDerived.get(i).generateLambdaGetter() + BeanGen.joinComma(i, nonDerived, "),"));
                        }
                        this.addLine(5, "Arrays.<BiConsumer<" + this.data.getTypeRaw() + ", Object>>asList(");
                        for (i = 0; i < nonDerived.size(); ++i) {
                            this.addLine(7, nonDerived.get(i).generateLambdaSetter() + BeanGen.joinComma(i, nonDerived, "))" + (hasAliases ? ";" : "")));
                        }
                    }
                    for (i = 0; i < aliases.size(); ++i) {
                        PropertyGen prop = (PropertyGen)aliases.get(i);
                        this.addLine(5, ".withAlias(\"" + prop.getData().getAlias() + "\", \"" + prop.getData().getPropertyName() + "\")" + BeanGen.join(i, aliases, "", ";"));
                    }
                }
            }
            this.addBlankLine();
            this.addLine(1, "/**");
            this.addLine(1, " * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
            this.addLine(1, " * @return the meta-bean, not null");
            this.addLine(1, " */");
            if (this.data.isTypeGeneric()) {
                this.addLine(1, "public static MetaBean meta() {");
            } else {
                this.addLine(1, "public static TypedMetaBean<" + this.data.getTypeNoExtends() + "> meta() {");
            }
            this.addLine(2, "return META_BEAN;");
            this.addLine(1, "}");
            this.addBlankLine();
            this.addLine(1, "static {");
            this.data.ensureImport(MetaBean.class);
            this.addLine(2, "MetaBean.register(META_BEAN);");
            this.addLine(1, "}");
            this.addBlankLine();
        } else {
            this.addLine(1, "/**");
            this.addLine(1, " * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
            this.addLine(1, " * @return the meta-bean, not null");
            if (this.data.isMetaScopePrivate()) {
                this.data.ensureImport(MetaBean.class);
                this.addLine(1, " */");
                this.addLine(1, "public static MetaBean meta() {");
            } else if (this.data.isTypeGeneric()) {
                this.addLine(1, " */");
                this.addLine(1, "@SuppressWarnings(\"rawtypes\")");
                this.addLine(1, "public static " + this.data.getTypeRaw() + ".Meta meta() {");
            } else {
                this.addLine(1, " */");
                this.addLine(1, "public static " + this.data.getTypeRaw() + ".Meta meta() {");
            }
            this.addLine(2, "return " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
            this.addLine(1, "}");
            if (this.data.isTypeGeneric()) {
                this.generateMetaForGenericType();
            }
            this.addBlankLine();
            this.addLine(1, "static {");
            this.data.ensureImport(MetaBean.class);
            this.addLine(2, "MetaBean.register(" + this.data.getTypeRaw() + ".Meta.INSTANCE);");
            this.addLine(1, "}");
            this.addBlankLine();
        }
    }

    private void generateFieldNames(List<PropertyGen> nonDerived) {
        if (nonDerived.isEmpty()) {
            this.addLine(5, "new String[0],");
        } else {
            this.addLine(5, "new String[] {");
            for (int i = 0; i < nonDerived.size(); ++i) {
                this.addLine(7, "\"" + nonDerived.get(i).getData().getFieldName() + BeanGen.join(i, nonDerived, "\",", "\"},"));
            }
        }
    }

    private void generateMetaForGenericType() {
        this.addBlankLine();
        this.addLine(1, "/**");
        this.addLine(1, " * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
        if (this.data.getTypeGenericCount() == 1) {
            this.addLine(1, " * @param <R>  the bean's generic type");
            this.addLine(1, " * @param cls  the bean's generic type");
        } else if (this.data.getTypeGenericCount() == 2) {
            this.addLine(1, " * @param <R>  the first generic type");
            this.addLine(1, " * @param <S>  the second generic type");
            this.addLine(1, " * @param cls1  the first generic type");
            this.addLine(1, " * @param cls2  the second generic type");
        } else if (this.data.getTypeGenericCount() == 3) {
            this.addLine(1, " * @param <R>  the first generic type");
            this.addLine(1, " * @param <S>  the second generic type");
            this.addLine(1, " * @param <T>  the second generic type");
            this.addLine(1, " * @param cls1  the first generic type");
            this.addLine(1, " * @param cls2  the second generic type");
            this.addLine(1, " * @param cls3  the third generic type");
        }
        this.addLine(1, " * @return the meta-bean, not null");
        this.addLine(1, " */");
        this.addLine(1, "@SuppressWarnings(\"unchecked\")");
        String[] typeNames = new String[]{"R", "S", "T"};
        if (this.data.getTypeGenericCount() == 1) {
            this.addLine(1, "public static <R" + this.data.getTypeGenericExtends(0, typeNames) + "> " + this.data.getTypeRaw() + ".Meta<R> meta" + this.data.getTypeRaw() + "(Class<R> cls) {");
        } else if (this.data.getTypeGenericCount() == 2) {
            this.addLine(1, "public static <R" + this.data.getTypeGenericExtends(0, typeNames) + ", S" + this.data.getTypeGenericExtends(1, typeNames) + "> " + this.data.getTypeRaw() + ".Meta<R, S> meta" + this.data.getTypeRaw() + "(Class<R> cls1, Class<S> cls2) {");
        } else if (this.data.getTypeGenericCount() == 3) {
            this.addLine(1, "public static <R" + this.data.getTypeGenericExtends(0, typeNames) + ", S" + this.data.getTypeGenericExtends(1, typeNames) + ", T" + this.data.getTypeGenericExtends(2, typeNames) + "> " + this.data.getTypeRaw() + ".Meta<R, S, T> meta" + this.data.getTypeRaw() + "(Class<R> cls1, Class<S> cls2, Class<T> cls3) {");
        }
        this.addLine(2, "return " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
        this.addLine(1, "}");
    }

    private void generateSerializationVersionId() {
        if (this.data.isSerializable() && !this.data.isManualSerializationId()) {
            this.addLine(1, "/**");
            this.addLine(1, " * The serialization version id.");
            this.addLine(1, " */");
            this.addLine(1, "private static final long serialVersionUID = 1L;");
            this.addBlankLine();
        }
    }

    private void generatePropertyChangeSupportField() {
        if (this.data.isPropertyChangeSupport()) {
            this.data.ensureImport(CLASS_PROPERTY_CHANGE_SUPPORT);
            this.addLine(1, "/**");
            this.addLine(1, " * The property change support field.");
            this.addLine(1, " */");
            this.addLine(1, "private final transient PropertyChangeSupport " + this.config.getPrefix() + "propertyChangeSupport = new PropertyChangeSupport(this);");
            this.addBlankLine();
        }
    }

    private void generateHashCodeField() {
        if (this.data.isCacheHashCode()) {
            this.addLine(1, "/**");
            this.addLine(1, " * The cached hash code, using the racy single-check idiom.");
            this.addLine(1, " */");
            this.addLine(1, "private transient int " + this.config.getPrefix() + "cacheHashCode;");
            this.addBlankLine();
        }
    }

    private void generateMetaBean() {
        if (this.data.isMetaScopePrivate() || this.data.isBeanStyleMinimal()) {
            this.addLine(1, "@Override");
            if (this.data.isBeanStyleLightOrMinimal()) {
                this.data.ensureImport(TypedMetaBean.class);
                if (this.data.isTypeGeneric()) {
                    this.addLine(1, "@SuppressWarnings(\"unchecked\")");
                }
                this.addLine(1, "public TypedMetaBean<" + this.data.getTypeNoExtends() + "> metaBean() {");
                if (this.data.isTypeGeneric()) {
                    this.addLine(2, "return (TypedMetaBean<" + this.data.getTypeNoExtends() + ">) META_BEAN;");
                } else {
                    this.addLine(2, "return META_BEAN;");
                }
            } else {
                this.data.ensureImport(MetaBean.class);
                this.addLine(1, "public MetaBean metaBean() {");
                this.addLine(2, "return " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
            }
            this.addLine(1, "}");
            this.addBlankLine();
        } else {
            if (this.data.isTypeGeneric()) {
                this.addLine(1, "@SuppressWarnings(\"unchecked\")");
            }
            this.addLine(1, "@Override");
            this.addLine(1, "public " + this.data.getTypeRaw() + ".Meta" + this.data.getTypeGenericName(true) + " metaBean() {");
            this.addLine(2, "return " + this.data.getTypeRaw() + ".Meta.INSTANCE;");
            this.addLine(1, "}");
            this.addBlankLine();
        }
    }

    private void generateGettersSetters() {
        for (PropertyGen prop : this.properties) {
            this.generateSeparator();
            this.addLines(prop.generateGetter());
            if (this.data.isMutable()) {
                this.addLines(prop.generateSetter());
            }
            if (!this.data.isBeanStyleGenerateProperties()) continue;
            this.addLines(prop.generateProperty());
        }
    }

    private void generateImmutableToBuilder() {
        if (this.data.isBuilderGenerated()) {
            if (this.data.isConstructable()) {
                List<PropertyGen> nonDerived = this.nonDerivedProperties();
                if (nonDerived.size() > 0 || !this.data.isTypeFinal()) {
                    this.addLine(1, "/**");
                    this.addLine(1, " * Returns a builder that allows this bean to be mutated.");
                    this.addLine(1, " * @return the mutable builder, not null");
                    this.addLine(1, " */");
                    if (!this.data.isRootClass()) {
                        this.addLine(1, "@Override");
                    }
                    this.addLine(1, this.data.getEffectiveBuilderScope() + "Builder" + this.data.getTypeGenericName(true) + " toBuilder() {");
                    this.addLine(2, "return new Builder" + this.data.getTypeGenericDiamond() + "(this);");
                    this.addLine(1, "}");
                    this.addBlankLine();
                }
            } else {
                this.addLine(1, "/**");
                this.addLine(1, " * Returns a builder that allows this bean to be mutated.");
                this.addLine(1, " * @return the mutable builder, not null");
                this.addLine(1, " */");
                if (!this.data.isRootClass()) {
                    this.addLine(1, "@Override");
                }
                this.addLine(1, "public abstract Builder" + this.data.getTypeGenericName(true) + " toBuilder();");
                this.addBlankLine();
            }
        }
    }

    private void generateClone() {
        if (this.data.isSkipCloneGeneration() || this.data.isManualClone() || !this.data.isRootClass() && !this.data.isConstructable()) {
            return;
        }
        this.addLine(1, "@Override");
        if (this.data.isImmutable()) {
            this.addLine(1, "public " + this.data.getTypeNoExtends() + " clone() {");
            this.addLine(2, "return this;");
        } else {
            this.data.ensureImport(JodaBeanUtils.class);
            this.addLine(1, "public " + this.data.getTypeNoExtends() + " clone() {");
            this.addLine(2, "return JodaBeanUtils.cloneAlways(this);");
        }
        this.addLine(1, "}");
        this.addBlankLine();
    }

    private void generateEquals() {
        if (this.data.isManualEqualsHashCode()) {
            return;
        }
        this.addLine(1, "@Override");
        this.addLine(1, "public boolean equals(Object obj) {");
        this.addLine(2, "if (obj == this) {");
        this.addLine(3, "return true;");
        this.addLine(2, "}");
        this.addLine(2, "if (obj != null && obj.getClass() == this.getClass()) {");
        List<PropertyGen> nonDerived = this.nonDerivedEqualsHashCodeProperties();
        if (nonDerived.size() == 0) {
            if (this.data.isSubClass()) {
                this.addLine(3, "return super.equals(obj);");
            } else {
                this.addLine(3, "return true;");
            }
        } else {
            this.addLine(3, this.data.getTypeWildcard() + " other = (" + this.data.getTypeWildcard() + ") obj;");
            for (int i = 0; i < nonDerived.size(); ++i) {
                PropertyGen prop = nonDerived.get(i);
                String getter = this.equalsHashCodeFieldAccessor(prop);
                this.data.ensureImport(JodaBeanUtils.class);
                String equals = "JodaBeanUtils.equal(" + getter + ", other." + getter + ")";
                if (PRIMITIVE_EQUALS.contains(prop.getData().getType())) {
                    equals = "(" + getter + " == other." + getter + ")";
                }
                this.addLine(0, (i == 0 ? "\t\t\treturn " : "\t\t\t\t\t") + equals + (this.data.isSubClass() || i < nonDerived.size() - 1 ? " &&" : ";"));
            }
            if (this.data.isSubClass()) {
                this.addLine(5, "super.equals(obj);");
            }
        }
        this.addLine(2, "}");
        this.addLine(2, "return false;");
        this.addLine(1, "}");
        this.addBlankLine();
    }

    private void generateHashCode() {
        if (this.data.isManualEqualsHashCode()) {
            return;
        }
        this.addLine(1, "@Override");
        this.addLine(1, "public int hashCode() {");
        if (this.data.isCacheHashCode()) {
            this.addLine(2, "int hash = " + this.config.getPrefix() + "cacheHashCode;");
            this.addLine(2, "if (hash == 0) {");
            if (this.data.isSubClass()) {
                this.addLine(3, "hash = 7;");
            } else {
                this.addLine(3, "hash = getClass().hashCode();");
            }
            this.generateHashCodeContent("\t\t\t");
            if (this.data.isSubClass()) {
                this.addLine(3, "hash = hash ^ super.hashCode();");
            }
            this.addLine(3, this.config.getPrefix() + "cacheHashCode = hash;");
            this.addLine(2, "}");
            this.addLine(2, "return hash;");
        } else {
            if (this.data.isSubClass()) {
                this.addLine(2, "int hash = 7;");
            } else {
                this.addLine(2, "int hash = getClass().hashCode();");
            }
            this.generateHashCodeContent("\t\t");
            if (this.data.isSubClass()) {
                this.addLine(2, "return hash ^ super.hashCode();");
            } else {
                this.addLine(2, "return hash;");
            }
        }
        this.addLine(1, "}");
        this.addBlankLine();
    }

    private void generateHashCodeContent(String indent) {
        List<PropertyGen> nonDerived = this.nonDerivedEqualsHashCodeProperties();
        for (int i = 0; i < nonDerived.size(); ++i) {
            PropertyGen prop = nonDerived.get(i);
            String getter = this.equalsHashCodeFieldAccessor(prop);
            this.data.ensureImport(JodaBeanUtils.class);
            this.addLine(0, indent + "hash = hash * 31 + JodaBeanUtils.hashCode(" + getter + ");");
        }
    }

    private String equalsHashCodeFieldAccessor(PropertyGen prop) {
        if (prop.getData().getEqualsHashCodeStyle().equals("field")) {
            return prop.getData().getFieldName();
        }
        return prop.getData().getGetterGen().generateGetInvoke(prop.getData());
    }

    private void generateToString() {
        if (this.data.isManualToStringCode()) {
            return;
        }
        List<PropertyGen> props = this.toStringProperties();
        if (this.data.isRootClass() && this.data.isTypeFinal()) {
            this.addLine(1, "@Override");
            this.addLine(1, "public String toString() {");
            this.addLine(2, "StringBuilder buf = new StringBuilder(" + (props.size() * 32 + 32) + ");");
            this.addLine(2, "buf.append(\"" + this.data.getTypeRaw() + "{\");");
            if (props.size() > 0) {
                this.data.ensureImport(JodaBeanUtils.class);
                for (int i = 0; i < props.size(); ++i) {
                    PropertyGen prop = props.get(i);
                    String getter = this.toStringFieldAccessor(prop);
                    this.addLine(2, "buf.append(\"" + prop.getData().getPropertyName() + "\").append('=')" + BeanGen.join(i, props, ".append(" + getter + ").append(',').append(' ');", ".append(JodaBeanUtils.toString(" + getter + "));"));
                }
            }
            this.addLine(2, "buf.append('}');");
            this.addLine(2, "return buf.toString();");
            this.addLine(1, "}");
            this.addBlankLine();
            return;
        }
        this.addLine(1, "@Override");
        this.addLine(1, "public String toString() {");
        this.addLine(2, "StringBuilder buf = new StringBuilder(" + (props.size() * 32 + 32) + ");");
        this.addLine(2, "buf.append(\"" + this.data.getTypeRaw() + "{\");");
        this.addLine(2, "int len = buf.length();");
        this.addLine(2, "toString(buf);");
        this.addLine(2, "if (buf.length() > len) {");
        this.addLine(3, "buf.setLength(buf.length() - 2);");
        this.addLine(2, "}");
        this.addLine(2, "buf.append('}');");
        this.addLine(2, "return buf.toString();");
        this.addLine(1, "}");
        this.addBlankLine();
        if (this.data.isSubClass()) {
            this.addLine(1, "@Override");
        }
        this.addLine(1, "protected void toString(StringBuilder buf) {");
        if (this.data.isSubClass()) {
            this.addLine(2, "super.toString(buf);");
        }
        for (int i = 0; i < props.size(); ++i) {
            PropertyGen prop = props.get(i);
            String getter = this.toStringFieldAccessor(prop);
            this.data.ensureImport(JodaBeanUtils.class);
            this.addLine(2, "buf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + ")).append(',').append(' ');");
        }
        this.addLine(1, "}");
        this.addBlankLine();
    }

    private String toStringFieldAccessor(PropertyGen prop) {
        if (prop.getData().isDerived()) {
            return prop.getData().getGetterGen().generateGetInvoke(prop.getData());
        }
        if (prop.getData().getToStringStyle().equals("field")) {
            return prop.getData().getFieldName();
        }
        return prop.getData().getGetterGen().generateGetInvoke(prop.getData());
    }

    private void generateMetaClass() {
        String finalType;
        String superMeta;
        if (this.data.isBeanStyleLightOrMinimal()) {
            return;
        }
        this.generateSeparator();
        this.addLine(1, "/**");
        this.addLine(1, " * The meta-bean for {@code " + this.data.getTypeRaw() + "}.");
        if (this.data.isTypeGeneric()) {
            for (int j = 0; j < this.data.getTypeGenericCount(); ++j) {
                this.addLine(1, " * @param " + this.data.getTypeGenericName(j, true) + "  the type");
            }
        }
        this.addLine(1, " */");
        if (this.data.isSubClass()) {
            superMeta = this.data.getSuperTypeRaw() + ".Meta" + this.data.getSuperTypeGeneric(true);
        } else {
            this.data.ensureImport(DirectMetaBean.class);
            superMeta = "DirectMetaBean";
        }
        String string = finalType = this.data.isTypeFinal() ? "final " : "";
        if (this.data.isTypeGeneric()) {
            this.addLine(1, this.data.getEffectiveMetaScope() + "static " + finalType + "class Meta" + this.data.getTypeGeneric(true) + " extends " + superMeta + " {");
        } else {
            this.addLine(1, this.data.getEffectiveMetaScope() + "static " + finalType + "class Meta extends " + superMeta + " {");
        }
        this.addLine(2, "/**");
        this.addLine(2, " * The singleton instance of the meta-bean.");
        this.addLine(2, " */");
        if (this.data.isTypeGeneric()) {
            this.addLine(2, "@SuppressWarnings(\"rawtypes\")");
        }
        this.addLine(2, "static final Meta INSTANCE = new Meta();");
        this.addBlankLine();
        this.generateMetaPropertyConstants();
        this.generateMetaPropertyMapSetup();
        this.addLine(2, "/**");
        this.addLine(2, " * Restricted constructor.");
        this.addLine(2, " */");
        this.addLine(2, this.data.getNestedClassConstructorScope() + " Meta() {");
        this.addLine(2, "}");
        this.addBlankLine();
        this.generateMetaPropertyGet();
        this.generateMetaBuilder();
        this.generateMetaBeanType();
        this.generateMetaPropertyMap();
        this.generateIndentedSeparator();
        this.generateMetaPropertyMethods();
        this.generateIndentedSeparator();
        this.generateMetaGetPropertyValue();
        this.generateMetaSetPropertyValue();
        this.generateMetaValidate();
        this.addLine(1, "}");
        this.addBlankLine();
    }

    private void generateMetaPropertyConstants() {
        for (PropertyGen prop : this.properties) {
            this.addLines(prop.generateMetaPropertyConstant());
        }
    }

    private void generateMetaPropertyMapSetup() {
        this.data.ensureImport(MetaProperty.class);
        this.data.ensureImport(DirectMetaPropertyMap.class);
        this.addLine(2, "/**");
        this.addLine(2, " * The meta-properties.");
        this.addLine(2, " */");
        this.addLine(2, "private final Map<String, MetaProperty<?>> " + this.config.getPrefix() + "metaPropertyMap$ = new DirectMetaPropertyMap(");
        if (this.data.isSubClass()) {
            this.addLine(4, "this, (DirectMetaPropertyMap) super.metaPropertyMap()" + (this.properties.size() == 0 ? ");" : ","));
        } else {
            this.addLine(4, "this, null" + (this.properties.size() == 0 ? ");" : ","));
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            this.addLine(4, "\"" + this.properties.get(i).getData().getPropertyName() + "\"" + BeanGen.joinComma(i, this.properties, ");"));
        }
        this.addBlankLine();
    }

    private void generateMetaBuilder() {
        if (!this.data.isConstructable()) {
            this.addLine(2, "@Override");
            this.addLine(2, "public boolean isBuildable() {");
            this.addLine(3, "return false;");
            this.addLine(2, "}");
            this.addBlankLine();
        }
        this.addLine(2, "@Override");
        if (this.data.isImmutable() && !this.data.isEffectiveBuilderScopeVisible()) {
            this.data.ensureImport(BeanBuilder.class);
            this.addLine(2, "public BeanBuilder<? extends " + this.data.getTypeNoExtends() + "> builder() {");
            if (this.data.isConstructable()) {
                this.addLine(3, "return new " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericDiamond() + "();");
            } else {
                this.addLine(3, "throw new UnsupportedOperationException(\"" + this.data.getTypeRaw() + " is an abstract class\");");
            }
        } else if (this.data.isImmutable() || this.data.isMutable() && this.data.isBuilderScopeVisible()) {
            this.addLine(2, "public " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericName(true) + " builder() {");
            if (this.data.isConstructable()) {
                this.addLine(3, "return new " + this.data.getTypeRaw() + ".Builder" + this.data.getTypeGenericDiamond() + "();");
            } else {
                this.addLine(3, "throw new UnsupportedOperationException(\"" + this.data.getTypeRaw() + " is an abstract class\");");
            }
        } else {
            this.data.ensureImport(BeanBuilder.class);
            this.addLine(2, "public BeanBuilder<? extends " + this.data.getTypeNoExtends() + "> builder() {");
            if (this.data.isConstructable()) {
                this.data.ensureImport(DirectBeanBuilder.class);
                this.addLine(3, "return new DirectBeanBuilder<>(new " + this.data.getTypeNoExtends() + "());");
            } else {
                this.addLine(3, "throw new UnsupportedOperationException(\"" + this.data.getTypeRaw() + " is an abstract class\");");
            }
        }
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateMetaBeanType() {
        if (this.data.isTypeGeneric()) {
            this.addLine(2, "@SuppressWarnings({\"unchecked\", \"rawtypes\" })");
        }
        this.addLine(2, "@Override");
        this.addLine(2, "public Class<? extends " + this.data.getTypeNoExtends() + "> beanType() {");
        if (this.data.isTypeGeneric()) {
            this.addLine(3, "return (Class) " + this.data.getTypeRaw() + ".class;");
        } else {
            this.addLine(3, "return " + this.data.getTypeNoExtends() + ".class;");
        }
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateMetaPropertyGet() {
        if (this.properties.size() > 0) {
            this.data.ensureImport(MetaProperty.class);
            this.addLine(2, "@Override");
            this.addLine(2, "protected MetaProperty<?> metaPropertyGet(String propertyName) {");
            this.addLine(3, "switch (propertyName.hashCode()) {");
            for (PropertyGen prop : this.properties) {
                this.addLines(prop.generateMetaPropertyGetCase());
            }
            this.addLine(3, "}");
            this.addLine(3, "return super.metaPropertyGet(propertyName);");
            this.addLine(2, "}");
            this.addBlankLine();
        }
    }

    private void generateMetaPropertyMap() {
        this.data.ensureImport(Map.class);
        this.addLine(2, "@Override");
        this.addLine(2, "public Map<String, MetaProperty<?>> metaPropertyMap() {");
        this.addLine(3, "return " + this.config.getPrefix() + "metaPropertyMap$;");
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateMetaPropertyMethods() {
        if (this.data.isBeanStyleGenerateMetaProperties()) {
            for (PropertyGen prop : this.properties) {
                this.addLines(prop.generateMetaProperty());
            }
        }
    }

    private void generateMetaGetPropertyValue() {
        if (this.properties.size() == 0) {
            return;
        }
        this.data.ensureImport(Bean.class);
        this.addLine(2, "@Override");
        this.addLine(2, "protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {");
        this.addLine(3, "switch (propertyName.hashCode()) {");
        for (PropertyGen prop : this.properties) {
            this.addLines(prop.generatePropertyGetCase());
        }
        this.addLine(3, "}");
        this.addLine(3, "return super.propertyGet(bean, propertyName, quiet);");
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateMetaSetPropertyValue() {
        if (this.properties.size() == 0) {
            return;
        }
        this.data.ensureImport(Bean.class);
        if (this.data.isImmutable()) {
            this.addLine(2, "@Override");
            this.addLine(2, "protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {");
            this.addLine(3, "metaProperty(propertyName);");
            this.addLine(3, "if (quiet) {");
            this.addLine(4, "return;");
            this.addLine(3, "}");
            this.addLine(3, "throw new UnsupportedOperationException(\"Property cannot be written: \" + propertyName);");
            this.addLine(2, "}");
            this.addBlankLine();
            return;
        }
        boolean generics = false;
        for (PropertyData propertyData : this.data.getProperties()) {
            generics |= propertyData.getStyle().isWritable() && (propertyData.isGeneric() && !propertyData.isGenericWildcardParamType() || this.data.isTypeGeneric());
        }
        if (generics) {
            this.addLine(2, "@SuppressWarnings(\"unchecked\")");
        }
        this.addLine(2, "@Override");
        this.addLine(2, "protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {");
        this.addLine(3, "switch (propertyName.hashCode()) {");
        for (PropertyGen propertyGen : this.properties) {
            this.addLines(propertyGen.generatePropertySetCase());
        }
        this.addLine(3, "}");
        this.addLine(3, "super.propertySet(bean, propertyName, newValue, quiet);");
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateMetaValidate() {
        if (!this.data.isValidated() || this.data.isImmutable()) {
            return;
        }
        this.data.ensureImport(Bean.class);
        this.addLine(2, "@Override");
        this.addLine(2, "protected void validate(Bean bean) {");
        if (this.data.isValidated()) {
            for (PropertyGen prop : this.properties) {
                if (!prop.getData().isValidated()) continue;
                this.addLine(3, prop.getData().getValidationMethodName() + "(((" + this.data.getTypeWildcard() + ") bean)." + prop.getData().getFieldName() + ", \"" + prop.getData().getPropertyName() + "\");");
            }
        }
        if (this.data.isSubClass()) {
            this.addLine(3, "super.validate(bean);");
        }
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateBuilderClass() {
        String superBuilder;
        if (this.data.isSkipBuilderGeneration()) {
            return;
        }
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.generateSeparator();
        String finalType = this.data.isTypeFinal() ? "final " : "";
        this.addLine(1, "/**");
        this.addLine(1, " * The bean-builder for {@code " + this.data.getTypeRaw() + "}.");
        if (this.data.isTypeGeneric()) {
            for (int j = 0; j < this.data.getTypeGenericCount(); ++j) {
                this.addLine(1, " * @param " + this.data.getTypeGenericName(j, true) + "  the type");
            }
        }
        this.addLine(1, " */");
        if (this.data.isSubClass()) {
            superBuilder = this.data.getSuperTypeRaw() + ".Builder" + this.data.getSuperTypeGeneric(true);
        } else if (this.data.isEffectiveBuilderScopeVisible()) {
            this.data.ensureImport(DirectFieldsBeanBuilder.class);
            superBuilder = "DirectFieldsBeanBuilder<" + this.data.getTypeNoExtends() + ">";
        } else {
            this.data.ensureImport(DirectPrivateBeanBuilder.class);
            superBuilder = "DirectPrivateBeanBuilder<" + this.data.getTypeNoExtends() + ">";
        }
        if (this.data.isConstructable()) {
            this.addLine(1, this.data.getEffectiveBuilderScope() + "static " + finalType + "class Builder" + this.data.getTypeGeneric(true) + " extends " + superBuilder + " {");
        } else {
            this.addLine(1, this.data.getEffectiveBuilderScope() + "abstract static " + finalType + "class Builder" + this.data.getTypeGeneric(true) + " extends " + superBuilder + " {");
        }
        if (nonDerived.size() > 0) {
            this.addBlankLine();
            this.generateBuilderProperties();
        }
        this.addBlankLine();
        this.generateBuilderConstructorNoArgs();
        this.generateBuilderConstructorCopy();
        this.generateIndentedSeparator();
        this.generateBuilderGet();
        this.generateBuilderSet();
        this.generateBuilderOtherSets();
        if (this.data.isConstructable()) {
            this.generateBuilderBuild();
        }
        this.generateIndentedSeparator();
        this.generateBuilderPropertySetMethods();
        this.generateIndentedSeparator();
        this.generateBuilderToString();
        this.addLine(1, "}");
        this.addBlankLine();
    }

    private void generateBuilderConstructorNoArgs() {
        this.addLine(2, "/**");
        this.addLine(2, " * Restricted constructor.");
        this.addLine(2, " */");
        this.addLine(2, this.data.getNestedClassConstructorScope() + " Builder() {");
        if (this.data.getImmutableDefaults() != null) {
            this.addLine(3, this.data.getImmutableDefaults() + "(this);");
        }
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateBuilderConstructorCopy() {
        List<PropertyGen> nonDerived;
        if (this.data.isBuilderGenerated() && ((nonDerived = this.nonDerivedProperties()).size() > 0 || !this.data.isTypeFinal())) {
            this.addLine(2, "/**");
            this.addLine(2, " * Restricted copy constructor.");
            this.addLine(2, " * @param beanToCopy  the bean to copy from, not null");
            this.addLine(2, " */");
            this.addLine(2, this.data.getNestedClassConstructorScope() + " Builder(" + this.data.getTypeNoExtends() + " beanToCopy) {");
            if (this.data.isSubClass()) {
                this.addLine(3, "super(beanToCopy);");
            }
            for (int i = 0; i < nonDerived.size(); ++i) {
                this.addLines(nonDerived.get(i).generateBuilderConstructorAssign("beanToCopy"));
            }
            this.addLine(2, "}");
            this.addBlankLine();
        }
    }

    private void generateBuilderProperties() {
        for (PropertyGen prop : this.nonDerivedProperties()) {
            this.addLines(prop.generateBuilderField());
        }
    }

    private void generateBuilderGet() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.addLine(2, "@Override");
        this.addLine(2, "public Object get(String propertyName) {");
        if (nonDerived.size() > 0) {
            this.addLine(3, "switch (propertyName.hashCode()) {");
            for (PropertyGen prop : nonDerived) {
                this.addLines(prop.generateBuilderFieldGet());
            }
            this.addLine(4, "default:");
            if (this.data.isRootClass()) {
                this.data.ensureImport(NoSuchElementException.class);
                this.addLine(5, "throw new NoSuchElementException(\"Unknown property: \" + propertyName);");
            } else {
                this.addLine(5, "return super.get(propertyName);");
            }
            this.addLine(3, "}");
        } else {
            this.data.ensureImport(NoSuchElementException.class);
            this.addLine(3, "throw new NoSuchElementException(\"Unknown property: \" + propertyName);");
        }
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateBuilderSet() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        boolean generics = this.data.getProperties().stream().filter(p -> p.isGeneric() && !p.isGenericWildcardParamType()).findAny().isPresent();
        if (generics) {
            this.addLine(2, "@SuppressWarnings(\"unchecked\")");
        }
        this.addLine(2, "@Override");
        this.addLine(2, "public Builder" + this.data.getTypeGenericName(true) + " set(String propertyName, Object newValue) {");
        if (nonDerived.size() > 0) {
            this.addLine(3, "switch (propertyName.hashCode()) {");
            for (PropertyGen prop : nonDerived) {
                this.addLines(prop.generateBuilderFieldSet());
            }
            this.addLine(4, "default:");
            if (this.data.isRootClass()) {
                this.data.ensureImport(NoSuchElementException.class);
                this.addLine(5, "throw new NoSuchElementException(\"Unknown property: \" + propertyName);");
            } else {
                this.addLine(5, "super.set(propertyName, newValue);");
                this.addLine(5, "break;");
            }
            this.addLine(3, "}");
            this.addLine(3, "return this;");
        } else {
            this.data.ensureImport(NoSuchElementException.class);
            this.addLine(3, "throw new NoSuchElementException(\"Unknown property: \" + propertyName);");
        }
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateBuilderOtherSets() {
        if (this.data.isEffectiveBuilderScopeVisible()) {
            this.addLine(2, "@Override");
            this.addLine(2, "public Builder" + this.data.getTypeGenericName(true) + " set(MetaProperty<?> property, Object value) {");
            this.addLine(3, "super.set(property, value);");
            this.addLine(3, "return this;");
            this.addLine(2, "}");
            this.addBlankLine();
        }
    }

    private void generateBuilderBuild() {
        List<PropertyGen> nonDerived = this.nonDerivedProperties();
        this.addLine(2, "@Override");
        this.addLine(2, "public " + this.data.getTypeRaw() + this.data.getTypeGenericName(true) + " build() {");
        if (this.data.getImmutablePreBuild() != null) {
            this.addLine(3, this.data.getImmutablePreBuild() + "(this);");
        }
        if (this.data.getConstructorStyle() == 2) {
            if (nonDerived.size() == 0) {
                this.addLine(3, "return new " + this.data.getTypeWithDiamond() + "();");
            } else {
                this.addLine(3, "return new " + this.data.getTypeWithDiamond() + "(");
                for (int i = 0; i < nonDerived.size(); ++i) {
                    this.addLine(5, nonDerived.get(i).generateBuilderFieldName() + BeanGen.joinComma(i, nonDerived, ");"));
                }
            }
        } else if (this.data.getConstructorStyle() == 1) {
            this.addLine(3, "return new " + this.data.getTypeWithDiamond() + "(this);");
        }
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void generateBuilderPropertySetMethods() {
        if (this.data.isEffectiveBuilderScopeVisible()) {
            for (PropertyGen prop : this.nonDerivedProperties()) {
                this.addLines(prop.generateBuilderSetMethod());
            }
        }
    }

    private void generateBuilderToString() {
        List<PropertyGen> nonDerived = this.toStringProperties();
        if (this.data.isImmutable() && this.data.isTypeFinal()) {
            this.addLine(2, "@Override");
            this.addLine(2, "public String toString() {");
            if (nonDerived.size() == 0) {
                this.addLine(3, "return \"" + this.data.getTypeRaw() + ".Builder{}\";");
            } else {
                this.addLine(3, "StringBuilder buf = new StringBuilder(" + (nonDerived.size() * 32 + 32) + ");");
                this.addLine(3, "buf.append(\"" + this.data.getTypeRaw() + ".Builder{\");");
                for (int i = 0; i < nonDerived.size(); ++i) {
                    PropertyGen prop = nonDerived.get(i);
                    String getter = nonDerived.get(i).generateBuilderFieldName();
                    this.data.ensureImport(JodaBeanUtils.class);
                    String base = "\t\t\tbuf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + "))";
                    this.addLine(0, base + BeanGen.join(i, nonDerived, ".append(',').append(' ');", ";"));
                }
                this.addLine(3, "buf.append('}');");
                this.addLine(3, "return buf.toString();");
            }
            this.addLine(2, "}");
            this.addBlankLine();
            return;
        }
        this.addLine(2, "@Override");
        this.addLine(2, "public String toString() {");
        this.addLine(3, "StringBuilder buf = new StringBuilder(" + (nonDerived.size() * 32 + 32) + ");");
        this.addLine(3, "buf.append(\"" + this.data.getTypeRaw() + ".Builder{\");");
        this.addLine(3, "int len = buf.length();");
        this.addLine(3, "toString(buf);");
        this.addLine(3, "if (buf.length() > len) {");
        this.addLine(4, "buf.setLength(buf.length() - 2);");
        this.addLine(3, "}");
        this.addLine(3, "buf.append('}');");
        this.addLine(3, "return buf.toString();");
        this.addLine(2, "}");
        this.addBlankLine();
        if (this.data.isSubClass()) {
            this.addLine(2, "@Override");
        }
        this.addLine(2, "protected void toString(StringBuilder buf) {");
        if (this.data.isSubClass()) {
            this.addLine(3, "super.toString(buf);");
        }
        for (int i = 0; i < nonDerived.size(); ++i) {
            PropertyGen prop = nonDerived.get(i);
            String getter = nonDerived.get(i).generateBuilderFieldName();
            this.data.ensureImport(JodaBeanUtils.class);
            this.addLine(3, "buf.append(\"" + prop.getData().getPropertyName() + "\").append('=').append(JodaBeanUtils.toString(" + getter + ")).append(',').append(' ');");
        }
        this.addLine(2, "}");
        this.addBlankLine();
    }

    private void addLines(List<String> lines) {
        this.insertRegion.addAll(lines);
    }

    private void addLine(int tabCount, String line) {
        StringBuilder buf = new StringBuilder(line.length() + tabCount);
        for (int i = 0; i < tabCount; ++i) {
            buf.append('\t');
        }
        buf.append(line);
        this.insertRegion.add(buf.toString());
    }

    private void addBlankLine() {
        this.insertRegion.add("");
    }

    private static String join(int i, List<?> list, String join, String end) {
        return i < list.size() - 1 ? join : end;
    }

    private static String joinComma(int i, List<?> list, String end) {
        return BeanGen.join(i, list, ",", end);
    }

    boolean isBean() {
        return this.properties != null;
    }

    BeanData getData() {
        return this.data;
    }

    BeanGenConfig getConfig() {
        return this.config;
    }

    File getFile() {
        return this.file;
    }

    String getFieldPrefix() {
        return this.config.getPrefix();
    }

    private List<PropertyGen> nonDerivedProperties() {
        ArrayList<PropertyGen> nonDerived = new ArrayList<PropertyGen>();
        for (PropertyGen prop : this.properties) {
            if (prop.getData().isDerived()) continue;
            nonDerived.add(prop);
        }
        return nonDerived;
    }

    private List<PropertyGen> nonDerivedEqualsHashCodeProperties() {
        ArrayList<PropertyGen> nonDerived = new ArrayList<PropertyGen>();
        for (PropertyGen prop : this.properties) {
            if (prop.getData().isDerived() || prop.getData().getEqualsHashCodeStyle().equals("omit")) continue;
            nonDerived.add(prop);
        }
        return nonDerived;
    }

    private List<PropertyGen> toStringProperties() {
        ArrayList<PropertyGen> props = new ArrayList<PropertyGen>();
        for (PropertyGen prop : this.properties) {
            if (prop.getData().isDerived() || "omit".equals(prop.getData().getToStringStyle())) continue;
            props.add(prop);
        }
        return props;
    }

    static {
        Class<?> cls1 = null;
        Class<?> cls2 = null;
        try {
            cls1 = Class.forName("java.beans.ConstructorProperties");
            cls2 = Class.forName("java.beans.PropertyChangeSupport");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        CLASS_CONSTRUCTOR_PROPERTIES = cls1;
        CLASS_PROPERTY_CHANGE_SUPPORT = cls2;
        PRIMITIVE_EQUALS = new HashSet<String>();
        PRIMITIVE_EQUALS.add("boolean");
        PRIMITIVE_EQUALS.add("char");
        PRIMITIVE_EQUALS.add("byte");
        PRIMITIVE_EQUALS.add("short");
        PRIMITIVE_EQUALS.add("int");
        PRIMITIVE_EQUALS.add("long");
    }
}

