/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.json;

import java.io.IOException;
import java.io.Reader;
import org.joda.beans.ser.json.JsonEvent;

final class JsonInput {
    private static final String[] REPLACE = new String[128];
    private final Reader input;
    private final StringBuilder buf = new StringBuilder(32);
    private long integral;
    private double floating;
    private Character cachedNext;
    private String cachedObjectKey;

    JsonInput(Reader input) {
        this.input = input;
    }

    JsonEvent readEvent() throws IOException {
        char next = this.readNext();
        while (next == ' ' || next == '\t' || next == '\n' || next == '\r') {
            next = this.readNext();
        }
        switch (next) {
            case '{': {
                return JsonEvent.OBJECT;
            }
            case '}': {
                return JsonEvent.OBJECT_END;
            }
            case '[': {
                return JsonEvent.ARRAY;
            }
            case ']': {
                return JsonEvent.ARRAY_END;
            }
            case '\"': {
                return JsonEvent.STRING;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.acceptNumber(next);
            }
            case 'n': {
                return this.acceptNull();
            }
            case 't': {
                return this.acceptTrue();
            }
            case 'f': {
                return this.acceptFalse();
            }
            case ',': {
                return JsonEvent.COMMA;
            }
            case ':': {
                return JsonEvent.COLON;
            }
        }
        throw new IllegalArgumentException("Invalid JSON data: Expected JSON character but found '" + next + "'");
    }

    void pushBack(char ch) throws IOException {
        this.cachedNext = Character.valueOf(ch);
    }

    void pushBackObjectKey(String objectKey) throws IOException {
        this.cachedObjectKey = objectKey;
    }

    JsonEvent ensureEvent(JsonEvent event, JsonEvent expected) throws IOException {
        if (event != expected) {
            throw new IllegalArgumentException("Invalid JSON data: Expected " + (Object)((Object)expected) + " but found " + (Object)((Object)event));
        }
        return event;
    }

    JsonEvent acceptEvent(JsonEvent expected) throws IOException {
        return this.ensureEvent(this.readEvent(), expected);
    }

    String acceptObjectKey(JsonEvent event) throws IOException {
        this.ensureEvent(event, JsonEvent.STRING);
        return this.parseObjectKey();
    }

    String parseObjectKey() throws IOException {
        if (this.cachedObjectKey != null) {
            String key = this.cachedObjectKey;
            this.cachedObjectKey = null;
            return key;
        }
        String str = this.parseString();
        this.acceptEvent(JsonEvent.COLON);
        return str;
    }

    String acceptString() throws IOException {
        this.acceptEvent(JsonEvent.STRING);
        return this.parseString();
    }

    String parseString() throws IOException {
        this.buf.setLength(0);
        char next = this.readNext();
        while (next != '\"') {
            if (next == '\\') {
                this.parseEscape();
            } else {
                this.buf.append(next);
            }
            next = this.readNext();
        }
        return this.buf.toString();
    }

    private void parseEscape() throws IOException {
        char next = this.readNext();
        switch (next) {
            case '\"': {
                this.buf.append('\"');
                return;
            }
            case '/': {
                this.buf.append('/');
                return;
            }
            case '\\': {
                this.buf.append('\\');
                return;
            }
            case 'b': {
                this.buf.append('\b');
                return;
            }
            case 'f': {
                this.buf.append('\f');
                return;
            }
            case 'n': {
                this.buf.append('\n');
                return;
            }
            case 'r': {
                this.buf.append('\r');
                return;
            }
            case 't': {
                this.buf.append('\t');
                return;
            }
            case 'u': {
                int total = 0;
                for (int i = 0; i < 4; ++i) {
                    total = total * 16 + this.acceptHex();
                }
                this.buf.append((char)total);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid JSON data: Expected valid escape sequence but found '\\" + next + "'");
    }

    private int acceptHex() throws IOException {
        char next = this.readNext();
        if (next >= '0' && next <= '9') {
            return next - 48;
        }
        if (next >= 'a' && next <= 'f') {
            return next - 97 + 10;
        }
        if (next >= 'A' && next <= 'F') {
            return next - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid JSON data: Expected hex but found '" + next + "'");
    }

    long parseNumberIntegral() {
        return this.integral;
    }

    double parseNumberFloating() {
        return this.floating;
    }

    private JsonEvent acceptNumber(char first) throws IOException {
        this.buf.setLength(0);
        this.buf.append(first);
        char last = first;
        char next = this.readNext();
        while (next >= '0' && next <= '9' || next == '.' || next == '-' || next == '+' || next == 'e' || next == 'E') {
            this.buf.append(next);
            last = next;
            next = this.readNext();
        }
        this.pushBack(next);
        if (last < '0' || last > '9') {
            throw new IllegalArgumentException("Invalid JSON data: Expected number but found invalid last char '" + last + "'");
        }
        String str = this.buf.toString();
        if (str.equals("0")) {
            this.integral = 0L;
            return JsonEvent.NUMBER_INTEGRAL;
        }
        if (str.startsWith("0") && str.charAt(1) != '.') {
            throw new IllegalArgumentException("Invalid JSON data: Expected number but found zero at start");
        }
        if (str.contains(".") || str.contains("e") || str.contains("E")) {
            this.floating = Double.parseDouble(str);
            return JsonEvent.NUMBER_FLOATING;
        }
        this.integral = Long.parseLong(str);
        return JsonEvent.NUMBER_INTEGRAL;
    }

    private JsonEvent acceptNull() throws IOException {
        this.acceptChar('u');
        this.acceptChar('l');
        this.acceptChar('l');
        return JsonEvent.NULL;
    }

    private JsonEvent acceptTrue() throws IOException {
        this.acceptChar('r');
        this.acceptChar('u');
        this.acceptChar('e');
        return JsonEvent.TRUE;
    }

    private JsonEvent acceptFalse() throws IOException {
        this.acceptChar('a');
        this.acceptChar('l');
        this.acceptChar('s');
        this.acceptChar('e');
        return JsonEvent.FALSE;
    }

    private void acceptChar(char ch) throws IOException {
        char next = this.readNext();
        if (next != ch) {
            throw new IllegalArgumentException("Invalid JSON data: Expected '" + ch + "' but found '" + next + "'");
        }
    }

    private char readNext() throws IOException {
        if (this.cachedNext != null) {
            char next = this.cachedNext.charValue();
            this.cachedNext = null;
            return next;
        }
        int next = this.input.read();
        if (next == -1) {
            throw new IllegalArgumentException("Invalid JSON data: End of file");
        }
        return (char)next;
    }

    void skipData() throws IOException {
        this.skipData(this.readEvent());
    }

    private void skipData(JsonEvent event) throws IOException {
        switch (event) {
            case OBJECT: {
                event = this.readEvent();
                while (event != JsonEvent.OBJECT_END) {
                    this.acceptObjectKey(event);
                    this.skipData();
                    event = this.acceptObjectSeparator();
                }
                break;
            }
            case ARRAY: {
                event = this.readEvent();
                while (event != JsonEvent.ARRAY_END) {
                    this.skipData(event);
                    event = this.acceptArraySeparator();
                }
                break;
            }
            case STRING: {
                this.parseString();
                break;
            }
            case NULL: 
            case TRUE: 
            case FALSE: 
            case NUMBER_FLOATING: 
            case NUMBER_INTEGRAL: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid JSON data: Expected data item but found " + (Object)((Object)event));
            }
        }
    }

    JsonEvent acceptObjectSeparator() throws IOException {
        JsonEvent event = this.readEvent();
        if (event == JsonEvent.COMMA) {
            return this.readEvent();
        }
        return this.ensureEvent(event, JsonEvent.OBJECT_END);
    }

    JsonEvent acceptArraySeparator() throws IOException {
        JsonEvent event = this.readEvent();
        if (event == JsonEvent.COMMA) {
            return this.readEvent();
        }
        return this.ensureEvent(event, JsonEvent.ARRAY_END);
    }

    static {
        for (int i = 0; i < 32; ++i) {
            JsonInput.REPLACE[i] = String.format("\\u%04x", i);
        }
        JsonInput.REPLACE[8] = "\\b";
        JsonInput.REPLACE[9] = "\\t";
        JsonInput.REPLACE[10] = "\\n";
        JsonInput.REPLACE[12] = "\\f";
        JsonInput.REPLACE[13] = "\\r";
        JsonInput.REPLACE[34] = "\\\"";
        JsonInput.REPLACE[92] = "\\\\";
        JsonInput.REPLACE[127] = "\\u007f";
    }
}

