/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicMetaProperty;

final class ReflectiveMetaProperty<P>
extends BasicMetaProperty<P> {
    private volatile MetaBean metaBean;
    private final Class<?> declaringType;
    private final Class<P> propertyType;
    private final Method getMethod;
    private final Method setMethod;

    ReflectiveMetaProperty(MetaBean metaBean, Class<? extends Bean> beanType, String propertyName) {
        super(propertyName);
        String setterName;
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        String isserName = "is" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getMethod = ReflectiveMetaProperty.findGetMethod(beanType, getterName);
        Method isMethod = ReflectiveMetaProperty.findGetMethod(beanType, isserName);
        if (getMethod == null && isMethod == null) {
            throw new IllegalArgumentException("Unable to find property getter: " + beanType.getSimpleName() + "." + getterName + "()");
        }
        getMethod = isMethod != null ? isMethod : getMethod;
        Method setMethod = null;
        if (!ImmutableBean.class.isAssignableFrom(beanType) && (setMethod = ReflectiveMetaProperty.findSetMethod(beanType, setterName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1), getMethod.getReturnType())) == null) {
            throw new IllegalArgumentException("Unable to find property setter: " + beanType.getSimpleName() + "." + setterName + "()");
        }
        this.metaBean = metaBean;
        this.declaringType = getMethod != null ? getMethod.getDeclaringClass() : setMethod.getDeclaringClass();
        this.propertyType = getMethod.getReturnType();
        this.getMethod = getMethod;
        this.setMethod = setMethod;
    }

    private static Method findGetMethod(Class<? extends Bean> beanType, String getterName) {
        try {
            return beanType.getDeclaredMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                return beanType.getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
    }

    private static Method findSetMethod(Class<? extends Bean> beanType, String setterName, Class<?> fieldType) {
        try {
            return beanType.getDeclaredMethod(setterName, fieldType);
        }
        catch (NoSuchMethodException ex) {
            Method[] methods = beanType.getMethods();
            ArrayList<Method> potential = new ArrayList<Method>();
            for (Method method : methods) {
                if (!method.getName().equals(setterName) || method.getParameterTypes().length != 1) continue;
                potential.add(method);
            }
            if (potential.size() == 1) {
                return (Method)potential.get(0);
            }
            for (Method method : potential) {
                if (!method.getParameterTypes()[0].equals(fieldType)) continue;
                return method;
            }
            return null;
        }
    }

    void setMetaBean(MetaBean metaBean) {
        this.metaBean = metaBean;
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    @Override
    public Class<?> declaringType() {
        return this.declaringType;
    }

    @Override
    public Class<P> propertyType() {
        return this.propertyType;
    }

    @Override
    public Type propertyGenericType() {
        if (this.getMethod != null) {
            return this.getMethod.getGenericReturnType();
        }
        return this.setMethod.getGenericParameterTypes()[0];
    }

    @Override
    public PropertyStyle style() {
        return this.getMethod == null ? PropertyStyle.WRITE_ONLY : (this.setMethod == null ? PropertyStyle.READ_ONLY : PropertyStyle.READ_WRITE);
    }

    @Override
    public List<Annotation> annotations() {
        if (this.getMethod != null) {
            return Arrays.asList(this.getMethod.getDeclaredAnnotations());
        }
        return Arrays.asList(this.setMethod.getDeclaredAnnotations());
    }

    @Override
    public P get(Bean bean) {
        if (!this.style().isReadable()) {
            throw new UnsupportedOperationException("Property cannot be read: " + this.name());
        }
        try {
            return (P)this.getMethod.invoke((Object)bean, (Object[])null);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + this.name(), ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void set(Bean bean, Object value) {
        if (!this.style().isWritable()) {
            throw new UnsupportedOperationException("Property cannot be written: " + this.name());
        }
        try {
            this.setMethod.invoke((Object)bean, value);
        }
        catch (IllegalArgumentException ex) {
            if (value == null && this.setMethod.getParameterTypes()[0].isPrimitive()) {
                throw new NullPointerException("Property cannot be written: " + this.name() + ": Cannot store null in primitive");
            }
            if (!this.propertyType.isInstance(value)) {
                throw new ClassCastException("Property cannot be written: " + this.name() + ": Invalid type: " + value.getClass().getName());
            }
            throw new UnsupportedOperationException("Property cannot be written: " + this.name(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Property cannot be written: " + this.name(), ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
    }
}

