/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.convert.AnnotationStringConverterFactory;
import org.joda.convert.EnumStringConverterFactory;
import org.joda.convert.FromStringConverter;
import org.joda.convert.JDKStringConverter;
import org.joda.convert.MethodConstructorStringConverter;
import org.joda.convert.MethodsStringConverter;
import org.joda.convert.RenameHandler;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.ToStringConverter;
import org.joda.convert.TypedAdapter;
import org.joda.convert.TypedStringConverter;
import org.joda.convert.factory.BooleanArrayStringConverterFactory;
import org.joda.convert.factory.BooleanObjectArrayStringConverterFactory;
import org.joda.convert.factory.ByteObjectArrayStringConverterFactory;
import org.joda.convert.factory.CharObjectArrayStringConverterFactory;
import org.joda.convert.factory.NumericArrayStringConverterFactory;
import org.joda.convert.factory.NumericObjectArrayStringConverterFactory;

public final class StringConvert {
    public static final StringConvert INSTANCE = new StringConvert();
    private static final TypedStringConverter<?> CACHED_NULL = new TypedStringConverter<Object>(){

        @Override
        public String convertToString(Object object) {
            return null;
        }

        @Override
        public Object convertFromString(Class<? extends Object> cls, String str) {
            return null;
        }

        @Override
        public Class<?> getEffectiveType() {
            return null;
        }
    };
    private final CopyOnWriteArrayList<StringConverterFactory> factories = new CopyOnWriteArrayList();
    private final ConcurrentMap<Class<?>, TypedStringConverter<?>> registered = new ConcurrentHashMap();

    public static StringConvert create() {
        return new StringConvert(true, NumericArrayStringConverterFactory.INSTANCE, NumericObjectArrayStringConverterFactory.INSTANCE, CharObjectArrayStringConverterFactory.INSTANCE, ByteObjectArrayStringConverterFactory.INSTANCE, BooleanArrayStringConverterFactory.INSTANCE, BooleanObjectArrayStringConverterFactory.INSTANCE);
    }

    public StringConvert() {
        this(true, new StringConverterFactory[0]);
    }

    public StringConvert(boolean includeJdkConverters, StringConverterFactory ... factories) {
        if (factories == null) {
            throw new IllegalArgumentException("StringConverterFactory array must not be null");
        }
        for (int i = 0; i < factories.length; ++i) {
            if (factories[i] != null) continue;
            throw new IllegalArgumentException("StringConverterFactory array must not contain a null element");
        }
        if (includeJdkConverters) {
            for (JDKStringConverter conv : JDKStringConverter.values()) {
                this.registered.put(conv.getType(), conv);
            }
            this.registered.put(Boolean.TYPE, JDKStringConverter.BOOLEAN);
            this.registered.put(Byte.TYPE, JDKStringConverter.BYTE);
            this.registered.put(Short.TYPE, JDKStringConverter.SHORT);
            this.registered.put(Integer.TYPE, JDKStringConverter.INTEGER);
            this.registered.put(Long.TYPE, JDKStringConverter.LONG);
            this.registered.put(Float.TYPE, JDKStringConverter.FLOAT);
            this.registered.put(Double.TYPE, JDKStringConverter.DOUBLE);
            this.registered.put(Character.TYPE, JDKStringConverter.CHARACTER);
            this.tryRegisterGuava();
            this.tryRegisterJava8Optionals();
            this.tryRegister("java.time.Instant", "parse");
            this.tryRegister("java.time.Duration", "parse");
            this.tryRegister("java.time.LocalDate", "parse");
            this.tryRegister("java.time.LocalTime", "parse");
            this.tryRegister("java.time.LocalDateTime", "parse");
            this.tryRegister("java.time.OffsetTime", "parse");
            this.tryRegister("java.time.OffsetDateTime", "parse");
            this.tryRegister("java.time.ZonedDateTime", "parse");
            this.tryRegister("java.time.Year", "parse");
            this.tryRegister("java.time.YearMonth", "parse");
            this.tryRegister("java.time.MonthDay", "parse");
            this.tryRegister("java.time.Period", "parse");
            this.tryRegister("java.time.ZoneOffset", "of");
            this.tryRegister("java.time.ZoneId", "of");
            this.tryRegister("org.threeten.bp.Instant", "parse");
            this.tryRegister("org.threeten.bp.Duration", "parse");
            this.tryRegister("org.threeten.bp.LocalDate", "parse");
            this.tryRegister("org.threeten.bp.LocalTime", "parse");
            this.tryRegister("org.threeten.bp.LocalDateTime", "parse");
            this.tryRegister("org.threeten.bp.OffsetTime", "parse");
            this.tryRegister("org.threeten.bp.OffsetDateTime", "parse");
            this.tryRegister("org.threeten.bp.ZonedDateTime", "parse");
            this.tryRegister("org.threeten.bp.Year", "parse");
            this.tryRegister("org.threeten.bp.YearMonth", "parse");
            this.tryRegister("org.threeten.bp.MonthDay", "parse");
            this.tryRegister("org.threeten.bp.Period", "parse");
            this.tryRegister("org.threeten.bp.ZoneOffset", "of");
            this.tryRegister("org.threeten.bp.ZoneId", "of");
            this.tryRegister("javax.time.Instant", "parse");
            this.tryRegister("javax.time.Duration", "parse");
            this.tryRegister("javax.time.calendar.LocalDate", "parse");
            this.tryRegister("javax.time.calendar.LocalTime", "parse");
            this.tryRegister("javax.time.calendar.LocalDateTime", "parse");
            this.tryRegister("javax.time.calendar.OffsetDate", "parse");
            this.tryRegister("javax.time.calendar.OffsetTime", "parse");
            this.tryRegister("javax.time.calendar.OffsetDateTime", "parse");
            this.tryRegister("javax.time.calendar.ZonedDateTime", "parse");
            this.tryRegister("javax.time.calendar.Year", "parse");
            this.tryRegister("javax.time.calendar.YearMonth", "parse");
            this.tryRegister("javax.time.calendar.MonthDay", "parse");
            this.tryRegister("javax.time.calendar.Period", "parse");
            this.tryRegister("javax.time.calendar.ZoneOffset", "of");
            this.tryRegister("javax.time.calendar.ZoneId", "of");
            this.tryRegister("javax.time.calendar.TimeZone", "of");
        }
        if (factories.length > 0) {
            this.factories.addAll(Arrays.asList(factories));
        }
        this.factories.add(AnnotationStringConverterFactory.INSTANCE);
        if (includeJdkConverters) {
            this.factories.add(EnumStringConverterFactory.INSTANCE);
        }
    }

    private void tryRegisterGuava() {
        try {
            RenameHandler.INSTANCE.loadType("com.google.common.reflect.Types");
            Class<?> cls = RenameHandler.INSTANCE.loadType("org.joda.convert.TypeTokenStringConverter");
            TypedStringConverter conv = (TypedStringConverter)cls.newInstance();
            this.registered.put(conv.getEffectiveType(), conv);
            Class<?> cls2 = RenameHandler.INSTANCE.loadType("org.joda.convert.TypeStringConverter");
            TypedStringConverter conv2 = (TypedStringConverter)cls2.newInstance();
            this.registered.put(conv2.getEffectiveType(), conv2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void tryRegisterJava8Optionals() {
        try {
            RenameHandler.INSTANCE.loadType("java.util.OptionalInt");
            Class<?> cls1 = RenameHandler.INSTANCE.loadType("org.joda.convert.OptionalIntStringConverter");
            TypedStringConverter conv1 = (TypedStringConverter)cls1.newInstance();
            this.registered.put(conv1.getEffectiveType(), conv1);
            Class<?> cls2 = RenameHandler.INSTANCE.loadType("org.joda.convert.OptionalLongStringConverter");
            TypedStringConverter conv2 = (TypedStringConverter)cls2.newInstance();
            this.registered.put(conv2.getEffectiveType(), conv2);
            Class<?> cls3 = RenameHandler.INSTANCE.loadType("org.joda.convert.OptionalDoubleStringConverter");
            TypedStringConverter conv3 = (TypedStringConverter)cls3.newInstance();
            this.registered.put(conv3.getEffectiveType(), conv3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void tryRegister(String className, String fromStringMethodName) {
        try {
            Class<?> cls = RenameHandler.INSTANCE.lookupType(className);
            this.registerMethods(cls, "toString", fromStringMethodName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        StringConverter<Object> conv = this.findConverterNoGenerics(cls);
        return conv.convertToString(object);
    }

    public String convertToString(Class<?> cls, Object object) {
        if (object == null) {
            return null;
        }
        StringConverter<Object> conv = this.findConverterNoGenerics(cls);
        return conv.convertToString(object);
    }

    public <T> T convertFromString(Class<T> cls, String str) {
        if (str == null) {
            return null;
        }
        StringConverter<T> conv = this.findConverter(cls);
        return conv.convertFromString(cls, str);
    }

    public boolean isConvertible(Class<?> cls) {
        try {
            return cls != null && this.findConverterQuiet(cls) != null;
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    public <T> StringConverter<T> findConverter(Class<T> cls) {
        return this.findTypedConverter(cls);
    }

    public StringConverter<Object> findConverterNoGenerics(Class<?> cls) {
        return this.findTypedConverterNoGenerics(cls);
    }

    public <T> TypedStringConverter<T> findTypedConverter(Class<T> cls) {
        TypedStringConverter<T> conv = this.findConverterQuiet(cls);
        if (conv == null) {
            throw new IllegalStateException("No registered converter found: " + cls);
        }
        return conv;
    }

    public TypedStringConverter<Object> findTypedConverterNoGenerics(Class<?> cls) {
        TypedStringConverter<Object> conv = this.findConverterQuiet(cls);
        if (conv == null) {
            throw new IllegalStateException("No registered converter found: " + cls);
        }
        return conv;
    }

    private <T> TypedStringConverter<T> findConverterQuiet(Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        TypedStringConverter<T> conv = (TypedStringConverter<T>)this.registered.get(cls);
        if (conv == CACHED_NULL) {
            return null;
        }
        if (conv == null) {
            try {
                conv = this.findAnyConverter(cls);
            }
            catch (RuntimeException ex) {
                this.registered.putIfAbsent(cls, CACHED_NULL);
                throw ex;
            }
            if (conv == null) {
                this.registered.putIfAbsent(cls, CACHED_NULL);
                return null;
            }
            this.registered.putIfAbsent(cls, conv);
        }
        return conv;
    }

    private <T> TypedStringConverter<T> findAnyConverter(Class<T> cls) {
        for (StringConverterFactory factory : this.factories) {
            StringConverter<?> factoryConv = factory.findConverter(cls);
            if (factoryConv == null) continue;
            return TypedAdapter.adapt(cls, factoryConv);
        }
        return null;
    }

    public void registerFactory(StringConverterFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        this.factories.add(0, factory);
    }

    public <T> void register(Class<T> cls, StringConverter<T> converter) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("StringConverter must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        this.registered.put(cls, TypedAdapter.adapt(cls, converter));
    }

    public <T> void register(final Class<T> cls, final ToStringConverter<T> toString, final FromStringConverter<T> fromString) {
        if (fromString == null || toString == null) {
            throw new IllegalArgumentException("Converters must not be null");
        }
        this.register(cls, new TypedStringConverter<T>(){

            @Override
            public String convertToString(T object) {
                return toString.convertToString(object);
            }

            @Override
            public T convertFromString(Class<? extends T> cls2, String str) {
                return fromString.convertFromString(cls2, str);
            }

            @Override
            public Class<?> getEffectiveType() {
                return cls;
            }
        });
    }

    public <T> void registerMethods(Class<T> cls, String toStringMethodName, String fromStringMethodName) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (toStringMethodName == null || fromStringMethodName == null) {
            throw new IllegalArgumentException("Method names must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method toString = this.findToStringMethod(cls, toStringMethodName);
        Method fromString = this.findFromStringMethod(cls, fromStringMethodName);
        MethodsStringConverter<T> converter = new MethodsStringConverter<T>(cls, toString, fromString, cls);
        this.registered.putIfAbsent(cls, converter);
    }

    public <T> void registerMethodConstructor(Class<T> cls, String toStringMethodName) {
        if (cls == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (toStringMethodName == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        if (this == INSTANCE) {
            throw new IllegalStateException("Global singleton cannot be extended");
        }
        Method toString = this.findToStringMethod(cls, toStringMethodName);
        Constructor<T> fromString = this.findFromStringConstructorByType(cls);
        MethodConstructorStringConverter<T> converter = new MethodConstructorStringConverter<T>(cls, toString, fromString);
        this.registered.putIfAbsent(cls, converter);
    }

    private Method findToStringMethod(Class<?> cls, String methodName) {
        Method m;
        try {
            m = cls.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Method must not be static: " + methodName);
        }
        return m;
    }

    private Method findFromStringMethod(Class<?> cls, String methodName) {
        Method m;
        try {
            m = cls.getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = cls.getMethod(methodName, CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Method not found", ex2);
            }
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException("Method must be static: " + methodName);
        }
        return m;
    }

    private <T> Constructor<T> findFromStringConstructorByType(Class<T> cls) {
        try {
            return cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                return cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Constructor not found", ex2);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

