/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.joda.convert.RenameHandler;
import org.joda.convert.TypedStringConverter;

enum JDKStringConverter implements TypedStringConverter<Object>
{
    STRING(String.class, str -> str),
    CHAR_SEQUENCE(CharSequence.class, str -> str),
    STRING_BUFFER(StringBuffer.class, StringBuffer::new),
    STRING_BUILDER(StringBuilder.class, StringBuilder::new),
    LONG(Long.class, Long::valueOf),
    INTEGER(Integer.class, Integer::valueOf),
    SHORT(Short.class, Short::valueOf),
    BYTE(Byte.class, Byte::valueOf),
    BYTE_ARRAY(byte[].class, JDKStringConverter::printBase64Binary, JDKStringConverter::parseBase64Binary),
    CHARACTER(Character.class, JDKStringConverter::parseCharacter),
    CHAR_ARRAY(char[].class, JDKStringConverter::printCharArray, String::toCharArray),
    BOOLEAN(Boolean.class, JDKStringConverter::parseBoolean),
    DOUBLE(Double.class, Double::valueOf),
    FLOAT(Float.class, Float::valueOf),
    BIG_INTEGER(BigInteger.class, BigInteger::new),
    BIG_DECIMAL(BigDecimal.class, BigDecimal::new),
    ATOMIC_LONG(AtomicLong.class, str -> new AtomicLong(Long.parseLong(str))),
    ATOMIC_INTEGER(AtomicInteger.class, str -> new AtomicInteger(Integer.parseInt(str))),
    ATOMIC_BOOLEAN(AtomicBoolean.class, JDKStringConverter::parseAtomicBoolean),
    LOCALE(Locale.class, JDKStringConverter::parseLocale),
    CLASS(Class.class, JDKStringConverter::printClass, JDKStringConverter::parseClass),
    PACKAGE(Package.class, JDKStringConverter::printPackage, JDKStringConverter::parsePackage),
    CURRENCY(Currency.class, Currency::getInstance),
    TIME_ZONE(TimeZone.class, JDKStringConverter::printTimeZone, TimeZone::getTimeZone),
    UUID(UUID.class, UUID::fromString),
    URL(URL.class, JDKStringConverter::printURL, JDKStringConverter::parseURL),
    URI(URI.class, URI::create),
    INET_ADDRESS(InetAddress.class, JDKStringConverter::printInetAddress, JDKStringConverter::parseInetAddress),
    FILE(File.class, File::new),
    DATE(Date.class, JDKStringConverter::printDate, JDKStringConverter::parseDate),
    CALENDAR(Calendar.class, JDKStringConverter::printCalendar, JDKStringConverter::parseCalendar),
    INSTANT(Instant.class, Instant::parse),
    DURATION(Duration.class, Duration::parse),
    LOCAL_DATE(LocalDate.class, LocalDate::parse),
    LOCAL_TIME(LocalTime.class, LocalTime::parse),
    LOCAL_DATE_TIME(LocalDateTime.class, LocalDateTime::parse),
    OFFSET_TIME(OffsetTime.class, OffsetTime::parse),
    OFFSET_DATE_TIME(OffsetDateTime.class, OffsetDateTime::parse),
    ZONED_DATE_TIME(ZonedDateTime.class, ZonedDateTime::parse),
    YEAR(Year.class, Year::parse),
    YEAR_MONTH(YearMonth.class, YearMonth::parse),
    MONTH_DAY(MonthDay.class, MonthDay::parse),
    PERIOD(Period.class, Period::parse),
    ZONE_OFFSET(ZoneOffset.class, ZoneOffset::of),
    ZONE_ID(ZoneId.class, ZoneId::of),
    OPTIONAL_INT(OptionalInt.class, JDKStringConverter::printOptionalInt, JDKStringConverter::parseOptionalInt),
    OPTIONAL_LONG(OptionalLong.class, JDKStringConverter::printOptionalLong, JDKStringConverter::parseOptionalLong),
    OPTIONAL_DOUBLE(OptionalDouble.class, JDKStringConverter::printOptionalDouble, JDKStringConverter::parseOptionalDouble);

    private Class<?> type;
    private Function<Object, String> toStringFn;
    private Function<String, Object> fromStringFn;
    private static String base64Str;
    private static char[] base64Array;
    private static final int MASK_8BIT = 255;
    private static final int MASK_6BIT = 63;

    private JDKStringConverter(Class<?> type, Function<String, Object> fromStringFn) {
        this.type = type;
        this.toStringFn = Object::toString;
        this.fromStringFn = fromStringFn;
    }

    private JDKStringConverter(Class<?> type, Function<Object, String> toStringFn, Function<String, Object> fromStringFn) {
        this.type = type;
        this.toStringFn = toStringFn;
        this.fromStringFn = fromStringFn;
    }

    @Override
    public Class<?> getEffectiveType() {
        return this.type;
    }

    @Override
    public String convertToString(Object object) {
        return this.toStringFn.apply(object);
    }

    @Override
    public Object convertFromString(Class<? extends Object> cls, String str) {
        return this.fromStringFn.apply(str);
    }

    private static String printBase64Binary(Object obj) {
        byte[] array = (byte[])obj;
        int len = array.length;
        char[] buf = new char[(len + 2) / 3 * 4];
        int pos = 0;
        for (int i = 0; i < len; i += 3) {
            int bits;
            int remaining = len - i;
            if (remaining >= 3) {
                bits = (array[i] & 0xFF) << 16 | (array[i + 1] & 0xFF) << 8 | array[i + 2] & 0xFF;
                buf[pos++] = base64Array[bits >>> 18 & 0x3F];
                buf[pos++] = base64Array[bits >>> 12 & 0x3F];
                buf[pos++] = base64Array[bits >>> 6 & 0x3F];
                buf[pos++] = base64Array[bits & 0x3F];
                continue;
            }
            if (remaining == 2) {
                bits = (array[i] & 0xFF) << 16 | (array[i + 1] & 0xFF) << 8;
                buf[pos++] = base64Array[bits >>> 18 & 0x3F];
                buf[pos++] = base64Array[bits >>> 12 & 0x3F];
                buf[pos++] = base64Array[bits >>> 6 & 0x3F];
                buf[pos++] = 61;
                continue;
            }
            bits = (array[i] & 0xFF) << 16;
            buf[pos++] = base64Array[bits >>> 18 & 0x3F];
            buf[pos++] = base64Array[bits >>> 12 & 0x3F];
            buf[pos++] = 61;
            buf[pos++] = 61;
        }
        return new String(buf);
    }

    private static byte[] parseBase64Binary(String str) {
        if (str.length() % 4 != 0) {
            throw new IllegalArgumentException("Invalid Base64 string");
        }
        int parsedLen = str.length() * 3 / 4;
        byte[] decoded = new byte[parsedLen];
        char[] inChars = str.toCharArray();
        int pos = 0;
        int i = 0;
        while (i < inChars.length) {
            int bits = (base64Str.indexOf(inChars[i++]) & 0x3F) << 18 | (base64Str.indexOf(inChars[i++]) & 0x3F) << 12 | (base64Str.indexOf(inChars[i++]) & 0x3F) << 6 | base64Str.indexOf(inChars[i++]) & 0x3F;
            decoded[pos++] = (byte)(bits >>> 16 & 0xFF);
            decoded[pos++] = (byte)(bits >>> 8 & 0xFF);
            decoded[pos++] = (byte)(bits & 0xFF);
        }
        if (str.endsWith("==")) {
            byte[] result = new byte[parsedLen - 2];
            System.arraycopy(decoded, 0, result, 0, parsedLen - 2);
            return result;
        }
        if (str.endsWith("=")) {
            byte[] result = new byte[parsedLen - 1];
            System.arraycopy(decoded, 0, result, 0, parsedLen - 1);
            return result;
        }
        return decoded;
    }

    private static Character parseCharacter(String str) {
        if (str.length() != 1) {
            throw new IllegalArgumentException("Character value must be a string length 1");
        }
        return Character.valueOf(str.charAt(0));
    }

    private static String printCharArray(Object obj) {
        return new String((char[])obj);
    }

    private static Boolean parseBoolean(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
    }

    private static AtomicBoolean parseAtomicBoolean(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return new AtomicBoolean(true);
        }
        if ("false".equalsIgnoreCase(str)) {
            return new AtomicBoolean(false);
        }
        throw new IllegalArgumentException("Boolean value must be 'true' or 'false', case insensitive");
    }

    private static Locale parseLocale(String str) {
        String[] split = str.split("_", 3);
        switch (split.length) {
            case 1: {
                return Locale.of(split[0]);
            }
            case 2: {
                return Locale.of(split[0], split[1]);
            }
            case 3: {
                return Locale.of(split[0], split[1], split[2]);
            }
        }
        throw new IllegalArgumentException("Unable to parse Locale: " + str);
    }

    private static String printClass(Object obj) {
        return ((Class)obj).getName();
    }

    private static Class<?> parseClass(String str) {
        try {
            return RenameHandler.INSTANCE.lookupType(str);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to create type: " + str, ex);
        }
    }

    private static Package parsePackage(String str) {
        for (ClassLoader loader = JDKStringConverter.class.getClassLoader(); loader != null; loader = loader.getParent()) {
            Package pkg = loader.getDefinedPackage(str);
            if (pkg == null) continue;
            return pkg;
        }
        for (Package pkg : Package.getPackages()) {
            if (!pkg.getName().equals(str)) continue;
            return pkg;
        }
        return null;
    }

    private static String printPackage(Object obj) {
        return ((Package)obj).getName();
    }

    private static String printTimeZone(Object obj) {
        return ((TimeZone)obj).getID();
    }

    private static String printURL(Object url) {
        try {
            return ((URL)url).toURI().toString();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static URL parseURL(String str) {
        try {
            return java.net.URI.create(str).toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static String printInetAddress(Object obj) {
        return ((InetAddress)obj).getHostAddress();
    }

    private static InetAddress parseInetAddress(String str) {
        try {
            return InetAddress.getByName(str);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String printDate(Object obj) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String str = format.format(obj);
        return str.substring(0, 26) + ":" + str.substring(26);
    }

    private static Date parseDate(String str) {
        if (str.length() != 29) {
            throw new IllegalArgumentException("Unable to parse date: " + str);
        }
        String str2 = str.substring(0, 26) + str.substring(27);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        try {
            return format.parse(str2);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String printCalendar(Object obj) {
        if (!(obj instanceof GregorianCalendar)) {
            throw new RuntimeException("Unable to convert calendar as it is not a GregorianCalendar");
        }
        GregorianCalendar cal = (GregorianCalendar)obj;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        format.setCalendar(cal);
        String str = format.format(cal.getTime());
        return str.substring(0, 26) + ":" + str.substring(26) + "[" + cal.getTimeZone().getID() + "]";
    }

    private static Calendar parseCalendar(String str) {
        if (str.length() < 31 || str.charAt(26) != ':' || str.charAt(29) != '[' || str.charAt(str.length() - 1) != ']') {
            throw new IllegalArgumentException("Unable to parse date: " + str);
        }
        TimeZone zone = TimeZone.getTimeZone(str.substring(30, str.length() - 1));
        String str2 = str.substring(0, 26) + str.substring(27, 29);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        GregorianCalendar cal = new GregorianCalendar(zone);
        cal.setTimeInMillis(0L);
        format.setCalendar(cal);
        try {
            format.parseObject(str2);
            return format.getCalendar();
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String printOptionalInt(Object obj) {
        OptionalInt optional = (OptionalInt)obj;
        return optional.isEmpty() ? "" : Integer.toString(optional.getAsInt());
    }

    private static OptionalInt parseOptionalInt(String str) {
        return "".equals(str) ? OptionalInt.empty() : OptionalInt.of(Integer.parseInt(str));
    }

    private static String printOptionalLong(Object obj) {
        OptionalLong optional = (OptionalLong)obj;
        return optional.isEmpty() ? "" : Long.toString(optional.getAsLong());
    }

    private static OptionalLong parseOptionalLong(String str) {
        return "".equals(str) ? OptionalLong.empty() : OptionalLong.of(Long.parseLong(str));
    }

    private static String printOptionalDouble(Object obj) {
        OptionalDouble optional = (OptionalDouble)obj;
        return optional.isEmpty() ? "" : Double.toString(optional.getAsDouble());
    }

    private static OptionalDouble parseOptionalDouble(String str) {
        return "".equals(str) ? OptionalDouble.empty() : OptionalDouble.of(Double.parseDouble(str));
    }

    static {
        base64Str = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        base64Array = base64Str.toCharArray();
    }
}

