/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.joda.money.BigMoney;
import org.joda.money.BigMoneyProvider;
import org.joda.money.Money;
import org.joda.money.format.MoneyFormatException;
import org.joda.money.format.MoneyParseContext;
import org.joda.money.format.MoneyParser;
import org.joda.money.format.MoneyPrintContext;
import org.joda.money.format.MoneyPrinter;
import org.joda.money.format.MultiPrinterParser;

public final class MoneyFormatter
implements Serializable {
    private static final long serialVersionUID = 2385346258L;
    private final Locale locale;
    private final MultiPrinterParser printerParser;

    static void checkNotNull(Object object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
    }

    MoneyFormatter(Locale locale, MoneyPrinter[] printers, MoneyParser[] parsers) {
        assert (locale != null);
        assert (printers != null);
        assert (parsers != null);
        assert (printers.length == parsers.length);
        this.locale = locale;
        this.printerParser = new MultiPrinterParser(printers, parsers);
    }

    private MoneyFormatter(Locale locale, MultiPrinterParser printerParser) {
        assert (locale != null);
        assert (printerParser != null);
        this.locale = locale;
        this.printerParser = printerParser;
    }

    MultiPrinterParser getPrinterParser() {
        return this.printerParser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MoneyFormatter withLocale(Locale locale) {
        MoneyFormatter.checkNotNull(locale, "Locale must not be null");
        return new MoneyFormatter(locale, this.printerParser);
    }

    public boolean isPrinter() {
        return this.printerParser.isPrinter();
    }

    public boolean isParser() {
        return this.printerParser.isParser();
    }

    public String print(BigMoneyProvider moneyProvider) {
        StringBuilder buf = new StringBuilder();
        this.print(buf, moneyProvider);
        return buf.toString();
    }

    public void print(Appendable appendable, BigMoneyProvider moneyProvider) {
        try {
            this.printIO(appendable, moneyProvider);
        }
        catch (IOException ex) {
            throw new MoneyFormatException(ex.getMessage(), ex);
        }
    }

    public void printIO(Appendable appendable, BigMoneyProvider moneyProvider) throws IOException {
        MoneyFormatter.checkNotNull(moneyProvider, "BigMoneyProvider must not be null");
        if (!this.isPrinter()) {
            throw new UnsupportedOperationException("MoneyFomatter has not been configured to be able to print");
        }
        BigMoney money = BigMoney.of(moneyProvider);
        MoneyPrintContext context = new MoneyPrintContext(this.locale);
        this.printerParser.print(context, appendable, money);
    }

    public BigMoney parseBigMoney(CharSequence text) {
        MoneyFormatter.checkNotNull(text, "Text must not be null");
        MoneyParseContext result = this.parse(text, 0);
        if (result.isError() || !result.isFullyParsed() || !result.isComplete()) {
            String str;
            String string = str = text.length() > 64 ? ((Object)text.subSequence(0, 64)).toString() + "..." : ((Object)text).toString();
            if (result.isError()) {
                throw new MoneyFormatException("Text could not be parsed at index " + result.getErrorIndex() + ": " + str);
            }
            if (!result.isFullyParsed()) {
                throw new MoneyFormatException("Unparsed text found at index " + result.getIndex() + ": " + str);
            }
            throw new MoneyFormatException("Parsing did not find both currency and amount: " + str);
        }
        return result.toBigMoney();
    }

    public Money parseMoney(CharSequence text) {
        return this.parseBigMoney(text).toMoney();
    }

    public MoneyParseContext parse(CharSequence text, int startIndex) {
        MoneyFormatter.checkNotNull(text, "Text must not be null");
        if (startIndex < 0 || startIndex > text.length()) {
            throw new StringIndexOutOfBoundsException("Invalid start index: " + startIndex);
        }
        if (!this.isParser()) {
            throw new UnsupportedOperationException("MoneyFomatter has not been configured to be able to parse");
        }
        MoneyParseContext context = new MoneyParseContext(this.locale, text, startIndex);
        this.printerParser.parse(context);
        return context;
    }

    public String toString() {
        return this.printerParser.toString();
    }
}

