/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.math.BigDecimal;
import java.text.ParsePosition;
import java.util.Locale;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;
import org.joda.money.format.MoneyFormatException;
import org.joda.money.format.MoneyFormatter;

public final class MoneyParseContext {
    private Locale locale;
    private CharSequence text;
    private int textIndex;
    private int textErrorIndex = -1;
    private CurrencyUnit currency;
    private BigDecimal amount;

    MoneyParseContext(Locale locale, CharSequence text, int index) {
        this.locale = locale;
        this.text = text;
        this.textIndex = index;
    }

    MoneyParseContext(Locale locale, CharSequence text, int index, int errorIndex, CurrencyUnit currency, BigDecimal amount) {
        this.locale = locale;
        this.text = text;
        this.textIndex = index;
        this.textErrorIndex = errorIndex;
        this.currency = currency;
        this.amount = amount;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        MoneyFormatter.checkNotNull(locale, "Locale must not be null");
        this.locale = locale;
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence text) {
        MoneyFormatter.checkNotNull(text, "Text must not be null");
        this.text = text;
    }

    public int getTextLength() {
        return this.text.length();
    }

    public String getTextSubstring(int start, int end) {
        return ((Object)this.text.subSequence(start, end)).toString();
    }

    public int getIndex() {
        return this.textIndex;
    }

    public void setIndex(int index) {
        this.textIndex = index;
    }

    public int getErrorIndex() {
        return this.textErrorIndex;
    }

    public void setErrorIndex(int index) {
        this.textErrorIndex = index;
    }

    public void setError() {
        this.textErrorIndex = this.textIndex;
    }

    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyUnit currency) {
        this.currency = currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean isError() {
        return this.textErrorIndex >= 0;
    }

    public boolean isFullyParsed() {
        return this.textIndex == this.getTextLength();
    }

    public boolean isComplete() {
        return this.currency != null && this.amount != null;
    }

    MoneyParseContext createChild() {
        return new MoneyParseContext(this.locale, this.text, this.textIndex, this.textErrorIndex, this.currency, this.amount);
    }

    void mergeChild(MoneyParseContext child) {
        this.setLocale(child.getLocale());
        this.setText(child.getText());
        this.setIndex(child.getIndex());
        this.setErrorIndex(child.getErrorIndex());
        this.setCurrency(child.getCurrency());
        this.setAmount(child.getAmount());
    }

    public ParsePosition toParsePosition() {
        ParsePosition pp = new ParsePosition(this.textIndex);
        pp.setErrorIndex(this.textErrorIndex);
        return pp;
    }

    public BigMoney toBigMoney() {
        if (this.currency == null) {
            throw new MoneyFormatException("Cannot convert to BigMoney as no currency found");
        }
        if (this.amount == null) {
            throw new MoneyFormatException("Cannot convert to BigMoney as no amount found");
        }
        return BigMoney.of(this.currency, this.amount);
    }
}

