/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

final class Ser
implements Externalizable {
    static final byte BIG_MONEY = 66;
    static final byte MONEY = 77;
    static final byte CURRENCY_UNIT = 67;
    private byte type;
    private Object object;

    public Ser() {
    }

    Ser(byte type, Object object) {
        this.type = type;
        this.object = object;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        switch (this.type) {
            case 66: {
                BigMoney obj = (BigMoney)this.object;
                this.writeBigMoney(out, obj);
                return;
            }
            case 77: {
                Money obj = (Money)this.object;
                this.writeBigMoney(out, obj.toBigMoney());
                return;
            }
            case 67: {
                CurrencyUnit obj = (CurrencyUnit)this.object;
                this.writeCurrency(out, obj);
                return;
            }
        }
        throw new InvalidClassException("Joda-Money bug: Serialization broken");
    }

    private void writeBigMoney(ObjectOutput out, BigMoney obj) throws IOException {
        this.writeCurrency(out, obj.getCurrencyUnit());
        byte[] bytes = obj.getAmount().unscaledValue().toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
        out.writeInt(obj.getScale());
    }

    private void writeCurrency(ObjectOutput out, CurrencyUnit obj) throws IOException {
        out.writeUTF(obj.getCode());
        out.writeShort(obj.getNumericCode());
        out.writeShort(obj.getDefaultFractionDigits());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        switch (this.type) {
            case 66: {
                this.object = this.readBigMoney(in);
                return;
            }
            case 77: {
                this.object = new Money(this.readBigMoney(in));
                return;
            }
            case 67: {
                this.object = this.readCurrency(in);
                return;
            }
        }
        throw new StreamCorruptedException("Serialization input has invalid type");
    }

    private BigMoney readBigMoney(ObjectInput in) throws IOException {
        CurrencyUnit currency = this.readCurrency(in);
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        BigDecimal bd = new BigDecimal(new BigInteger(bytes), in.readInt());
        BigMoney bigMoney = new BigMoney(currency, bd);
        return bigMoney;
    }

    private CurrencyUnit readCurrency(ObjectInput in) throws IOException {
        String code = in.readUTF();
        CurrencyUnit singletonCurrency = CurrencyUnit.of(code);
        if (singletonCurrency.getNumericCode() != in.readShort()) {
            throw new InvalidObjectException("Deserialization found a mismatch in the numeric code for currency " + code);
        }
        if (singletonCurrency.getDefaultFractionDigits() != in.readShort()) {
            throw new InvalidObjectException("Deserialization found a mismatch in the decimal places for currency " + code);
        }
        return singletonCurrency;
    }

    private Object readResolve() {
        return this.object;
    }
}

