/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.money.CurrencyUnitDataProvider;
import org.joda.money.DefaultCurrencyUnitDataProvider;
import org.joda.money.IllegalCurrencyException;
import org.joda.money.MoneyUtils;
import org.joda.money.Ser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CurrencyUnit
implements Comparable<CurrencyUnit>,
Serializable {
    private static final long serialVersionUID = 327835287287L;
    private static final ConcurrentMap<String, CurrencyUnit> currenciesByCode = new ConcurrentHashMap<String, CurrencyUnit>();
    private static final ConcurrentMap<Integer, CurrencyUnit> currenciesByNumericCode = new ConcurrentHashMap<Integer, CurrencyUnit>();
    private static final ConcurrentMap<String, CurrencyUnit> currenciesByCountry = new ConcurrentHashMap<String, CurrencyUnit>();
    public static final CurrencyUnit USD;
    public static final CurrencyUnit EUR;
    public static final CurrencyUnit JPY;
    public static final CurrencyUnit GBP;
    public static final CurrencyUnit CHF;
    public static final CurrencyUnit AUD;
    public static final CurrencyUnit CAD;
    private final String code;
    private final short numericCode;
    private final short decimalPlaces;

    static synchronized CurrencyUnit registerCurrency(String currencyCode, int numericCurrencyCode, int decimalPlaces, List<String> countryCodes) {
        MoneyUtils.checkNotNull(currencyCode, "Currency code must not be null");
        if (numericCurrencyCode < -1 || numericCurrencyCode > 999) {
            throw new IllegalArgumentException("Invalid numeric code");
        }
        if (decimalPlaces < -1 || decimalPlaces > 3) {
            throw new IllegalArgumentException("Invalid number of decimal places");
        }
        MoneyUtils.checkNotNull(countryCodes, "Country codes must not be null");
        CurrencyUnit currency = new CurrencyUnit(currencyCode, (short)numericCurrencyCode, (short)decimalPlaces);
        if (currenciesByCode.containsKey(currencyCode) || currenciesByNumericCode.containsKey(numericCurrencyCode)) {
            throw new IllegalArgumentException("Currency already registered: " + currencyCode);
        }
        for (String countryCode : countryCodes) {
            if (!currenciesByCountry.containsKey(countryCode)) continue;
            throw new IllegalArgumentException("Currency already registered for country: " + countryCode);
        }
        currenciesByCode.putIfAbsent(currencyCode, currency);
        if (numericCurrencyCode >= 0) {
            currenciesByNumericCode.putIfAbsent(numericCurrencyCode, currency);
        }
        for (String countryCode : countryCodes) {
            currenciesByCountry.put(countryCode, currency);
        }
        return (CurrencyUnit)currenciesByCode.get(currencyCode);
    }

    public static List<CurrencyUnit> registeredCurrencies() {
        ArrayList<CurrencyUnit> list = new ArrayList<CurrencyUnit>(currenciesByCode.values());
        Collections.sort(list);
        return list;
    }

    public static CurrencyUnit of(Currency currency) {
        MoneyUtils.checkNotNull(currency, "Currency must not be null");
        return CurrencyUnit.of(currency.getCurrencyCode());
    }

    @FromString
    public static CurrencyUnit of(String currencyCode) {
        MoneyUtils.checkNotNull(currencyCode, "Currency code must not be null");
        CurrencyUnit currency = (CurrencyUnit)currenciesByCode.get(currencyCode);
        if (currency == null) {
            throw new IllegalCurrencyException("Unknown currency '" + currencyCode + '\'');
        }
        return currency;
    }

    public static CurrencyUnit ofNumericCode(String numericCurrencyCode) {
        MoneyUtils.checkNotNull(numericCurrencyCode, "Currency code must not be null");
        switch (numericCurrencyCode.length()) {
            case 1: {
                return CurrencyUnit.ofNumericCode(numericCurrencyCode.charAt(0) - 48);
            }
            case 2: {
                return CurrencyUnit.ofNumericCode((numericCurrencyCode.charAt(0) - 48) * 10 + numericCurrencyCode.charAt(1) - 48);
            }
            case 3: {
                return CurrencyUnit.ofNumericCode((numericCurrencyCode.charAt(0) - 48) * 100 + (numericCurrencyCode.charAt(1) - 48) * 10 + numericCurrencyCode.charAt(2) - 48);
            }
        }
        throw new IllegalCurrencyException("Unknown currency '" + numericCurrencyCode + '\'');
    }

    public static CurrencyUnit ofNumericCode(int numericCurrencyCode) {
        CurrencyUnit currency = (CurrencyUnit)currenciesByNumericCode.get(numericCurrencyCode);
        if (currency == null) {
            throw new IllegalCurrencyException("Unknown currency '" + numericCurrencyCode + '\'');
        }
        return currency;
    }

    public static CurrencyUnit of(Locale locale) {
        MoneyUtils.checkNotNull(locale, "Locale must not be null");
        CurrencyUnit currency = (CurrencyUnit)currenciesByCountry.get(locale.getCountry());
        if (currency == null) {
            throw new IllegalCurrencyException("Unknown currency for locale '" + locale + '\'');
        }
        return currency;
    }

    public static CurrencyUnit ofCountry(String countryCode) {
        MoneyUtils.checkNotNull(countryCode, "Country code must not be null");
        CurrencyUnit currency = (CurrencyUnit)currenciesByCountry.get(countryCode);
        if (currency == null) {
            throw new IllegalCurrencyException("Unknown currency for country '" + countryCode + '\'');
        }
        return currency;
    }

    public static CurrencyUnit getInstance(String currencyCode) {
        return CurrencyUnit.of(currencyCode);
    }

    public static CurrencyUnit getInstance(Locale locale) {
        return CurrencyUnit.of(locale);
    }

    CurrencyUnit(String code, short numericCurrencyCode, short decimalPlaces) {
        assert (code != null) : "Joda-Money bug: Currency code must not be null";
        this.code = code;
        this.numericCode = numericCurrencyCode;
        this.decimalPlaces = decimalPlaces;
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization delegate required");
    }

    private Object writeReplace() {
        return new Ser(67, this);
    }

    public String getCode() {
        return this.code;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public String getNumeric3Code() {
        if (this.numericCode < 0) {
            return "";
        }
        String str = Integer.toString(this.numericCode);
        if (str.length() == 1) {
            return "00" + str;
        }
        if (str.length() == 2) {
            return "0" + str;
        }
        return str;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces < 0 ? (short)0 : this.decimalPlaces;
    }

    public boolean isPseudoCurrency() {
        return this.decimalPlaces < 0;
    }

    public String getCurrencyCode() {
        return this.code;
    }

    public int getDefaultFractionDigits() {
        return this.decimalPlaces;
    }

    public String getSymbol() {
        try {
            return Currency.getInstance(this.code).getSymbol();
        }
        catch (IllegalArgumentException ex) {
            return this.code;
        }
    }

    public String getSymbol(Locale locale) {
        MoneyUtils.checkNotNull(locale, "Locale must not be null");
        try {
            return Currency.getInstance(this.code).getSymbol(locale);
        }
        catch (IllegalArgumentException ex) {
            return this.code;
        }
    }

    public Currency toCurrency() {
        return Currency.getInstance(this.code);
    }

    @Override
    public int compareTo(CurrencyUnit other) {
        return this.code.compareTo(other.code);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CurrencyUnit) {
            return this.code.equals(((CurrencyUnit)obj).code);
        }
        return false;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    @ToString
    public String toString() {
        return this.code;
    }

    static {
        try {
            try {
                String clsName = System.getProperty("org.joda.money.CurrencyUnitDataProvider", "org.joda.money.DefaultCurrencyUnitDataProvider");
                Class<CurrencyUnitDataProvider> cls = CurrencyUnit.class.getClassLoader().loadClass(clsName).asSubclass(CurrencyUnitDataProvider.class);
                cls.newInstance().registerCurrencies();
            }
            catch (SecurityException ex) {
                new DefaultCurrencyUnitDataProvider().registerCurrencies();
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString(), ex);
        }
        USD = CurrencyUnit.of("USD");
        EUR = CurrencyUnit.of("EUR");
        JPY = CurrencyUnit.of("JPY");
        GBP = CurrencyUnit.of("GBP");
        CHF = CurrencyUnit.of("CHF");
        AUD = CurrencyUnit.of("AUD");
        CAD = CurrencyUnit.of("CAD");
    }
}

