/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.money.format.MoneyFormatter;

public final class MoneyAmountStyle
implements Serializable {
    public static final MoneyAmountStyle ASCII_DECIMAL_POINT_GROUP3_COMMA = new MoneyAmountStyle(48, 43, 45, 46, 44, 3, true, false);
    public static final MoneyAmountStyle ASCII_DECIMAL_POINT_GROUP3_SPACE = new MoneyAmountStyle(48, 43, 45, 46, 32, 3, true, false);
    public static final MoneyAmountStyle ASCII_DECIMAL_POINT_NO_GROUPING = new MoneyAmountStyle(48, 43, 45, 46, 44, 3, false, false);
    public static final MoneyAmountStyle ASCII_DECIMAL_COMMA_GROUP3_DOT = new MoneyAmountStyle(48, 43, 45, 44, 46, 3, true, false);
    public static final MoneyAmountStyle ASCII_DECIMAL_COMMA_GROUP3_SPACE = new MoneyAmountStyle(48, 43, 45, 44, 32, 3, true, false);
    public static final MoneyAmountStyle ASCII_DECIMAL_COMMA_NO_GROUPING = new MoneyAmountStyle(48, 43, 45, 44, 46, 3, false, false);
    public static final MoneyAmountStyle LOCALIZED_GROUPING = new MoneyAmountStyle(-1, -1, -1, -1, -1, -1, true, false);
    public static final MoneyAmountStyle LOCALIZED_NO_GROUPING = new MoneyAmountStyle(-1, -1, -1, -1, -1, -1, false, false);
    private static final ConcurrentMap<Locale, MoneyAmountStyle> LOCALIZED_CACHE = new ConcurrentHashMap<Locale, MoneyAmountStyle>();
    private static final long serialVersionUID = 1L;
    private final int zeroCharacter;
    private final int positiveCharacter;
    private final int negativeCharacter;
    private final int decimalPointCharacter;
    private final int groupingCharacter;
    private final int groupingSize;
    private final boolean grouping;
    private final boolean forceDecimalPoint;

    public static MoneyAmountStyle of(Locale locale) {
        return MoneyAmountStyle.getLocalizedStyle(locale);
    }

    private MoneyAmountStyle(int zeroCharacter, int positiveCharacter, int negativeCharacter, int decimalPointCharacter, int groupingCharacter, int groupingSize, boolean group, boolean forceDecimalPoint) {
        this.zeroCharacter = zeroCharacter;
        this.positiveCharacter = positiveCharacter;
        this.negativeCharacter = negativeCharacter;
        this.decimalPointCharacter = decimalPointCharacter;
        this.groupingCharacter = groupingCharacter;
        this.groupingSize = groupingSize;
        this.grouping = group;
        this.forceDecimalPoint = forceDecimalPoint;
    }

    public MoneyAmountStyle localize(Locale locale) {
        MoneyFormatter.checkNotNull(locale, "Locale must not be null");
        MoneyAmountStyle result = this;
        MoneyAmountStyle protoStyle = null;
        if (this.zeroCharacter < 0) {
            protoStyle = MoneyAmountStyle.getLocalizedStyle(locale);
            result = result.withZeroCharacter(protoStyle.getZeroCharacter());
        }
        if (this.positiveCharacter < 0) {
            protoStyle = MoneyAmountStyle.getLocalizedStyle(locale);
            result = result.withPositiveSignCharacter(protoStyle.getPositiveSignCharacter());
        }
        if (this.negativeCharacter < 0) {
            protoStyle = MoneyAmountStyle.getLocalizedStyle(locale);
            result = result.withNegativeSignCharacter(protoStyle.getNegativeSignCharacter());
        }
        if (this.decimalPointCharacter < 0) {
            protoStyle = protoStyle == null ? MoneyAmountStyle.getLocalizedStyle(locale) : protoStyle;
            result = result.withDecimalPointCharacter(protoStyle.getDecimalPointCharacter());
        }
        if (this.groupingCharacter < 0) {
            protoStyle = protoStyle == null ? MoneyAmountStyle.getLocalizedStyle(locale) : protoStyle;
            result = result.withGroupingCharacter(protoStyle.getGroupingCharacter());
        }
        if (this.groupingSize < 0) {
            protoStyle = protoStyle == null ? MoneyAmountStyle.getLocalizedStyle(locale) : protoStyle;
            result = result.withGroupingSize(protoStyle.getGroupingSize());
        }
        return result;
    }

    private static MoneyAmountStyle getLocalizedStyle(Locale locale) {
        MoneyAmountStyle protoStyle = (MoneyAmountStyle)LOCALIZED_CACHE.get(locale);
        if (protoStyle == null) {
            DecimalFormatSymbols symbols;
            try {
                Method method = DecimalFormatSymbols.class.getMethod("getInstance", Locale.class);
                symbols = (DecimalFormatSymbols)method.invoke(null, locale);
            }
            catch (Exception ex) {
                symbols = new DecimalFormatSymbols(locale);
            }
            NumberFormat format = NumberFormat.getCurrencyInstance(locale);
            int size = format instanceof DecimalFormat ? ((DecimalFormat)format).getGroupingSize() : 3;
            protoStyle = new MoneyAmountStyle(symbols.getZeroDigit(), 43, symbols.getMinusSign(), symbols.getMonetaryDecimalSeparator(), symbols.getGroupingSeparator(), size, true, false);
            LOCALIZED_CACHE.putIfAbsent(locale, protoStyle);
        }
        return protoStyle;
    }

    public Character getZeroCharacter() {
        return this.zeroCharacter < 0 ? null : Character.valueOf((char)this.zeroCharacter);
    }

    public MoneyAmountStyle withZeroCharacter(Character zeroCharacter) {
        int zeroVal;
        int n = zeroVal = zeroCharacter == null ? -1 : (int)zeroCharacter.charValue();
        if (zeroVal == this.zeroCharacter) {
            return this;
        }
        return new MoneyAmountStyle(zeroVal, this.positiveCharacter, this.negativeCharacter, this.decimalPointCharacter, this.groupingCharacter, this.groupingSize, this.grouping, this.forceDecimalPoint);
    }

    public Character getPositiveSignCharacter() {
        return this.positiveCharacter < 0 ? null : Character.valueOf((char)this.positiveCharacter);
    }

    public MoneyAmountStyle withPositiveSignCharacter(Character positiveCharacter) {
        int positiveVal;
        int n = positiveVal = positiveCharacter == null ? -1 : (int)positiveCharacter.charValue();
        if (positiveVal == this.positiveCharacter) {
            return this;
        }
        return new MoneyAmountStyle(this.zeroCharacter, positiveVal, this.negativeCharacter, this.decimalPointCharacter, this.groupingCharacter, this.groupingSize, this.grouping, this.forceDecimalPoint);
    }

    public Character getNegativeSignCharacter() {
        return this.negativeCharacter < 0 ? null : Character.valueOf((char)this.negativeCharacter);
    }

    public MoneyAmountStyle withNegativeSignCharacter(Character negativeCharacter) {
        int negativeVal;
        int n = negativeVal = negativeCharacter == null ? -1 : (int)negativeCharacter.charValue();
        if (negativeVal == this.negativeCharacter) {
            return this;
        }
        return new MoneyAmountStyle(this.zeroCharacter, this.positiveCharacter, negativeVal, this.decimalPointCharacter, this.groupingCharacter, this.groupingSize, this.grouping, this.forceDecimalPoint);
    }

    public Character getDecimalPointCharacter() {
        return this.decimalPointCharacter < 0 ? null : Character.valueOf((char)this.decimalPointCharacter);
    }

    public MoneyAmountStyle withDecimalPointCharacter(Character decimalPointCharacter) {
        int dpVal;
        int n = dpVal = decimalPointCharacter == null ? -1 : (int)decimalPointCharacter.charValue();
        if (dpVal == this.decimalPointCharacter) {
            return this;
        }
        return new MoneyAmountStyle(this.zeroCharacter, this.positiveCharacter, this.negativeCharacter, dpVal, this.groupingCharacter, this.groupingSize, this.grouping, this.forceDecimalPoint);
    }

    public Character getGroupingCharacter() {
        return this.groupingCharacter < 0 ? null : Character.valueOf((char)this.groupingCharacter);
    }

    public MoneyAmountStyle withGroupingCharacter(Character groupingCharacter) {
        int groupingVal;
        int n = groupingVal = groupingCharacter == null ? -1 : (int)groupingCharacter.charValue();
        if (groupingVal == this.groupingCharacter) {
            return this;
        }
        return new MoneyAmountStyle(this.zeroCharacter, this.positiveCharacter, this.negativeCharacter, this.decimalPointCharacter, groupingVal, this.groupingSize, this.grouping, this.forceDecimalPoint);
    }

    public Integer getGroupingSize() {
        return this.groupingSize < 0 ? null : Integer.valueOf(this.groupingSize);
    }

    public MoneyAmountStyle withGroupingSize(Integer groupingSize) {
        int sizeVal;
        int n = sizeVal = groupingSize == null ? -1 : groupingSize;
        if (groupingSize != null && sizeVal <= 0) {
            throw new IllegalArgumentException("Grouping size must be greater than zero");
        }
        if (sizeVal == this.groupingSize) {
            return this;
        }
        return new MoneyAmountStyle(this.zeroCharacter, this.positiveCharacter, this.negativeCharacter, this.decimalPointCharacter, this.groupingCharacter, sizeVal, this.grouping, this.forceDecimalPoint);
    }

    public boolean isGrouping() {
        return this.grouping;
    }

    public MoneyAmountStyle withGrouping(boolean grouping) {
        if (this.grouping == grouping) {
            return this;
        }
        return new MoneyAmountStyle(this.zeroCharacter, this.positiveCharacter, this.negativeCharacter, this.decimalPointCharacter, this.groupingCharacter, this.groupingSize, grouping, this.forceDecimalPoint);
    }

    public boolean isForcedDecimalPoint() {
        return this.forceDecimalPoint;
    }

    public MoneyAmountStyle withForcedDecimalPoint(boolean forceDecimalPoint) {
        if (this.forceDecimalPoint == forceDecimalPoint) {
            return this;
        }
        return new MoneyAmountStyle(this.zeroCharacter, this.positiveCharacter, this.negativeCharacter, this.decimalPointCharacter, this.groupingCharacter, this.groupingSize, this.grouping, forceDecimalPoint);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MoneyAmountStyle)) {
            return false;
        }
        MoneyAmountStyle otherStyle = (MoneyAmountStyle)other;
        return this.zeroCharacter == otherStyle.zeroCharacter && this.positiveCharacter == otherStyle.positiveCharacter && this.negativeCharacter == otherStyle.negativeCharacter && this.decimalPointCharacter == otherStyle.decimalPointCharacter && this.groupingCharacter == otherStyle.groupingCharacter && this.groupingSize == otherStyle.groupingSize && this.grouping == otherStyle.grouping && this.forceDecimalPoint == otherStyle.forceDecimalPoint;
    }

    public int hashCode() {
        int hash = 13;
        hash += this.zeroCharacter * 17;
        hash += this.positiveCharacter * 17;
        hash += this.negativeCharacter * 17;
        hash += this.decimalPointCharacter * 17;
        hash += this.groupingCharacter * 17;
        hash += this.groupingSize * 17;
        hash += this.grouping ? 1 : 0;
        return hash += this.forceDecimalPoint ? 2 : 4;
    }

    public String toString() {
        return "MoneyAmountStyle['" + this.getZeroCharacter() + "','" + this.getPositiveSignCharacter() + "','" + this.getNegativeSignCharacter() + "','" + this.getDecimalPointCharacter() + "','" + this.getGroupingCharacter() + "','" + this.getGroupingSize() + "'," + this.isGrouping() + "," + this.isForcedDecimalPoint() + "]";
    }
}

