/*
 * Decompiled with CFR 0.152.
 */
package org.joda.money.format;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import org.joda.money.BigMoney;
import org.joda.money.format.MoneyFormatter;
import org.joda.money.format.MoneyParseContext;
import org.joda.money.format.MoneyParser;
import org.joda.money.format.MoneyPrintContext;
import org.joda.money.format.MoneyPrinter;

final class SignedPrinterParser
implements MoneyPrinter,
MoneyParser,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MoneyFormatter whenPositive;
    private final MoneyFormatter whenZero;
    private final MoneyFormatter whenNegative;

    SignedPrinterParser(MoneyFormatter whenPositive, MoneyFormatter whenZero, MoneyFormatter whenNegative) {
        this.whenPositive = whenPositive;
        this.whenZero = whenZero;
        this.whenNegative = whenNegative;
    }

    @Override
    public void print(MoneyPrintContext context, Appendable appendable, BigMoney money) throws IOException {
        MoneyFormatter fmt = money.isZero() ? this.whenZero : (money.isPositive() ? this.whenPositive : this.whenNegative);
        fmt.getPrinterParser().print(context, appendable, money);
    }

    @Override
    public void parse(MoneyParseContext context) {
        MoneyParseContext positiveContext = context.createChild();
        this.whenPositive.getPrinterParser().parse(positiveContext);
        MoneyParseContext zeroContext = context.createChild();
        this.whenZero.getPrinterParser().parse(zeroContext);
        MoneyParseContext negativeContext = context.createChild();
        this.whenNegative.getPrinterParser().parse(negativeContext);
        MoneyParseContext best = null;
        if (!positiveContext.isError()) {
            best = positiveContext;
        }
        if (!(zeroContext.isError() || best != null && zeroContext.getIndex() <= best.getIndex())) {
            best = zeroContext;
        }
        if (!(negativeContext.isError() || best != null && negativeContext.getIndex() <= best.getIndex())) {
            best = negativeContext;
        }
        if (best == null) {
            context.setError();
        } else {
            context.mergeChild(best);
            if (best == zeroContext) {
                if (context.getAmount() == null || context.getAmount().compareTo(BigDecimal.ZERO) != 0) {
                    context.setAmount(BigDecimal.ZERO);
                }
            } else if (best == negativeContext && context.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                context.setAmount(context.getAmount().negate());
            }
        }
    }

    public String toString() {
        return "PositiveZeroNegative(" + this.whenPositive + "," + this.whenZero + "," + this.whenNegative + ")";
    }
}

