/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.task;

import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.filter.RefreshFilter;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.job.TargetDocumentSpecs;
import org.jodconverter.office.LocalOfficeContext;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.OfficeException;
import org.jodconverter.task.AbstractLocalOfficeTask;
import org.jodconverter.task.LocalOfficeTaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConversionTask
extends AbstractLocalOfficeTask {
    private static final String ERROR_MESSAGE_STORE = "Could not store document: ";
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalConversionTask.class);
    private final TargetDocumentSpecs target;
    private final FilterChain filterChain;
    private final Map<String, Object> storeProperties;

    public LocalConversionTask(SourceDocumentSpecs source, TargetDocumentSpecs target, Map<String, Object> loadProperties, FilterChain filterChain, Map<String, Object> storeProperties) {
        super(source, loadProperties);
        this.target = target;
        this.filterChain = filterChain == null ? RefreshFilter.CHAIN : filterChain;
        this.storeProperties = storeProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OfficeContext context) throws OfficeException {
        LOGGER.info("Executing local conversion task...");
        LocalOfficeContext localContext = (LocalOfficeContext)context;
        File sourceFile = this.source.getFile();
        try {
            File targetFile = this.target.getFile();
            XComponent document = null;
            try {
                document = this.loadDocument(localContext, sourceFile);
                this.modifyDocument(context, document);
                this.storeDocument(document, targetFile);
                this.target.onComplete(targetFile);
            }
            catch (OfficeException officeEx) {
                LOGGER.error("Conversion failed.", (Throwable)officeEx);
                this.target.onFailure(targetFile, (Exception)((Object)officeEx));
                throw officeEx;
            }
            catch (Exception ex) {
                LOGGER.error("Conversion failed.", (Throwable)ex);
                OfficeException officeEx = new OfficeException("Conversion failed", (Throwable)ex);
                this.target.onFailure(targetFile, (Exception)((Object)officeEx));
                throw officeEx;
            }
            finally {
                this.closeDocument(document);
            }
        }
        finally {
            this.source.onConsumed(sourceFile);
        }
    }

    private Map<String, Object> getStoreProperties(XComponent document) throws OfficeException {
        HashMap<String, Object> storeProps = new HashMap<String, Object>();
        LocalConversionTask.addPropertiesToMap(storeProps, this.target.getFormat().getStoreProperties(LocalOfficeTaskUtils.getDocumentFamily(document)));
        LocalConversionTask.addPropertiesToMap(storeProps, this.storeProperties);
        return storeProps;
    }

    void modifyDocument(OfficeContext context, XComponent document) throws OfficeException {
        this.filterChain.doFilter(context, document);
    }

    void storeDocument(XComponent document, File targetFile) throws OfficeException {
        Map<String, Object> storeProps = this.getStoreProperties(document);
        Validate.notNull(storeProps, (String)"Unsupported conversion", (Object[])new Object[0]);
        try {
            ((XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)document)).storeToURL(LocalOfficeUtils.toUrl(targetFile), LocalOfficeUtils.toUnoProperties(storeProps));
        }
        catch (ErrorCodeIOException errorCodeIoEx) {
            throw new OfficeException(ERROR_MESSAGE_STORE + targetFile.getName() + "; errorCode: " + errorCodeIoEx.ErrCode, (Throwable)errorCodeIoEx);
        }
        catch (IOException ioEx) {
            throw new OfficeException(ERROR_MESSAGE_STORE + targetFile.getName(), (Throwable)ioEx);
        }
    }
}

