/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentInserterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentInserterFilter.class);
    private final File documentToInsert;

    public DocumentInserterFilter(File document) {
        this.documentToInsert = document;
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        LOGGER.debug("Applying the DocumentInserterFilter");
        XTextDocument docText = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)document);
        XTextCursor textCursor = docText.getText().createTextCursor();
        textCursor.gotoEnd(false);
        XDocumentInsertable insertable = (XDocumentInsertable)UnoRuntime.queryInterface(XDocumentInsertable.class, (Object)textCursor);
        insertable.insertDocumentFromURL(LocalOfficeUtils.toUrl(this.documentToInsert), new PropertyValue[0]);
        chain.doFilter(context, document);
    }
}

