/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XComponent;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.OfficeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageMarginsFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageMarginsFilter.class);
    private final Integer topMargin;
    private final Integer rightMargin;
    private final Integer bottomMargin;
    private final Integer leftMargin;

    public PageMarginsFilter(Integer leftMargin, Integer topMargin, Integer rightMargin, Integer bottomMargin) {
        this.leftMargin = leftMargin;
        this.topMargin = topMargin;
        this.rightMargin = rightMargin;
        this.bottomMargin = bottomMargin;
    }

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        LOGGER.debug("Applying the PageSelectorFilter");
        XTextDocument docText = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)document);
        XTextCursor xTextCursor = docText.getText().createTextCursor();
        XPropertySet xTextCursorProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
        String pageStyleName = xTextCursorProps.getPropertyValue("PageStyleName").toString();
        XStyleFamiliesSupplier xSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)docText);
        XNameAccess xFamilies = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xSupplier.getStyleFamilies());
        XNameContainer xFamily = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xFamilies.getByName("PageStyles"));
        XStyle xStyle = (XStyle)UnoRuntime.queryInterface(XStyle.class, (Object)xFamily.getByName(pageStyleName));
        LOGGER.debug("Changing margins using: [left={}, top={}, right={}, bottom={}]", new Object[]{this.leftMargin, this.topMargin, this.rightMargin, this.bottomMargin});
        XPropertySet xStyleProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xStyle);
        if (this.leftMargin != null) {
            xStyleProps.setPropertyValue("LeftMargin", (Object)(this.leftMargin * 100));
        }
        if (this.topMargin != null) {
            xStyleProps.setPropertyValue("TopMargin", (Object)(this.topMargin * 100));
        }
        if (this.rightMargin != null) {
            xStyleProps.setPropertyValue("RightMargin", (Object)(this.rightMargin * 100));
        }
        if (this.bottomMargin != null) {
            xStyleProps.setPropertyValue("BottomMargin", (Object)(this.bottomMargin * 100));
        }
        chain.doFilter(context, document);
    }
}

