/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import org.jodconverter.office.ExternalOfficeManager;
import org.jodconverter.office.OfficeConnectionProtocol;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeUrl;

public class ExternalOfficeManagerBuilder {
    private OfficeConnectionProtocol connectionProtocol = OfficeConnectionProtocol.SOCKET;
    private int portNumber = 2002;
    private String pipeName = "office";
    private boolean connectOnStart = true;
    private long connectTimeout = 30000L;

    public OfficeManager build() {
        OfficeUrl officeUrl = this.connectionProtocol == OfficeConnectionProtocol.SOCKET ? new OfficeUrl(this.portNumber) : new OfficeUrl(this.pipeName);
        return new ExternalOfficeManager(officeUrl, this.connectOnStart, this.connectTimeout);
    }

    public ExternalOfficeManagerBuilder setConnectionProtocol(OfficeConnectionProtocol connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public ExternalOfficeManagerBuilder setConnectOnStart(boolean connectOnStart) {
        this.connectOnStart = connectOnStart;
        return this;
    }

    public ExternalOfficeManagerBuilder setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ExternalOfficeManagerBuilder setPipeName(String pipeName) {
        this.pipeName = pipeName;
        return this;
    }

    public ExternalOfficeManagerBuilder setPortNumber(int portNumber) {
        this.portNumber = portNumber;
        return this;
    }
}

