/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.task;

import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.jodconverter.LocalConverter;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.office.LocalOfficeContext;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeException;
import org.jodconverter.task.AbstractOfficeTask;

public abstract class AbstractLocalOfficeTask
extends AbstractOfficeTask {
    private static final String ERROR_MESSAGE_LOAD = "Could not open document: ";
    protected final Map<String, Object> loadProperties;

    protected static void appendProperties(Map<String, Object> properties, Map<String, Object> toAddProperties) {
        Optional.ofNullable(toAddProperties).ifPresent(properties::putAll);
    }

    public AbstractLocalOfficeTask(SourceDocumentSpecs source) {
        this(source, null);
    }

    public AbstractLocalOfficeTask(SourceDocumentSpecs source, Map<String, Object> loadProperties) {
        super(source);
        this.loadProperties = loadProperties;
    }

    protected Map<String, Object> getLoadProperties() {
        HashMap<String, Object> loadProps = new HashMap<String, Object>(Optional.ofNullable(this.loadProperties).orElse(LocalConverter.DEFAULT_LOAD_PROPERTIES));
        Optional.ofNullable(this.source.getFormat()).ifPresent(fmt -> AbstractLocalOfficeTask.appendProperties(loadProps, fmt.getLoadProperties()));
        return loadProps;
    }

    protected XComponent loadDocument(LocalOfficeContext context, File sourceFile) throws OfficeException {
        try {
            XComponent document = context.getComponentLoader().loadComponentFromURL(LocalOfficeUtils.toUrl(sourceFile), "_blank", 0, LocalOfficeUtils.toUnoProperties(this.getLoadProperties()));
            Validate.notNull((Object)document, (String)(ERROR_MESSAGE_LOAD + sourceFile.getName()), (Object[])new Object[0]);
            return document;
        }
        catch (ErrorCodeIOException exception) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName() + "; errorCode: " + exception.ErrCode, (Throwable)exception);
        }
        catch (IOException | IllegalArgumentException exception) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName(), exception);
        }
    }

    protected void closeDocument(XComponent document) {
        if (document != null) {
            XCloseable closeable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)document);
            if (closeable == null) {
                ((XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)document)).dispose();
            } else {
                try {
                    closeable.close(true);
                }
                catch (CloseVetoException closeVetoException) {
                    // empty catch block
                }
            }
        }
    }
}

