/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.graphic.XGraphic;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextGraphicObjectsSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.XComponentContext;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.LocalOfficeContext;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.utils.Info;
import org.jodconverter.office.utils.Lo;
import org.jodconverter.office.utils.Props;
import org.jodconverter.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedImagesEmbedderFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkedImagesEmbedderFilter.class);

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        LOGGER.debug("Applying the LinkedImagesEmbedderFilter");
        if (Write.isText(document)) {
            LinkedImagesEmbedderFilter.convertLinkedImagesToEmbedded(((LocalOfficeContext)context).getComponentContext(), document);
        }
        chain.doFilter(context, document);
    }

    private static void convertLinkedImagesToEmbedded(XComponentContext context, XComponent document) throws Exception {
        XGraphicProvider graphicProvider = Lo.createInstanceMCF(context, XGraphicProvider.class, "com.sun.star.graphic.GraphicProvider");
        XIndexAccess indexAccess = Lo.qi(XIndexAccess.class, Lo.qi(XTextGraphicObjectsSupplier.class, document).getGraphicObjects());
        for (int i = 0; i < indexAccess.getCount(); ++i) {
            XNameContainer bitmapContainer;
            Any xImageAny = (Any)indexAccess.getByIndex(i);
            Object xImageObject = xImageAny.getObject();
            XTextContent xImage = (XTextContent)xImageObject;
            XServiceInfo xInfo = Lo.qi(XServiceInfo.class, xImage);
            if (!xInfo.supportsService("com.sun.star.text.TextGraphicObject")) continue;
            XPropertySet xPropSet = Lo.qi(XPropertySet.class, xImage);
            if (Info.isLibreOffice(context) && Info.compareVersions(Info.getOfficeVersionShort(context), "6.1", 2) >= 0) {
                XGraphic xGraphic = (XGraphic)AnyConverter.toObject(XGraphic.class, (Object)xPropSet.getPropertyValue("Graphic"));
                XPropertySet xGraphixPropSet = Lo.qi(XPropertySet.class, xGraphic);
                boolean linked = (Boolean)xGraphixPropSet.getPropertyValue("Linked");
                if (!linked) continue;
                xPropSet.setPropertyValue("Graphic", (Object)graphicProvider.queryGraphic(Props.makeProperties("URL", xGraphixPropSet.getPropertyValue("OriginURL").toString(), "LoadAsLink", false)));
                continue;
            }
            String name = xPropSet.getPropertyValue("LinkDisplayName").toString();
            String graphicURL = xPropSet.getPropertyValue("GraphicURL").toString();
            if (graphicURL.indexOf("vnd.sun.") != -1 || (bitmapContainer = Lo.createInstanceMSF(document, XNameContainer.class, "com.sun.star.drawing.BitmapTable")).hasByName(name)) continue;
            bitmapContainer.insertByName(name, (Object)graphicURL);
            xPropSet.setPropertyValue("GraphicURL", (Object)bitmapContainer.getByName(name).toString());
        }
    }
}

