/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.filter;

import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XSpreadsheetDocument;
import org.jodconverter.filter.Filter;
import org.jodconverter.filter.FilterChain;
import org.jodconverter.office.OfficeContext;
import org.jodconverter.office.utils.Calc;
import org.jodconverter.office.utils.Draw;
import org.jodconverter.office.utils.Lo;
import org.jodconverter.office.utils.Props;
import org.jodconverter.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCounterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageCounterFilter.class);
    private int pageCount;

    @Override
    public void doFilter(OfficeContext context, XComponent document, FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            LOGGER.debug("Applying the PageCounterFilter for a Text document");
            this.pageCount = (Integer)Props.getProperty(Lo.qi(XModel.class, document).getCurrentController(), "PageCount").orElse(0);
        } else if (Calc.isCalc(document)) {
            LOGGER.debug("Applying the PageCounterFilter for a Calc document");
            XSpreadsheetDocument doc = Calc.getCalcDoc(document);
            this.pageCount = doc.getSheets().getElementNames().length;
        } else if (Draw.isImpress(document)) {
            LOGGER.debug("Applying the PageCounterFilter for an Impress document");
            XDrawPages xDrawPages = Lo.qi(XDrawPagesSupplier.class, document).getDrawPages();
            this.pageCount = xDrawPages.getCount();
        } else if (Draw.isDraw(document)) {
            LOGGER.debug("Applying the PageCounterFilter for a Draw document");
            XDrawPages xDrawPages = Lo.qi(XDrawPagesSupplier.class, document).getDrawPages();
            this.pageCount = xDrawPages.getCount();
        }
        chain.doFilter(context, document);
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

