/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter;

import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XSpreadsheetDocument;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.utils.Calc;
import org.jodconverter.local.office.utils.Draw;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Props;
import org.jodconverter.local.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCounterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageCounterFilter.class);
    private int pageCount;

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            LOGGER.debug("Applying the PageCounterFilter for a Text document");
            this.pageCount = (Integer)Props.getProperty(Lo.qi(XModel.class, document).getCurrentController(), "PageCount");
        } else if (Calc.isCalc(document)) {
            LOGGER.debug("Applying the PageCounterFilter for a Calc document");
            XSpreadsheetDocument doc = Calc.getCalcDoc(document);
            this.pageCount = Objects.requireNonNull(doc).getSheets().getElementNames().length;
        } else if (Draw.isImpress(document)) {
            LOGGER.debug("Applying the PageCounterFilter for an Impress document");
            XDrawPages xDrawPages = Lo.qi(XDrawPagesSupplier.class, document).getDrawPages();
            this.pageCount = xDrawPages.getCount();
        } else if (Draw.isDraw(document)) {
            LOGGER.debug("Applying the PageCounterFilter for a Draw document");
            XDrawPages xDrawPages = Lo.qi(XDrawPagesSupplier.class, document).getDrawPages();
            this.pageCount = xDrawPages.getCount();
        }
        chain.doFilter(context, document);
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

