/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter.text;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import java.io.File;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.local.filter.Filter;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentInserterFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentInserterFilter.class);
    private final File documentToInsert;

    public DocumentInserterFilter(@NonNull File document) {
        this.documentToInsert = document;
    }

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        LOGGER.debug("Applying the DocumentInserterFilter");
        if (Write.isText(document)) {
            this.insertDocument(document);
        }
        chain.doFilter(context, document);
    }

    private void insertDocument(XComponent document) throws Exception {
        XTextDocument docText = Write.getTextDoc(document);
        Objects.requireNonNull(docText);
        XTextCursor textCursor = docText.getText().createTextCursor();
        textCursor.gotoEnd(false);
        XDocumentInsertable insertable = Lo.qi(XDocumentInsertable.class, textCursor);
        insertable.insertDocumentFromURL(LocalOfficeUtils.toUrl(this.documentToInsert), new PropertyValue[0]);
    }
}

