/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.beans.XHierarchicalPropertySetInfo;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.AbstractOfficeManagerPoolEntry;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.task.OfficeTask;
import org.jodconverter.local.office.OfficeConnectionEvent;
import org.jodconverter.local.office.OfficeConnectionEventListener;
import org.jodconverter.local.office.OfficeProcessManager;
import org.jodconverter.local.office.OfficeUrl;
import org.jodconverter.local.office.utils.Info;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.process.ProcessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OfficeProcessManagerPoolEntry
extends AbstractOfficeManagerPoolEntry {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeProcessManagerPoolEntry.class);
    private static final int DEFAULT_MAX_TASKS_PER_PROCESS = 200;
    private static final boolean DEFAULT_DISABLE_OPENGL = false;
    private static final String PROP_PATH_USE_OPENGL = "VCL/UseOpenGL";
    private final int maxTasksPerProcess;
    private final boolean disableOpengl;
    private final OfficeProcessManager officeProcessManager;
    private final AtomicInteger taskCount = new AtomicInteger(0);
    private final AtomicBoolean disconnectExpected = new AtomicBoolean(false);

    OfficeProcessManagerPoolEntry(OfficeUrl officeUrl, File officeHome, File workingDir, ProcessManager processManager, List<String> runAsArgs, File templateProfileDir, Boolean killExistingProcess, Long processTimeout, Long processRetryInterval, Long taskExecutionTimeout, Integer maxTasksPerProcess, Boolean disableOpengl) {
        super(taskExecutionTimeout);
        this.officeProcessManager = new OfficeProcessManager(officeUrl, officeHome, workingDir, processManager, runAsArgs, templateProfileDir, killExistingProcess, processTimeout, processRetryInterval);
        this.maxTasksPerProcess = maxTasksPerProcess == null ? 200 : maxTasksPerProcess;
        this.disableOpengl = disableOpengl == null ? false : disableOpengl;
        OfficeConnectionEventListener connectionEventListener = new OfficeConnectionEventListener(){

            @Override
            public void connected(OfficeConnectionEvent event) {
                OfficeProcessManagerPoolEntry.this.taskCount.set(0);
                OfficeProcessManagerPoolEntry.this.setAvailable(true);
            }

            @Override
            public void disconnected(OfficeConnectionEvent event) {
                OfficeProcessManagerPoolEntry.this.setAvailable(false);
                if (!OfficeProcessManagerPoolEntry.this.disconnectExpected.compareAndSet(true, false)) {
                    LOGGER.warn("Connection lost unexpectedly; attempting restart");
                    OfficeProcessManagerPoolEntry.this.cancelTask();
                    OfficeProcessManagerPoolEntry.this.officeProcessManager.restartDueToLostConnection();
                }
            }
        };
        this.officeProcessManager.getConnection().addConnectionEventListener(connectionEventListener);
    }

    public void doExecute(@NonNull OfficeTask task) throws OfficeException {
        int count = this.taskCount.getAndIncrement();
        if (this.maxTasksPerProcess > 0 && count == this.maxTasksPerProcess) {
            LOGGER.info("Reached limit of {} maximum tasks per process; restarting...", (Object)this.maxTasksPerProcess);
            this.restart();
            this.taskCount.getAndIncrement();
        }
        task.execute((OfficeContext)this.officeProcessManager.getConnection());
    }

    protected void handleExecuteTimeoutException(@NonNull TimeoutException timeoutEx) {
        this.officeProcessManager.restartDueToTaskTimeout();
    }

    public boolean isRunning() {
        return super.isRunning() && this.officeProcessManager.getConnection().isConnected();
    }

    public void doStart() throws OfficeException {
        this.officeProcessManager.startAndWait();
        if (this.disableOpengl && this.disableOpengl(this.officeProcessManager.getConnection().getComponentContext())) {
            LOGGER.info("OpenGL has been disabled and a restart is required; restarting...");
            this.restart();
        }
    }

    public void doStop() throws OfficeException {
        this.disconnectExpected.set(true);
        this.officeProcessManager.stopAndWait();
    }

    private void restart() throws OfficeException {
        this.setAvailable(false);
        this.disconnectExpected.set(true);
        this.officeProcessManager.restartAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean disableOpengl(XComponentContext officeContext) throws OfficeException {
        try {
            Object viewRoot = Info.getConfigUpdateAccess(officeContext, "/org.openoffice.Office.Common");
            if (viewRoot == null) {
                return false;
            }
            try {
                XHierarchicalPropertySet properties = Lo.qi(XHierarchicalPropertySet.class, viewRoot);
                XHierarchicalPropertySetInfo propsInfo = properties.getHierarchicalPropertySetInfo();
                if (!propsInfo.hasPropertyByHierarchicalName(PROP_PATH_USE_OPENGL)) return false;
                boolean useOpengl = (Boolean)properties.getHierarchicalPropertyValue(PROP_PATH_USE_OPENGL);
                LOGGER.info("Use OpenGL is set to {}", (Object)useOpengl);
                if (!useOpengl) return false;
                properties.setHierarchicalPropertyValue(PROP_PATH_USE_OPENGL, (Object)false);
                XChangesBatch updateControl = Lo.qi(XChangesBatch.class, viewRoot);
                updateControl.commitChanges();
                boolean bl = true;
                return bl;
            }
            finally {
                Lo.qi(XComponent.class, viewRoot).dispose();
            }
        }
        catch (Exception ex) {
            throw new OfficeException("Unable to check if the Use OpenGL option is on.", (Throwable)ex);
        }
    }
}

