/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.AbstractRetryable;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.office.TemporaryException;
import org.jodconverter.local.office.VerboseProcess;
import org.jodconverter.local.process.ProcessManager;
import org.jodconverter.local.process.ProcessQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartProcessRetryable
extends AbstractRetryable<Exception> {
    private static final int FIND_PID_RETRIES = 10;
    private static final long FIND_PID_DELAY = 2000L;
    private static final long FIND_PID_INTERVAL = 250L;
    private static final Integer EXIT_CODE_81 = 81;
    private static final Logger LOGGER = LoggerFactory.getLogger(StartProcessRetryable.class);
    private final ProcessManager processManager;
    private final ProcessBuilder processBuilder;
    private final ProcessQuery processQuery;
    private VerboseProcess process;
    private Integer exitCode;
    private long processId = -1L;

    public StartProcessRetryable(@NonNull ProcessManager processManager, @NonNull ProcessBuilder processBuilder, @NonNull ProcessQuery processQuery) {
        this.processManager = processManager;
        this.processBuilder = processBuilder;
        this.processQuery = processQuery;
    }

    protected void attempt() throws Exception {
        this.exitCode = null;
        this.processId = -1L;
        this.process = new VerboseProcess(this.processBuilder.start());
        if (SystemUtils.IS_OS_FREE_BSD) {
            LOGGER.debug("Waiting for process to start on FreeBSD...");
            this.sleep(2000L);
        }
        this.tryFindPid();
        if (this.exitCode != null) {
            if (this.exitCode.equals(EXIT_CODE_81)) {
                LOGGER.warn("Office process died with exit code 81; restarting it");
                throw new TemporaryException("Office process died with exit code 81");
            }
            throw new OfficeException("Office process died with exit code: " + this.exitCode);
        }
        if (this.processManager.canFindPid() && this.processId <= -1L) {
            try {
                this.process.getProcess().destroy();
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to destroy the process", (Throwable)ex);
            }
            throw new TemporaryException(String.format("A process with --accept '%s' started but its pid could not be found; restarting it", this.processQuery.getArgument()));
        }
    }

    public @NonNull VerboseProcess getProcess() {
        return this.process;
    }

    public long getProcessId() {
        return this.processId;
    }

    private void tryFindPid() throws IOException {
        int tryCount = 0;
        while (true) {
            LOGGER.debug("Trying to find pid, attempt #{}", (Object)(++tryCount));
            try {
                this.exitCode = this.process.getProcess().exitValue();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (!this.processManager.canFindPid()) {
                    LOGGER.debug("The current process manager does not support finding the pid: {}", (Object)this.processManager.getClass().getName());
                    return;
                }
                this.processId = this.processManager.findPid(this.processQuery);
                if (this.processId > -1L || tryCount == 10) {
                    return;
                }
                this.sleep(250L);
                continue;
            }
            break;
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

