/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.task;

import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.job.SourceDocumentSpecs;
import org.jodconverter.core.office.OfficeException;
import org.jodconverter.core.task.AbstractOfficeTask;
import org.jodconverter.local.LocalConverter;
import org.jodconverter.local.office.LocalOfficeContext;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.utils.Lo;

public abstract class AbstractLocalOfficeTask
extends AbstractOfficeTask {
    private static final String ERROR_MESSAGE_LOAD = "Could not open document: ";
    protected final Map<String, Object> loadProperties;

    protected static void appendProperties(@NonNull Map<@NonNull String, @NonNull Object> properties, @Nullable Map<@NonNull String, @NonNull Object> toAddProperties) {
        if (toAddProperties != null) {
            properties.putAll(toAddProperties);
        }
    }

    public AbstractLocalOfficeTask(@NonNull SourceDocumentSpecs source) {
        this(source, null);
    }

    public AbstractLocalOfficeTask(@NonNull SourceDocumentSpecs source, @Nullable Map<@NonNull String, @NonNull Object> loadProperties) {
        super(source);
        this.loadProperties = loadProperties;
    }

    protected @NonNull Map<@NonNull String, @NonNull Object> getLoadProperties() {
        HashMap<String, Object> loadProps = new HashMap<String, Object>(this.loadProperties == null ? LocalConverter.DEFAULT_LOAD_PROPERTIES : this.loadProperties);
        if (this.source.getFormat() != null) {
            AbstractLocalOfficeTask.appendProperties(loadProps, this.source.getFormat().getLoadProperties());
        }
        return loadProps;
    }

    protected @NonNull XComponent loadDocument(@NonNull LocalOfficeContext context, @NonNull File sourceFile) throws OfficeException {
        try {
            XComponent document = context.getComponentLoader().loadComponentFromURL(LocalOfficeUtils.toUrl(sourceFile), "_blank", 0, LocalOfficeUtils.toUnoProperties(this.getLoadProperties()));
            Validate.notNull((Object)document, (String)(ERROR_MESSAGE_LOAD + sourceFile.getName()), (Object[])new Object[0]);
            return document;
        }
        catch (ErrorCodeIOException exception) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName() + "; errorCode: " + exception.ErrCode, (Throwable)exception);
        }
        catch (IOException | IllegalArgumentException exception) {
            throw new OfficeException(ERROR_MESSAGE_LOAD + sourceFile.getName(), exception);
        }
    }

    protected void closeDocument(@Nullable XComponent document) {
        if (document != null) {
            XCloseable closeable = Lo.qiOptional(XCloseable.class, document).orElse(null);
            if (closeable == null) {
                Lo.qi(XComponent.class, document).dispose();
            } else {
                try {
                    closeable.close(true);
                }
                catch (CloseVetoException closeVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public @NonNull String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{source=" + this.source + ", loadProperties=" + this.loadProperties + '}';
    }
}

