/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office.utils;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.local.office.utils.UnoRuntime;
import org.jodconverter.local.office.utils.WrappedUnoException;

public final class Lo {
    public static final String WRITER_SERVICE = "com.sun.star.text.GenericTextDocument";
    public static final String WEB_SERVICE = "com.sun.star.text.WebDocument";
    public static final String CALC_SERVICE = "com.sun.star.sheet.SpreadsheetDocument";
    public static final String DRAW_SERVICE = "com.sun.star.drawing.DrawingDocument";
    public static final String IMPRESS_SERVICE = "com.sun.star.presentation.PresentationDocument";

    public static <T> @NonNull T qi(@NonNull Class<T> type, @NonNull Object object) {
        AssertUtils.notNull(type, (String)"type must not be null");
        AssertUtils.notNull(type, (String)"object must not be null");
        T obj = UnoRuntime.getInstance().queryInterface(type, object);
        AssertUtils.notNull(obj, (String)String.format("UNO object of type %s must not be null for object of type %s", type.getName(), object.getClass().getName()));
        return obj;
    }

    public static <T> @NonNull Optional<T> qiOptional(@NonNull Class<T> type, @NonNull Object object) {
        return Optional.ofNullable(UnoRuntime.getInstance().queryInterface(type, object));
    }

    public static @NonNull XMultiServiceFactory getServiceFactory(@NonNull XComponent component) {
        return Lo.qi(XMultiServiceFactory.class, component);
    }

    public static <T> @NonNull T createInstanceMSF(@NonNull XComponent component, @NonNull Class<T> type, @NonNull String serviceName) {
        return Lo.createInstanceMSF(Lo.getServiceFactory(component), type, serviceName);
    }

    public static <T> @NonNull T createInstanceMSF(@NonNull XMultiServiceFactory factory, @NonNull Class<T> type, @NonNull String serviceName) {
        try {
            return Lo.qi(type, factory.createInstance(serviceName));
        }
        catch (Exception ex) {
            throw new WrappedUnoException(ex.getMessage(), ex);
        }
    }

    public static <T> @Nullable T createInstanceMCF(@NonNull XComponentContext context, @NonNull Class<T> type, @NonNull String serviceName) {
        try {
            return Lo.qiOptional(type, context.getServiceManager().createInstanceWithContext(serviceName, context)).orElse(null);
        }
        catch (Exception ex) {
            throw new WrappedUnoException(ex);
        }
    }

    private Lo() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

