/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter;

import org.jodconverter.document.DocumentFormatRegistry;
import org.jodconverter.job.AbstractConversionJob;
import org.jodconverter.job.AbstractConversionJobWithSourceFormatUnspecified;
import org.jodconverter.job.AbstractConverter;
import org.jodconverter.job.AbstractSourceDocumentSpecs;
import org.jodconverter.job.AbstractTargetDocumentSpecs;
import org.jodconverter.job.SourceDocumentSpecs;
import org.jodconverter.job.TargetDocumentSpecs;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.task.OfficeTask;
import org.jodconverter.task.OnlineConversionTask;

public class OnlineConverter
extends AbstractConverter {
    public static Builder builder() {
        return new Builder();
    }

    public static OnlineConverter make() {
        return OnlineConverter.builder().build();
    }

    public static OnlineConverter make(OfficeManager officeManager) {
        return ((Builder)OnlineConverter.builder().officeManager(officeManager)).build();
    }

    private OnlineConverter(OfficeManager officeManager, DocumentFormatRegistry formatRegistry) {
        super(officeManager, formatRegistry);
    }

    protected AbstractConversionJobWithSourceFormatUnspecified convert(AbstractSourceDocumentSpecs source) {
        return new OnlineConversionJobWithSourceFormatUnspecified(source);
    }

    public static final class Builder
    extends AbstractConverter.AbstractConverterBuilder<Builder> {
        private Builder() {
        }

        public OnlineConverter build() {
            return new OnlineConverter(this.officeManager, this.formatRegistry);
        }
    }

    private class OnlineConversionJob
    extends AbstractConversionJob {
        private OnlineConversionJob(AbstractSourceDocumentSpecs source, AbstractTargetDocumentSpecs target) {
            super(source, target);
        }

        public void doExecute() throws OfficeException {
            OnlineConversionTask task = new OnlineConversionTask((SourceDocumentSpecs)this.source, (TargetDocumentSpecs)this.target);
            OnlineConverter.this.officeManager.execute((OfficeTask)task);
        }
    }

    private class OnlineConversionJobWithSourceFormatUnspecified
    extends AbstractConversionJobWithSourceFormatUnspecified {
        private OnlineConversionJobWithSourceFormatUnspecified(AbstractSourceDocumentSpecs source) {
            super(source, OnlineConverter.this.officeManager, OnlineConverter.this.formatRegistry);
        }

        protected AbstractConversionJob to(AbstractTargetDocumentSpecs target) {
            return new OnlineConversionJob(this.source, target);
        }
    }
}

